/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing.document;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.network.http.RestRequestParams;

public class UploadDocumentTaskBundle
extends UploadFileTaskBundle {
    private String eventId;
    private long originalMessageTime;
    private long fileRowId;

    public String getEventId() {
        return this.eventId;
    }

    public long getOriginalMessageTime() {
        return this.originalMessageTime;
    }

    public long getFileRowId() {
        return this.fileRowId;
    }

    @Override
    public UploadDocumentTaskBundle addBrandId(String brandId) {
        super.addBrandId(brandId);
        return this;
    }

    @Override
    public UploadDocumentTaskBundle addTargetId(String targetId) {
        super.addTargetId(targetId);
        return this;
    }

    @Override
    public UploadDocumentTaskBundle addSwiftDomain(String swiftDomain) {
        super.addSwiftDomain(swiftDomain);
        return this;
    }

    @Override
    public UploadDocumentTaskBundle addRestDomain(RestRequestParams restRequestParams) {
        super.addRestDomain(restRequestParams);
        return this;
    }

    @Override
    public UploadDocumentTaskBundle addFileUri(Uri fileUri) {
        super.addFileUri(fileUri);
        return this;
    }

    @Override
    public UploadDocumentTaskBundle addMessage(MaskedMessage maskedMessage) {
        super.addMessage(maskedMessage);
        return this;
    }

    public UploadDocumentTaskBundle addEventID(String eventId) {
        this.eventId = eventId;
        return this;
    }

    public UploadDocumentTaskBundle addFileRowId(long fileRowId) {
        this.fileRowId = fileRowId;
        return this;
    }

    public UploadDocumentTaskBundle addOriginalMessageTime(long originalMessageTime) {
        this.originalMessageTime = originalMessageTime;
        return this;
    }

    @Override
    public UploadDocumentTaskBundle build(int taskId, Context context) {
        this.setTaskID(taskId);
        this.mFilePath = this.mFileUri.toString();
        String fileScheme = this.mFileUri.getScheme();
        if (fileScheme != null && fileScheme.equals("content")) {
            String extensionFromMimeType;
            ContentResolver cR = context.getContentResolver();
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            this.mFileContentType = cR.getType(this.mFileUri);
            if (this.mFileContentType != null && (extensionFromMimeType = mime.getExtensionFromMimeType(this.mFileContentType)) != null) {
                this.mFileTypeExtension = extensionFromMimeType.toUpperCase();
            }
        } else {
            String fileExtensionFromUrl = MimeTypeMap.getFileExtensionFromUrl((String)this.mFileUri.toString());
            if (fileExtensionFromUrl != null) {
                this.mFileTypeExtension = fileExtensionFromUrl.toUpperCase();
            }
            if (this.mFileTypeExtension != null) {
                this.mFileContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(this.mFileTypeExtension.toLowerCase());
            }
        }
        return this;
    }
}

