/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.liveperson.api.response.model.Event;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.analytics.LPAnalytics;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.eventmanager.Event;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.infra.model.PushMessage;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.network.http.AgentProfileRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationUtils {
    private static final String TAG = "ConversationUtils";
    protected final Messaging mController;

    public ConversationUtils(Messaging controller) {
        this.mController = controller;
    }

    public void addWelcomeMessage(String brandId, String message) {
        this.mController.amsMessages.hasStoredWelcomeMessage().setPostQueryOnBackground(hasStoredWelcomeMessage -> {
            long messageTimestamp = System.currentTimeMillis();
            MessagingChatMessage messagingChatMessage = this.buildWelcomeMessagingChatMessage(brandId, messageTimestamp, message, -4, MessagingChatMessage.MessageType.BRAND);
            if (!hasStoredWelcomeMessage.booleanValue()) {
                this.mController.amsMessages.getLatestOutboundMessage().setPostQueryOnBackground(outboundMessage -> {
                    if (TextUtils.isEmpty((CharSequence)outboundMessage)) {
                        LPLog.INSTANCE.d(TAG, "addWelcomeMessage: Adding welcome message");
                        this.mController.amsMessages.addMessage(messagingChatMessage, true).execute();
                    }
                }).execute();
            } else {
                LPLog.INSTANCE.d(TAG, "addWelcomeMessage: Loading existing welcome message");
                this.mController.amsMessages.loadExistingWelcomeMessage(messagingChatMessage).execute();
            }
        }).execute();
    }

    public void updateWelcomeMessage(String brandId, LPWelcomeMessage message) {
        this.mController.amsMessages.hasStoredWelcomeMessage().setPostQueryOnBackground(hasStoredWelcomeMessage -> {
            if (hasStoredWelcomeMessage.booleanValue()) {
                if (message.getMessageFrequency() == LPWelcomeMessage.MessageFrequency.FIRST_TIME_CONVERSATION) {
                    this.mController.amsMessages.removeLastWelcomeMessage().execute();
                } else {
                    long messageTimestamp = this.mController.amsMessages.requestLastResolvedMessageTimeStampFromDB() + 1L;
                    MessagingChatMessage messagingChatMessage = this.buildWelcomeMessagingChatMessage(brandId, messageTimestamp, message.getWelcomeMessage(), -4, MessagingChatMessage.MessageType.BRAND);
                    this.mController.amsMessages.updateLastWelcomeMessage(brandId, messagingChatMessage).execute();
                }
            }
        }).execute();
    }

    public void updateOutboundCampaignMessage(String brandId) {
        if (PushMessagePreferences.INSTANCE.isPushNotificationClicked()) {
            String id = PushMessagePreferences.INSTANCE.getClickedNotificationId();
            this.displayOutboundCampaignMessage(brandId, id);
        } else if (Configuration.getBoolean((int)R.bool.show_outbound_in_app_message)) {
            String id = PushMessagePreferences.INSTANCE.getLatestNotificationIdForBrand(brandId);
            this.displayOutboundCampaignMessage(brandId, id);
        } else {
            LPLog.INSTANCE.d(TAG, "updateOutboundCampaignMessage: Removing existing outbound welcome message");
            this.mController.amsMessages.removeLastOutboundMessage().execute();
        }
    }

    private void displayOutboundCampaignMessage(String brandId, String messageId) {
        PushMessage pushMessage = null;
        if (!TextUtils.isEmpty((CharSequence)messageId)) {
            pushMessage = PushMessagePreferences.INSTANCE.getCachedPushMessage(messageId, brandId);
        }
        String newOutboundMessage = pushMessage != null && !TextUtils.isEmpty((CharSequence)pushMessage.getMessageEvent()) ? this.getContentFromMessageEvent(pushMessage.getMessageEvent(), pushMessage) : PushMessagePreferences.INSTANCE.getCachedPushWelcomeMessage(messageId, brandId);
        MessagingChatMessage.MessageType msgType = pushMessage != null && this.isRichContentMessage(pushMessage.getMessageEvent()) ? MessagingChatMessage.MessageType.AGENT_STRUCTURED_CONTENT : MessagingChatMessage.MessageType.BRAND;
        String transactionId = PushMessagePreferences.INSTANCE.getTransactionId(messageId, brandId);
        LPLog.INSTANCE.d(TAG, "newOutboundMessage: " + newOutboundMessage + "\nmsgType: " + msgType.name());
        if (!TextUtils.isEmpty((CharSequence)newOutboundMessage)) {
            PushMessage currentPushMessage = pushMessage;
            this.mController.amsMessages.getLatestOutboundMessage().setPostQueryOnBackground(storedOutboundMessage -> {
                if (TextUtils.isEmpty((CharSequence)storedOutboundMessage)) {
                    long messageTimestamp = System.currentTimeMillis();
                    MessagingChatMessage messagingChatMessage = this.buildWelcomeMessagingChatMessage(brandId, messageTimestamp, newOutboundMessage, -5, msgType);
                    this.mController.amsMessages.removeAllWelcomeMessages().execute();
                    this.mController.amsMessages.removeLastOutboundMessage().execute();
                    if (currentPushMessage != null && !currentPushMessage.isExpired()) {
                        LPLog.INSTANCE.d(TAG, "displayOutboundCampaignMessage: Adding new outbound campaign welcome message.");
                        this.mController.amsMessages.addMessage(messagingChatMessage, true).execute();
                        this.mController.getEventManagerService().logEvent(brandId, transactionId, true, Event.READ, null, null, this.mController.getApplicationContext());
                    } else {
                        LPLog.INSTANCE.d(TAG, "displayOutboundCampaignMessage: message expired, skipped");
                    }
                } else if (!newOutboundMessage.equals(storedOutboundMessage)) {
                    long messageTimestamp = System.currentTimeMillis();
                    MessagingChatMessage messagingChatMessage = this.buildWelcomeMessagingChatMessage(brandId, messageTimestamp, newOutboundMessage, -5, msgType);
                    this.mController.getEventManagerService().logEvent(brandId, transactionId, true, Event.READ, null, null, this.mController.getApplicationContext());
                    if (currentPushMessage == null || currentPushMessage.isExpired()) {
                        LPLog.INSTANCE.d(TAG, "displayOutboundCampaignMessage: Removing existing outbound welcome message");
                        this.mController.amsMessages.removeLastOutboundMessage().execute();
                    } else {
                        LPLog.INSTANCE.d(TAG, "displayOutboundCampaignMessage: Updating existing outbound campaign welcome message with new one.");
                        this.mController.amsMessages.updateLastOutboundMessage(messagingChatMessage).execute();
                        this.trackProactiveAsWelcomeMessage(brandId, transactionId, msgType);
                    }
                }
            }).execute();
        } else {
            LPLog.INSTANCE.d(TAG, "displayOutboundCampaignMessage: Removing existing outbound welcome message");
            this.mController.amsMessages.removeLastOutboundMessage().execute();
        }
    }

    private void trackProactiveAsWelcomeMessage(@NonNull String brandId, @NonNull String transactionId, @NonNull MessagingChatMessage.MessageType type) {
        LPAuthenticationParams params = this.mController.mAccountsController.getLPAuthenticationParams(brandId);
        if (params != null) {
            LPAnalytics.ConsumerAction.INSTANCE.trackShowProactiveAsWelcomeMessage(params.getAuthType(), LocaleUtils.getInstance().getLocaleCode(), type == MessagingChatMessage.MessageType.AGENT_STRUCTURED_CONTENT, transactionId);
        } else {
            LPLog.INSTANCE.d(TAG, "getLPAuthenticationParams: getLPAuthenticationParams returns null for brand with id: " + brandId);
        }
    }

    private MessagingChatMessage buildWelcomeMessagingChatMessage(String brandId, long messageTimestamp, String message, int messageSequence, MessagingChatMessage.MessageType msgType) {
        String conversationId = "WELCOME_CONVERSATION_ID";
        String dialogId = "KEY_WELCOME_DIALOG_ID";
        String originatorId = "";
        String eventId = messageTimestamp + "_" + messageSequence;
        this.mController.amsConversations.createDummyConversationForWelcomeMessage(brandId, conversationId, messageTimestamp);
        this.mController.amsDialogs.createDummyDialogForWelcomeMessage(brandId, conversationId, dialogId, messageSequence, messageTimestamp);
        MessagingChatMessage messagingChatMessage = new MessagingChatMessage(originatorId, message, messageTimestamp, dialogId, eventId, msgType, MessagingChatMessage.MessageState.RECEIVED, EncryptionVersion.NONE);
        messagingChatMessage.setServerSequence(messageSequence);
        return messagingChatMessage;
    }

    private String getContentFromMessageEvent(String msgEvent, PushMessage pushMessage) {
        if (TextUtils.isEmpty((CharSequence)msgEvent)) {
            return "";
        }
        try {
            JSONObject jsonObject = new JSONObject(msgEvent);
            if (jsonObject.has("content")) {
                return jsonObject.optString("content");
            }
            if (jsonObject.has("type") && jsonObject.optString("type").equalsIgnoreCase(Event.Types.ContentEvent.name())) {
                String message = jsonObject.optString("message");
                if (TextUtils.isEmpty((CharSequence)message)) {
                    return pushMessage.getMessage();
                }
                return message;
            }
            return "";
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000161, "Exception while parsing json.", (Throwable)e);
            return "";
        }
    }

    private boolean isRichContentMessage(String msgEvent) {
        if (TextUtils.isEmpty((CharSequence)msgEvent)) {
            return false;
        }
        try {
            JSONObject jsonObject = new JSONObject(msgEvent);
            return jsonObject.has("type") && jsonObject.optString("type").equalsIgnoreCase(Event.Types.RichContentEvent.name());
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000161, "Exception while parsing json.", (Throwable)e);
            return false;
        }
    }

    public void updateParticipants(String targetId, String[] participants, UserProfile.UserType userType, String conversationId, boolean updateUI, boolean forceUpdate) {
        this.updateParticipants(targetId, participants, userType, conversationId, updateUI, forceUpdate, null);
    }

    public void updateParticipants(String targetId, String[] participants, UserProfile.UserType userType, String conversationId, boolean updateUI, boolean forceUpdate, ICallback<MessagingUserProfile, Exception> callback) {
        for (String userId : participants) {
            if (TextUtils.isEmpty((CharSequence)userId)) continue;
            this.mController.amsUsers.getUserById(userId).setPostQueryOnBackground(userProfile -> {
                if (userProfile == null) {
                    userProfile = new MessagingUserProfile("", "", userType);
                    userProfile.setOriginatorID(userId);
                    this.mController.amsUsers.updateUserProfile((MessagingUserProfile)userProfile);
                    this.mController.amsMessages.onAgentReceived((MessagingUserProfile)userProfile);
                    LPLog.INSTANCE.i(TAG, "First time bringing information for another participant that joined conversation " + conversationId);
                    this.sendUpdateUserRequest(targetId, userId, conversationId, updateUI, callback);
                } else if (userProfile.isEmptyUser() || forceUpdate) {
                    this.sendUpdateUserRequest(targetId, userId, conversationId, updateUI, callback);
                } else if (callback != null) {
                    callback.onSuccess(userProfile);
                }
            }).execute();
        }
    }

    private void sendUpdateUserRequest(String targetId, String userId, String conversationId, boolean shouldUpdateUi, ICallback<MessagingUserProfile, Exception> callback) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            new AgentProfileRequest(this.mController, targetId, userId, conversationId, shouldUpdateUi).setCallback(callback).execute();
        } else {
            if (TextUtils.isEmpty((CharSequence)conversationId)) {
                LPLog.INSTANCE.d(TAG, "sendUpdateUserRequest: no dialog id");
                return;
            }
            this.mController.amsConversations.queryConversationById(conversationId).setPostQueryOnBackground(data -> {
                LPLog.INSTANCE.d(TAG, "onResult: Calling agent details callback with null agent");
                this.mController.onAgentDetailsChanged(null, data.isConversationOpen());
            }).execute();
        }
    }

    public void updateTTR(TTRType type, long effectiveTTR, String targetId) {
        LPLog.INSTANCE.d(TAG, "update TTR type to - " + (Object)((Object)type) + ". EffectiveTTR = " + effectiveTTR);
        this.mController.amsConversations.updateTTRType(targetId, type, effectiveTTR);
    }

    public long calculateEffectiveTTR(String targetId, long ttrValue, long manualTTR, long delayTTR) {
        long clockDiff = this.mController.mConnectionController.getClockDiff(targetId);
        return this.mController.amsConversations.calculateEffectiveTTR(targetId, ttrValue, manualTTR, delayTTR, clockDiff);
    }

    public static void showTTR(Messaging controller, String targetId) {
        controller.amsConversations.showTTR(targetId);
    }
}

