/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.text.TextUtils;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.AcUserData;
import com.liveperson.messaging.model.MessagingUserProfile;

public class AgentProfileRequest
implements Command {
    private static final String TAG = "AgentProfileRequest";
    private static final String AC_USERS_URL = "https://%s/api/account/%s/configuration/le-users/users/%s";
    private static final int AGENT_REQUEST_TIMEOUT = 30000;
    private final Messaging mController;
    private String mBrand;
    private String mUserId;
    private String mDialogId;
    private boolean mShouldUpdateUI;
    private ICallback<MessagingUserProfile, Exception> callback;

    public AgentProfileRequest(Messaging controller, String brand, String userId, String dialogId, boolean shouldUpdateUi) {
        this.mBrand = brand;
        this.mUserId = userId;
        this.mDialogId = dialogId;
        this.mShouldUpdateUI = shouldUpdateUi;
        this.mController = controller;
    }

    public void execute() {
        String acCdnDomain = this.mController.mAccountsController.getServiceUrl(this.mBrand, "acCdnDomain");
        if (!TextUtils.isEmpty((CharSequence)acCdnDomain)) {
            String cSDSRequestUrl = String.format(AC_USERS_URL, acCdnDomain, this.mBrand, this.mUserId);
            LPLog.INSTANCE.d(TAG, "Getting agent details url " + cSDSRequestUrl);
            HttpGetRequest httpGetRequest = new HttpGetRequest(cSDSRequestUrl);
            httpGetRequest.setTimeout(30000);
            httpGetRequest.setCallback((ICallback)new ICallback<String, Exception>(){

                public void onSuccess(String profile) {
                    if (!TextUtils.isEmpty((CharSequence)profile)) {
                        LPLog.INSTANCE.d(AgentProfileRequest.TAG, "onSuccess with agent details " + profile);
                        AgentProfileRequest.this.onRequestCompleted();
                        AcUserData agent = new AcUserData(profile);
                        MessagingUserProfile userProfile = new MessagingUserProfile(agent.getFirstName(), agent.getLastName(), UserProfile.UserType.AGENT);
                        userProfile.setNickname(agent.getNickName());
                        userProfile.setBrandID(AgentProfileRequest.this.mBrand);
                        userProfile.setDescription(agent.getEmployeeId());
                        userProfile.setOriginatorID(AgentProfileRequest.this.mUserId);
                        userProfile.setAvatarUrl(agent.getPictureUrl());
                        userProfile.setEmail(agent.getEmail());
                        ((AgentProfileRequest)AgentProfileRequest.this).mController.amsMessages.onAgentReceived(userProfile);
                        ((AgentProfileRequest)AgentProfileRequest.this).mController.amsUsers.updateUserProfile(userProfile);
                        if (AgentProfileRequest.this.callback != null) {
                            AgentProfileRequest.this.callback.onSuccess((Object)userProfile);
                        }
                        if (TextUtils.isEmpty((CharSequence)AgentProfileRequest.this.mDialogId)) {
                            LPLog.INSTANCE.d(AgentProfileRequest.TAG, "onResult: updating agent details. without conversation id.");
                            return;
                        }
                        ((AgentProfileRequest)AgentProfileRequest.this).mController.amsDialogs.queryDialogById(AgentProfileRequest.this.mDialogId).setPostQueryOnBackground(data -> {
                            if (data != null && TextUtils.equals((CharSequence)data.getAssignedAgentId(), (CharSequence)AgentProfileRequest.this.mUserId)) {
                                LPLog.INSTANCE.d(AgentProfileRequest.TAG, "onResult: Calling agent details callback");
                                AgentProfileRequest.this.mController.onAgentDetailsChanged(userProfile, data.isOpen());
                            }
                            LPLog.INSTANCE.d(AgentProfileRequest.TAG, "got agent details (" + AgentProfileRequest.this.mUserId + ") related to dialog ID: " + AgentProfileRequest.this.mDialogId);
                            if (AgentProfileRequest.this.mShouldUpdateUI) {
                                LPLog.INSTANCE.d(AgentProfileRequest.TAG, "Updating ui with agent details! ");
                                ((AgentProfileRequest)AgentProfileRequest.this).mController.amsMessages.updateAgentDetailsUpdated(AgentProfileRequest.this.mDialogId);
                            }
                        }).execute();
                    } else if (AgentProfileRequest.this.callback != null) {
                        AgentProfileRequest.this.callback.onError((Throwable)new Exception("Empty response"));
                    }
                }

                public void onError(Exception exception) {
                    LPLog.INSTANCE.e(AgentProfileRequest.TAG, ErrorCode.ERR_000000C6, "JSONException", (Throwable)exception);
                    if (AgentProfileRequest.this.callback != null) {
                        AgentProfileRequest.this.callback.onError((Throwable)exception);
                    }
                }
            });
            HttpHandler.execute((HttpRequest)httpGetRequest);
            this.onRequestSent();
        }
    }

    private void onRequestSent() {
        if (!TextUtils.isEmpty((CharSequence)this.mDialogId)) {
            this.mController.amsDialogs.addUpdateRequestInProgress(this.mDialogId);
        }
    }

    private void onRequestCompleted() {
        if (!TextUtils.isEmpty((CharSequence)this.mDialogId)) {
            this.mController.amsDialogs.removeUpdateRequestInProgress(this.mDialogId);
        }
    }

    public ICallback<MessagingUserProfile, Exception> getCallback() {
        return this.callback;
    }

    public AgentProfileRequest setCallback(ICallback<MessagingUserProfile, Exception> callback) {
        this.callback = callback;
        return this;
    }
}

