/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.database.Cursor;
import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.TTRManager;
import java.util.ArrayList;
import java.util.List;

public class Conversation {
    private static final String TAG = "Conversation";
    public static final String TEMP_CONVERSATION_ID = "TEMP_CONVERSATION";
    private String mConversationId;
    private List<String> mDialogIds;
    private String mTargetId;
    private String mBrandId;
    private ConversationState mConversationState;
    private TTRType mConversationTTRType = TTRType.NORMAL;
    private long mRequestId;
    private int mLastServerSequence = -1;
    private long mStartTimestamp;
    private long mEndTimestamp = -1L;
    private int mUnreadMessages;
    private CSAT.CSAT_SHOW_STATUS mShowedCSAT = CSAT.CSAT_SHOW_STATUS.NO_VALUE;
    private int mUpdateInProgress = 0;
    private CloseReason mCloseReason = null;
    private TTRManager mTTRManager;

    public Conversation(String targetId, String brandId) {
        this.mDialogIds = new ArrayList<String>();
        this.mTargetId = targetId;
        this.mBrandId = brandId;
        this.mTTRManager = new TTRManager(this.mTargetId);
    }

    public Conversation(ConversationData data) {
        this(data.targetId, data.brandId);
        this.mConversationId = data.conversationId;
        for (DialogData dialogId : data.dialogs) {
            this.mDialogIds.add(dialogId.dialogId);
        }
        this.mRequestId = data.requestId;
        this.mConversationState = data.state;
        this.mConversationTTRType = data.conversationTTRType;
        this.mStartTimestamp = data.startTs;
        this.mUnreadMessages = data.unreadMessages;
        this.mCloseReason = data.closeReason;
        this.mEndTimestamp = data.endTs;
    }

    public Conversation(Cursor cursor) {
        this(cursor.getString(cursor.getColumnIndex("target_id")), cursor.getString(cursor.getColumnIndex("brand_id")));
        this.mConversationId = cursor.getString(cursor.getColumnIndex("conversation_id"));
        int stateInt = cursor.getInt(cursor.getColumnIndex("state"));
        this.mConversationState = ConversationState.parse(stateInt);
        this.mRequestId = cursor.getLong(cursor.getColumnIndex("request_id"));
        int ttrType = cursor.getInt(cursor.getColumnIndex("ttr_type"));
        if (ttrType != -1) {
            this.mConversationTTRType = TTRType.values()[ttrType];
        }
        int csatShownStatus = cursor.getInt(cursor.getColumnIndex("csat_status"));
        this.mShowedCSAT = CSAT.CSAT_SHOW_STATUS.parse(csatShownStatus);
        this.mEndTimestamp = cursor.getLong(cursor.getColumnIndex("end_timestamp"));
        int closeReasonInt = cursor.getInt(cursor.getColumnIndex("close_reason"));
        if (closeReasonInt != -1) {
            this.mCloseReason = CloseReason.values()[closeReasonInt];
        }
        this.mUnreadMessages = cursor.getInt(cursor.getColumnIndex("unread_msg_count"));
        this.mStartTimestamp = cursor.getLong(cursor.getColumnIndex("start_timestamp"));
        this.mUpdateInProgress = cursor.getInt(cursor.getColumnIndex("concurrent_requests_counter"));
    }

    public boolean isConversationOpen() {
        return this.mConversationState == ConversationState.OPEN;
    }

    public String getConversationId() {
        return this.mConversationId;
    }

    public String getTargetId() {
        return this.mTargetId;
    }

    public String getBrandId() {
        return this.mBrandId;
    }

    public ConversationState getState() {
        return this.mConversationState;
    }

    public void setState(ConversationState state) {
        this.mConversationState = state;
    }

    public long getRequestId() {
        return this.mRequestId;
    }

    public void setRequestId(long requestId) {
        this.mRequestId = requestId;
    }

    public void setConversationId(String conversationId) {
        this.mConversationId = conversationId;
    }

    public int getLastServerSequence() {
        return this.mLastServerSequence;
    }

    public TTRType getConversationTTRType() {
        return this.mConversationTTRType;
    }

    public void setConversationTTRType(TTRType conversationTTRType) {
        LPLog.INSTANCE.d(TAG, "Setting conversation ttr type: " + (Object)((Object)conversationTTRType));
        this.mConversationTTRType = conversationTTRType;
    }

    public TTRManager getTTRManager() {
        return this.mTTRManager;
    }

    public CSAT.CSAT_SHOW_STATUS isShowedCSAT() {
        LPLog.INSTANCE.d(TAG, "isShowedCSAT:" + (Object)((Object)this.mShowedCSAT));
        return this.mShowedCSAT;
    }

    public void setShowedCSAT(CSAT.CSAT_SHOW_STATUS showedCSAT) {
        LPLog.INSTANCE.d(TAG, "setShowedCSAT:" + (Object)((Object)showedCSAT));
        this.mShowedCSAT = showedCSAT;
    }

    public CloseReason getCloseReason() {
        return this.mCloseReason;
    }

    public void setCloseReason(CloseReason mCloseReason) {
        this.mCloseReason = mCloseReason;
    }

    public long getEndTimestamp() {
        return this.mEndTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.mEndTimestamp = endTimestamp;
    }

    public long getStartTimestamp() {
        return this.mStartTimestamp;
    }

    public int getUnreadMessages() {
        return this.mUnreadMessages;
    }

    public void setUnreadMessages(int unreadMessages) {
        this.mUnreadMessages = unreadMessages;
    }

    public void setStartTimestamp(long startTs) {
        this.mStartTimestamp = startTs;
    }

    public int getUpdateInProgress() {
        return this.mUpdateInProgress;
    }

    public void setUpdateInProgress(int mUpdateInProgress) {
        this.mUpdateInProgress = mUpdateInProgress;
    }
}

