/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.managers.ConsumerManager;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.model.Consumer;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.pusher.ClearUnreadMessagesCountCommand;
import com.liveperson.messaging.commands.pusher.GetUnreadMessagesCountCommand;
import com.liveperson.messaging.commands.pusher.SendReadAcknowledgementCommand;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsAccount;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003J\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/liveperson/messaging/commands/pusher/PusherHelper;", "", "brandId", "", "messagingController", "Lcom/liveperson/messaging/Messaging;", "(Ljava/lang/String;Lcom/liveperson/messaging/Messaging;)V", "getBrandId", "()Ljava/lang/String;", "getMessagingController", "()Lcom/liveperson/messaging/Messaging;", "getAuthToken", "getAuthType", "getCertificatePinningKeys", "", "getConsumerId", "getPusherDomain", "Companion", "messaging_release"})
public final class PusherHelper {
    @NotNull
    private final String brandId;
    @NotNull
    private final Messaging messagingController;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getPusherDomain() {
        String pusherDomain = this.messagingController.mAccountsController.getServiceUrl(this.brandId, "pusher");
        CharSequence charSequence = pusherDomain;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            pusherDomain = PreferenceManager.getInstance().getStringValue("pusher", this.brandId, null);
        }
        return pusherDomain;
    }

    @Nullable
    public final String getConsumerId() {
        String consumerId = this.messagingController.amsUsers.getConsumerId(this.brandId);
        CharSequence charSequence = consumerId;
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && Infra.instance.getConsumerManager().hasActiveConsumer()) {
            Consumer consumer = Infra.instance.getConsumerManager().getActiveConsumer();
            consumerId = consumer != null ? consumer.getConsumerId() : null;
        }
        return consumerId;
    }

    @Nullable
    public final String getAuthToken() {
        String token = this.messagingController.mAccountsController.getToken(this.brandId);
        CharSequence charSequence = token;
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && Infra.instance.getConsumerManager().hasActiveConsumer()) {
            Consumer consumer = Infra.instance.getConsumerManager().getActiveConsumer();
            token = consumer != null ? consumer.getLpToken() : null;
        }
        return token;
    }

    @Nullable
    public final List<String> getCertificatePinningKeys() {
        List certificates = this.messagingController.mAccountsController.getCertificatePinningKeys(this.brandId);
        Collection collection = certificates;
        boolean bl = false;
        boolean bl2 = false;
        if ((collection == null || collection.isEmpty()) && Infra.instance.getConsumerManager().hasActiveConsumer()) {
            LPAuthenticationParams lpAuthenticationParams;
            Consumer consumer = Infra.instance.getConsumerManager().getActiveConsumer();
            LPAuthenticationParams lPAuthenticationParams = lpAuthenticationParams = consumer != null ? consumer.getLpAuthenticationParams() : null;
            certificates = lPAuthenticationParams != null ? lPAuthenticationParams.getCertificatePinningKeys() : null;
        }
        return certificates;
    }

    @Nullable
    public final String getAuthType() {
        Object params;
        Object object;
        ConsumerManager consumerManager = Infra.instance.getConsumerManager();
        Object object2 = this.messagingController.mAccountsController;
        if (object2 == null || (object2 = ((AccountsController)object2).getAccount(this.brandId)) == null || (object2 = ((AmsAccount)object2).getLPAuthenticationParams()) == null) {
            ConsumerManager consumerManager2 = consumerManager;
            boolean bl = false;
            boolean bl2 = false;
            ConsumerManager it = consumerManager2;
            boolean bl3 = false;
            Object object3 = it.hasActiveConsumer() ? consumerManager2 : null;
            object2 = object3 != null && (object3 = object3.getActiveConsumer()) != null ? object3.getLpAuthenticationParams() : null;
        }
        return (object = (params = object2)) != null && (object = object.getAuthType()) != null ? object.name() : null;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @NotNull
    public final Messaging getMessagingController() {
        return this.messagingController;
    }

    public PusherHelper(@NotNull String brandId, @NotNull Messaging messagingController) {
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        Intrinsics.checkParameterIsNotNull((Object)messagingController, (String)"messagingController");
        this.brandId = brandId;
        this.messagingController = messagingController;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/messaging/commands/pusher/PusherHelper$Companion;", "", "()V", "cleanup", "", "messaging_release"})
    public static final class Companion {
        public final void cleanup() {
            SendReadAcknowledgementCommand.clearAcknowledgedConversations();
            GetUnreadMessagesCountCommand.clearMappedUnreadCount();
            ClearUnreadMessagesCountCommand.Companion.clearRequestState();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

