/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.ConfigurationRequest;
import com.liveperson.infra.utils.VersionUtils;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.controller.connection.IConnectionParamsCache;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigurationFetcherTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "ConfigurationFetcherTask";
    private static final String VERSION_ELEMENT = "android_SDK_min_version";
    private static final String PHOTO_SHARING_ENABLED_ELEMENT = "enablePhotoSharing";
    private final AccountsController mAccountsController;

    public ConfigurationFetcherTask(AccountsController accountsController) {
        this.mAccountsController = accountsController;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running configuration check task...");
        AmsConnectionAnalytics.configurationFetcherTaskStart();
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        String configurationServiceDomain = this.mAccountsController.getServiceUrl(this.mBrandId, "leCdnDomain");
        new ConfigurationRequest(configurationServiceDomain, certificates, (ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String configurationString) {
                try {
                    if (!TextUtils.isEmpty((CharSequence)configurationString)) {
                        JSONObject confJson = new JSONObject(configurationString);
                        ConfigurationFetcherTask.this.getPhotoSharingEnabledConfiguration(confJson);
                        String serverVersion = confJson.getString(ConfigurationFetcherTask.VERSION_ELEMENT);
                        LPLog.INSTANCE.d(ConfigurationFetcherTask.TAG, "onSuccess: Checking SDK version against version from lp-cdn");
                        IConnectionParamsCache cache = ConfigurationFetcherTask.this.mAccountsController.getConnectionParamsCache(ConfigurationFetcherTask.this.mBrandId);
                        if (cache != null) {
                            cache.updateLeCdnVersion(serverVersion);
                        }
                        if (!VersionUtils.isValidSdkVersion((String)serverVersion)) {
                            String detailMessage = "Current SDK version is smaller than the one from the server (" + serverVersion + "). SDK will not connect. Please upgrade SDK. ";
                            ConfigurationFetcherTask.this.mCallback.onTaskError(TaskType.VERSION, LpError.INVALID_SDK_VERSION, new Exception(detailMessage));
                            return;
                        }
                        LPLog.INSTANCE.d(ConfigurationFetcherTask.TAG, "Build version is OK");
                        AmsConnectionAnalytics.configurationFetcherTaskEnd();
                        ConfigurationFetcherTask.this.mCallback.onTaskSuccess();
                    }
                }
                catch (NullPointerException | JSONException ne) {
                    ConfigurationFetcherTask.this.mCallback.onTaskSuccess();
                }
            }

            public void onError(Exception exception) {
                if (exception instanceof SSLPeerUnverifiedException) {
                    ConfigurationFetcherTask.this.mCallback.onTaskError(TaskType.INVALID_CERTIFICATE, LpError.INVALID_CERTIFICATE, exception);
                } else {
                    ConfigurationFetcherTask.this.mCallback.onTaskSuccess();
                }
            }
        }).execute();
    }

    private void getPhotoSharingEnabledConfiguration(JSONObject confJson) {
        boolean photoSharingEnabled = true;
        try {
            photoSharingEnabled = confJson.getBoolean(PHOTO_SHARING_ENABLED_ELEMENT);
            LPLog.INSTANCE.d(TAG, "onSuccess: configuration enablePhotoSharing is: " + photoSharingEnabled);
        }
        catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "getPhotoSharingEnabledConfiguration: photo sharing enabled parameter does not exist in configuration json", (Throwable)e);
        }
        PreferenceManager.getInstance().setBooleanValue("kill_switch_photo_sharing_enabled_preference_key", "appLevelPreferences", photoSharingEnabled);
    }

    @Override
    public String getName() {
        return TAG;
    }
}

