/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UpdateConversationField;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class ResolveConversationRequest
extends BaseAMSSocketRequest<ReqBody.StringResp, ResolveConversationRequest> {
    private static final String TAG = "ResolveConversationRequest";
    private String conversationId;
    private ICallback<String, Throwable> callback;

    public ResolveConversationRequest(String socketUrl, String convServerId) {
        super(socketUrl);
        this.conversationId = convServerId;
    }

    protected String getData() {
        return new UpdateConversationField(this.conversationId, UpdateConversationField.CONVERSATION_STATE_FIELD(), ConversationState.CLOSE).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    public void setResponseCallBack(ICallback<String, Throwable> callBack) {
        this.callback = callBack;
    }

    protected BaseResponseHandler<ReqBody.StringResp, ResolveConversationRequest> getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, ResolveConversationRequest>(){

            public String getAPIResponseType() {
                return null;
            }

            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            protected boolean handle(ReqBody.StringResp response) {
                if (response.code > 201) {
                    LPLog.INSTANCE.w(ResolveConversationRequest.TAG, "Received bad response (" + response.code + ").");
                    if (ResolveConversationRequest.this.callback != null) {
                        ResolveConversationRequest.this.callback.onError((Throwable)new Exception("Failed to resolve conversation, response: " + response));
                    }
                } else if (ResolveConversationRequest.this.callback != null) {
                    ResolveConversationRequest.this.callback.onSuccess((Object)response.getBody());
                }
                LPLog.INSTANCE.d(ResolveConversationRequest.TAG, "Got resolve conversation response: " + response);
                return true;
            }
        };
    }
}

