/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.wm;

import android.content.Context;
import android.content.SharedPreferences;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.wm.WelcomeMessageBroadcastReceiver;
import com.liveperson.messaging.wm.WelcomeMessageManager;
import com.liveperson.messaging.wm.WelcomeMessageStoreUtilsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB?\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0006R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/liveperson/messaging/wm/WelcomeMessageManager;", "", "sharedPreferences", "Landroid/content/SharedPreferences;", "responseSender", "Lkotlin/Function1;", "", "", "defaultWelcomeMessageProvider", "Lkotlin/Function0;", "Lcom/liveperson/infra/model/LPWelcomeMessage;", "timeOutProvider", "", "(Landroid/content/SharedPreferences;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "pendingRequests", "", "Ljava/util/concurrent/ScheduledFuture;", "requestsExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "cancelTimeoutTasks", "clearWelcomeMessage", "dispose", "getWelcomeMessage", "brandId", "getWelcomeMessageFrequency", "Lcom/liveperson/infra/model/LPWelcomeMessage$MessageFrequency;", "requestNewWelcomeMessage", "Companion", "NotifierTask", "messaging_release"})
public final class WelcomeMessageManager {
    private final ScheduledExecutorService requestsExecutor;
    private final List<ScheduledFuture<?>> pendingRequests;
    private final SharedPreferences sharedPreferences;
    private final Function1<String, Unit> responseSender;
    private final Function0<LPWelcomeMessage> defaultWelcomeMessageProvider;
    private final Function0<Long> timeOutProvider;
    private static final String KEY_DYNAMIC_WELCOME_MESSAGE = "welcome.message";
    private static final String KEY_DYNAMIC_WELCOME_MESSAGE_FREQUENCY = "welcome.message.frequency";
    private static final String JSON_KEY_WELCOME_MESSAGE_CONTENT = "content";
    private static final String JSON_KEY_WELCOME_MESSAGE_ACTIONS = "actions";
    private static final String JSON_KEY_WELCOME_MESSAGE_FREQUENCY = "frequency";
    public static final Companion Companion = new Companion(null);

    public final synchronized void requestNewWelcomeMessage(@NotNull String brandId) {
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        long delay = ((Number)this.timeOutProvider.invoke()).longValue();
        NotifierTask task = new NotifierTask(brandId, this.responseSender);
        if (delay <= 0L) {
            this.requestsExecutor.execute(task);
        } else {
            ScheduledFuture<?> scheduledFuture = this.requestsExecutor.schedule(task, delay, TimeUnit.SECONDS);
            Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, (String)"requestsExecutor.schedul\u2026 delay, TimeUnit.SECONDS)");
            this.pendingRequests.add(scheduledFuture);
        }
    }

    public final synchronized void cancelTimeoutTasks() {
        Iterable $this$forEach$iv = this.pendingRequests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScheduledFuture it = (ScheduledFuture)element$iv;
            boolean bl = false;
            if (it.isCancelled() || it.isDone()) continue;
            it.cancel(true);
        }
        this.pendingRequests.clear();
    }

    public final void clearWelcomeMessage() {
        this.sharedPreferences.edit().clear().commit();
    }

    @NotNull
    public final LPWelcomeMessage.MessageFrequency getWelcomeMessageFrequency(@NotNull String brandId) {
        LPWelcomeMessage.MessageFrequency messageFrequency;
        int frequency;
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        LPWelcomeMessage message = (LPWelcomeMessage)this.defaultWelcomeMessageProvider.invoke();
        int n = frequency = this.sharedPreferences.getInt(KEY_DYNAMIC_WELCOME_MESSAGE_FREQUENCY + brandId, -1);
        if (0 <= n && 1 >= n) {
            LPWelcomeMessage.MessageFrequency messageFrequency2 = LPWelcomeMessage.MessageFrequency.fromOrdinal((int)frequency);
            messageFrequency = messageFrequency2;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageFrequency2, (String)"MessageFrequency.fromOrdinal(frequency)");
        } else {
            LPWelcomeMessage.MessageFrequency messageFrequency3 = message.getMessageFrequency();
            messageFrequency = messageFrequency3;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageFrequency3, (String)"message.messageFrequency");
        }
        return messageFrequency;
    }

    @NotNull
    public final LPWelcomeMessage getWelcomeMessage(@NotNull String brandId) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        String content = this.sharedPreferences.getString(KEY_DYNAMIC_WELCOME_MESSAGE + brandId, "");
        CharSequence charSequence = content;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            LPWelcomeMessage welcomeMessage;
            LPWelcomeMessage lPWelcomeMessage = welcomeMessage = WelcomeMessageManager.Companion.createWelcomeMessageFromJson(content);
            bl2 = false;
            boolean bl3 = false;
            LPWelcomeMessage it = lPWelcomeMessage;
            boolean bl4 = false;
            CharSequence charSequence2 = it.getWelcomeMessage();
            boolean bl5 = false;
            boolean bl6 = false;
            object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? lPWelcomeMessage : null;
            if (object == null) {
                object = (LPWelcomeMessage)this.defaultWelcomeMessageProvider.invoke();
            }
        } else {
            object = (LPWelcomeMessage)this.defaultWelcomeMessageProvider.invoke();
        }
        return object;
    }

    public final void dispose() {
        this.requestsExecutor.shutdown();
    }

    private WelcomeMessageManager(SharedPreferences sharedPreferences, Function1<? super String, Unit> responseSender, Function0<LPWelcomeMessage> defaultWelcomeMessageProvider, Function0<Long> timeOutProvider) {
        List list;
        this.sharedPreferences = sharedPreferences;
        this.responseSender = responseSender;
        this.defaultWelcomeMessageProvider = defaultWelcomeMessageProvider;
        this.timeOutProvider = timeOutProvider;
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"Executors.newSingleThreadScheduledExecutor()");
        this.requestsExecutor = scheduledExecutorService;
        WelcomeMessageManager welcomeMessageManager = this;
        boolean bl = false;
        welcomeMessageManager.pendingRequests = list = (List)new ArrayList();
    }

    public /* synthetic */ WelcomeMessageManager(SharedPreferences sharedPreferences, Function1 responseSender, Function0 defaultWelcomeMessageProvider, Function0 timeOutProvider, DefaultConstructorMarker $constructor_marker) {
        this(sharedPreferences, (Function1<? super String, Unit>)responseSender, (Function0<LPWelcomeMessage>)defaultWelcomeMessageProvider, (Function0<Long>)timeOutProvider);
    }

    @JvmStatic
    @NotNull
    public static final WelcomeMessageManager newInstance(@NotNull Messaging messaging) {
        return Companion.newInstance(messaging);
    }

    @JvmStatic
    public static final void setWelcomeMessage(@NotNull Context context, @NotNull String brandId, @Nullable LPWelcomeMessage welcomeMessage) {
        Companion.setWelcomeMessage(context, brandId, welcomeMessage);
    }

    @JvmStatic
    @Nullable
    public static final LPWelcomeMessage getWelcomeMessage(@NotNull Context context, @NotNull String brandId) {
        return Companion.getWelcomeMessage(context, brandId);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/liveperson/messaging/wm/WelcomeMessageManager$NotifierTask;", "Ljava/lang/Runnable;", "brandId", "", "intentSender", "Lkotlin/Function1;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "run", "messaging_release"})
    private static final class NotifierTask
    implements Runnable {
        private final String brandId;
        private final Function1<String, Unit> intentSender;

        @Override
        public void run() {
            this.intentSender.invoke((Object)this.brandId);
        }

        public NotifierTask(@NotNull String brandId, @NotNull Function1<? super String, Unit> intentSender) {
            Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
            Intrinsics.checkParameterIsNotNull(intentSender, (String)"intentSender");
            this.brandId = brandId;
            this.intentSender = intentSender;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0007J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0007J\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/liveperson/messaging/wm/WelcomeMessageManager$Companion;", "", "()V", "JSON_KEY_WELCOME_MESSAGE_ACTIONS", "", "JSON_KEY_WELCOME_MESSAGE_CONTENT", "JSON_KEY_WELCOME_MESSAGE_FREQUENCY", "KEY_DYNAMIC_WELCOME_MESSAGE", "KEY_DYNAMIC_WELCOME_MESSAGE_FREQUENCY", "defaultWelcomeMessage", "Lcom/liveperson/infra/model/LPWelcomeMessage;", "Lcom/liveperson/messaging/Messaging;", "getDefaultWelcomeMessage", "(Lcom/liveperson/messaging/Messaging;)Lcom/liveperson/infra/model/LPWelcomeMessage;", "createWelcomeMessageFromJson", "content", "getWelcomeMessage", "context", "Landroid/content/Context;", "brandId", "newInstance", "Lcom/liveperson/messaging/wm/WelcomeMessageManager;", "messaging", "setWelcomeMessage", "", "welcomeMessage", "Landroid/content/SharedPreferences;", "messaging_release"})
    public static final class Companion {
        private final LPWelcomeMessage getDefaultWelcomeMessage(@NotNull Messaging $this$defaultWelcomeMessage) {
            LPWelcomeMessage message;
            ConversationViewParams conversationViewParams = $this$defaultWelcomeMessage.getConversationViewParams();
            Intrinsics.checkExpressionValueIsNotNull((Object)conversationViewParams, (String)"conversationViewParams");
            LPWelcomeMessage lPWelcomeMessage = message = conversationViewParams.getLpWelcomeMessage();
            Intrinsics.checkExpressionValueIsNotNull((Object)lPWelcomeMessage, (String)"message");
            CharSequence charSequence = lPWelcomeMessage.getWelcomeMessage();
            boolean bl = false;
            boolean bl2 = false;
            return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? message : new LPWelcomeMessage($this$defaultWelcomeMessage.getApplicationContext().getString(R.string.lp_first_message));
        }

        private final void setWelcomeMessage(@NotNull SharedPreferences $this$setWelcomeMessage, String brandId, LPWelcomeMessage welcomeMessage) {
            JSONObject json = new JSONObject();
            json.put(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_CONTENT, (Object)welcomeMessage.getWelcomeMessage());
            List list = welcomeMessage.getMessageOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"welcomeMessage.messageOptions");
            json.put(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_ACTIONS, (Object)WelcomeMessageStoreUtilsKt.serialize(list));
            json.put(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_FREQUENCY, welcomeMessage.getMessageFrequency().ordinal());
            $this$setWelcomeMessage.edit().putString(WelcomeMessageManager.KEY_DYNAMIC_WELCOME_MESSAGE + brandId, json.toString()).putInt(WelcomeMessageManager.KEY_DYNAMIC_WELCOME_MESSAGE_FREQUENCY + brandId, welcomeMessage.getMessageFrequency().ordinal()).commit();
        }

        private final LPWelcomeMessage createWelcomeMessageFromJson(String content) {
            JSONObject jSONObject = new JSONObject(content);
            boolean bl = false;
            boolean bl2 = false;
            JSONObject $this$with = jSONObject;
            boolean bl3 = false;
            LPWelcomeMessage lPWelcomeMessage = new LPWelcomeMessage($this$with.optString(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_CONTENT));
            boolean bl4 = false;
            boolean bl5 = false;
            LPWelcomeMessage $this$apply = lPWelcomeMessage;
            boolean bl6 = false;
            int frequency = $this$with.optInt(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_FREQUENCY, LPWelcomeMessage.MessageFrequency.FIRST_TIME_CONVERSATION.ordinal());
            $this$apply.setMessageFrequency(LPWelcomeMessage.MessageFrequency.fromOrdinal((int)frequency));
            Object object = $this$with.optJSONArray(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_ACTIONS);
            if (object == null || (object = WelcomeMessageStoreUtilsKt.toMessageOptions(object)) == null) {
                object = CollectionsKt.emptyList();
            }
            $this$apply.setMessageOptions((List)object);
            LPWelcomeMessage welcomeMessage = lPWelcomeMessage;
            return welcomeMessage;
        }

        @JvmStatic
        @NotNull
        public final WelcomeMessageManager newInstance(@NotNull Messaging messaging) {
            Context context;
            Intrinsics.checkParameterIsNotNull((Object)messaging, (String)"messaging");
            Context context2 = context = messaging.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
            return new WelcomeMessageManager(WelcomeMessageStoreUtilsKt.getWelcomeMessagePreferences(context2), (Function1)new Function1<String, Unit>(context){
                final /* synthetic */ Context $context;

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Context context = this.$context;
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                    WelcomeMessageBroadcastReceiver.Companion.sendWelcomeMessageEvent$messaging_release$default(WelcomeMessageBroadcastReceiver.Companion, context, "welcome.message.response" + it, null, 2, null);
                }
                {
                    this.$context = context;
                    super(1);
                }
            }, (Function0)new Function0<LPWelcomeMessage>(messaging){
                final /* synthetic */ Messaging $messaging;

                @NotNull
                public final LPWelcomeMessage invoke() {
                    return com.liveperson.messaging.wm.WelcomeMessageManager$Companion.access$getDefaultWelcomeMessage$p(WelcomeMessageManager.Companion, this.$messaging);
                }
                {
                    this.$messaging = messaging;
                    super(0);
                }
            }, newInstance.3.INSTANCE, null);
        }

        @JvmStatic
        public final void setWelcomeMessage(@NotNull Context context, @NotNull String brandId, @Nullable LPWelcomeMessage welcomeMessage) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            SharedPreferences preferences = WelcomeMessageStoreUtilsKt.getWelcomeMessagePreferences(context2);
            if (welcomeMessage == null) {
                preferences.edit().clear().commit();
            } else {
                this.setWelcomeMessage(preferences, brandId, welcomeMessage);
            }
        }

        @JvmStatic
        @Nullable
        public final LPWelcomeMessage getWelcomeMessage(@NotNull Context context, @NotNull String brandId) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            SharedPreferences preferences = WelcomeMessageStoreUtilsKt.getWelcomeMessagePreferences(context2);
            String string2 = preferences.getString(WelcomeMessageManager.KEY_DYNAMIC_WELCOME_MESSAGE + brandId, "");
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            boolean bl5 = false;
            String string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
            if (string3 == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"preferences.getString(KE\u2026           ?: return null");
            String content = string3;
            return this.createWelcomeMessageFromJson(content);
        }

        private Companion() {
        }

        public static final /* synthetic */ LPWelcomeMessage access$getDefaultWelcomeMessage$p(Companion $this, Messaging $this$access_u24defaultWelcomeMessage_u24p) {
            return $this.getDefaultWelcomeMessage($this$access_u24defaultWelcomeMessage_u24p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

