package com.liveperson.api.request;

import com.liveperson.infra.network.socket.BaseSocketRequest;

/**
 * Created by Ilya Gazman on 11/4/2015.
 */
public abstract class BaseAMSSocketRequest<DATA, REQUEST extends BaseSocketRequest> extends BaseSocketRequest<DATA, REQUEST> {

    private String mSocketUrl;

    public BaseAMSSocketRequest(String socketUrl) {
        super();
        mSocketUrl = socketUrl;
    }

    public BaseAMSSocketRequest(String socketUrl, long requestId) {
        super(requestId);
        mSocketUrl = socketUrl;
    }

    /**
     * sets the basic socket url for connection
     */
    @Override
    protected String getSocketUrl() {
        return mSocketUrl;
    }
}
