package com.liveperson.api.request.message;

import com.liveperson.infra.log.LPLog;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Maayan on 03/02/2017.
 */
public class FormSubmissionPublishMessage extends BasePublishMessage {

	private static final String TAG = "FormSubmissionPublishMessage";

	private static final String INVITATION_ID = "invitationId";
	private static final String SUBMISSION_ID = "submissionId";

	private String invitationId;
	private String submissionId;
	private JSONObject jsonObject;

	public FormSubmissionPublishMessage(String invitationId, String submissionId) {
		this.invitationId = invitationId;
		this.submissionId = submissionId;

		jsonObject = new JSONObject();
		try {
			jsonObject.put(INVITATION_ID, this.invitationId);
			jsonObject.put(SUBMISSION_ID, this.submissionId);
		} catch (JSONException e) {
			LPLog.INSTANCE.e(TAG, "JSONException while building JSON Object.", e);
		}
	}

	/**
	 * Build a PublishMessage from a JSONObject
	 *
	 * @param jsonObject
	 */
	public FormSubmissionPublishMessage(JSONObject jsonObject) {
		if (jsonObject != null) {
			invitationId = jsonObject.optString(INVITATION_ID);
			submissionId = jsonObject.optString(SUBMISSION_ID);
			this.jsonObject = jsonObject;
		}
	}

	@Override
	public JSONObject getMessage() {
		return jsonObject;
	}

	public String getInvitationId() {return invitationId;}

	public String getSubmissionId() {return submissionId;}


	@Override
	public PublishMessageType getType() {
		return PublishMessageType.FORM_SUBMISSION;
	}

	public String getMessageText() {
		return getMessageTextWithoutSpecialChars(jsonObject.toString());
	}
}
