package com.liveperson.messaging.commands;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.pusher.GetUnreadMessagesCountCommand;

/**
 * Do not remove this class till we are confident enough that get unread message count works on pusher 100% of time
 */
public class GetCombinedUnreadMessagesCountCommand implements Command {

    private static final String TAG = "GetCombinedUnreadMessagesCountCommand";

    private Messaging mController;
    private String mBrandId;
    private ICallback<Integer, Exception> mCallback;
    private String mAppId;
    private LPAuthenticationParams authenticationParams;
    public GetCombinedUnreadMessagesCountCommand(Messaging messagingController, String brandId, String appId, LPAuthenticationParams authenticationParams, ICallback<Integer, Exception> callback) {
        mController = messagingController;
        mBrandId = brandId;
        mAppId = appId;
        mCallback = callback;
        this.authenticationParams = authenticationParams;
    }


    @Override
    public void execute() {
		LPLog.INSTANCE.d(TAG, "Getting unread count from pusher");
        getUnreadMessageCountFromPusher();
    }

    /**
     * Try to get Unread messages count from pusher.
     */
    private void getUnreadMessageCountFromPusher() {
        new GetUnreadMessagesCountCommand(mController, mBrandId, mAppId, authenticationParams, new ICallback<Integer, Exception>() {

            @Override
            public void onSuccess(Integer value) {
                mCallback.onSuccess(value);
            }

            @Override
            public void onError(Exception exception) {
				LPLog.INSTANCE.d(TAG, "getUnreadMessageCountFromPusher: Pusher returned error: " + exception);
                getUnreadMessageCountFromUMS();
            }
        }).execute();
    }

    /**
     * Get Unread messages count from UMS.
     */
    private void getUnreadMessageCountFromUMS() {
        LPLog.INSTANCE.d(TAG, "Getting unread count from UMS");
        new GetUnreadMessagesCountFromUMSCommand(mController, mBrandId, new ICallback<Integer, Exception>() {
            @Override
            public void onSuccess(Integer value) {
                mCallback.onSuccess(value);
            }

            @Override
            public void onError(Exception exception) {
                mCallback.onError(exception);
            }
        }).execute();
    }
}
