package com.liveperson.messaging.commands;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Form;


/**
 * A command for re-sending a message notifying UMS that a Secure Form has been submitted.
 */
public class ResendFormSubmissionMessageCommand extends SendFormSubmissionMessageCommand {

	/**
	 * Creates a resend command for submitted-form messages with a specific pre-existing event ID
	 *
	 * @param form The Form that this message is a submission for
	 * @param eventId The eventId of the original Form <i>Submission</i>, and not the ID of the
	 *                   Form itself
	 * @param message The Message being sent that includes the invitationId and submissionId
	 * @param controller The Messaging instance that will be used to send this command.
	 */
	public ResendFormSubmissionMessageCommand(Form form, String eventId, MaskedMessage message, Messaging controller){
		super(form, message, controller);
		mEventId = eventId;
	}

	@Override
	protected void addMessageToDBAndSend(String conversationId, final MaskedMessage message) {
		sendMessageIfDialogIsOpen();
	}
}