package com.liveperson.messaging.network.socket.requests;

import androidx.annotation.Nullable;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UpdateConversationField;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Perry Sh on 13/05/2018.
 */
public class CloseDialogRequest extends BaseAMSSocketRequest<ReqBody.StringResp, CloseDialogRequest>{

    private static final String TAG = "CloseDialogRequest";

    private final String conversationId;
    private final String dialogIdToClose;
    private final String closingCause;
    @Nullable
    private ICallback<Integer, Exception> callback;

    public CloseDialogRequest(String socketUrl, String dialogId, String conversationId, String closingCause) {
        super(socketUrl);
        this.conversationId = conversationId;
        dialogIdToClose = dialogId;
        this.closingCause = closingCause;
    }

    @Override
    protected String getData() {
        return new UpdateConversationField(dialogIdToClose, conversationId, UpdateConversationField.DIALOG_CHANGE_FIELD, closingCause, DialogState.CLOSE).toJsonString(getRequestId());
    }

    public void setCallback(@Nullable ICallback<Integer, Exception> callback) {
        this.callback = callback;
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler<ReqBody.StringResp, CloseDialogRequest> getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, CloseDialogRequest>() {

            @Override
            public String getAPIResponseType() {
                return null;
            }

            @Override
            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            @Override
            protected boolean handle(ReqBody.StringResp data) {
                //send update only when notification will arrive.
                if (data.code >= 200 && data.code < 300) {
                    LPLog.INSTANCE.d(TAG, "Succeeded, close dialog response code: " + data.code);
                    if (callback != null) {
                        callback.onSuccess(data.code);
                    }
                } else {
                    LPLog.INSTANCE.e(TAG, "Error, close dialog response code: " + data.code);
                    if (callback != null) {
                        callback.onError(new Exception(String.valueOf(data.code)));
                    }
                }


                return true;
            }
        };
    }
}



