/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import androidx.annotation.Nullable;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.socket.requests.CloseDialogRequest;

public class CloseDialogCommand
implements Command {
    private static final String TAG = "CloseDialogCommand";
    private final AmsDialogs mAmsDialogs;
    private String mDialogId;
    private String mSocketUrl;
    private static final String CLOSING_CAUSE = "Closed by Consumer";
    @Nullable
    private ICallback<Integer, Exception> callback;
    @Nullable
    private CloseDialogRequest closeDialogRequest;

    public CloseDialogCommand(AmsDialogs amsDialogs, String dialogId, String socketUrl) {
        this.mAmsDialogs = amsDialogs;
        this.mSocketUrl = socketUrl;
        this.mDialogId = dialogId;
    }

    public void setCallback(@Nullable ICallback<Integer, Exception> callback) {
        this.callback = callback;
        if (this.closeDialogRequest != null) {
            this.closeDialogRequest.setCallback(callback);
        }
    }

    public void execute() {
        Dialog dialog = this.mAmsDialogs.getActiveDialog();
        if (dialog != null) {
            String dialogId = dialog.getDialogId();
            if (dialogId.equalsIgnoreCase(this.mDialogId)) {
                this.closeDialogRequest = new CloseDialogRequest(this.mSocketUrl, dialogId, dialog.getConversationId(), CLOSING_CAUSE);
                this.closeDialogRequest.setCallback(this.callback);
                SocketManager.getInstance().send((BaseSocketRequest)this.closeDialogRequest);
            } else {
                LPLog.INSTANCE.e(TAG, "The dialog with this ID (" + this.mDialogId + ") is not an active dialog");
            }
        } else {
            LPLog.INSTANCE.e(TAG, "No open dialog found. Aborting resolve conversation command.");
        }
    }
}

