/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.os.Bundle;
import android.text.TextUtils;
import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.controller.connection.ConnectionParamsCache;
import com.liveperson.messaging.controller.connection.IConnectionParamsCache;
import com.liveperson.messaging.utils.TokenUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AmsAccount {
    private static final String TAG = "AmsAccount";
    public static final String KEY_ACCOUNT_TOKEN = "account_token";
    public static final String KEY_ACCOUNT_TOKEN_ENC = "account_token_enc";
    private static final String KEY_ACCOUNT_NON_AUTH_ENC = "account_non_auth_enc";
    private static final String KEY_CONSUMER_ID_ENC = "account_original_consumer_id_enc";
    private static final String KEY_CONNECTOR_ID_ENC = "account_connector_id_enc";
    private static final String CERTIFICATE_PUBLIC_KEYS_ENC = "certificate_public_keys_enc";
    private static final String QA_CSDS = "hc1n.dev.lprnd.net";
    private static final String PROD_CSDS = "adminlogin.liveperson.net";
    public static final String BROADCAST_KEY_AUTH_COMPLETED_ACTION = "BROADCAST_KEY_AUTH_COMPLETED_ACTION";
    private PreferenceManager mPreferenceManager = PreferenceManager.getInstance();
    private IConnectionParamsCache mConnectionParamsCache;
    private String mBrandId;
    private String mCSDSDomain;
    private String mToken;
    private LPAuthenticationParams mLPAuthenticationParams;
    private String mAppId;
    private String mNonAuthCode;
    private String mOriginalConsumerId;
    private String mConnectorId;

    public AmsAccount(String brandId) {
        String decryptedConnectorId;
        String decryptedConsumerId;
        this.mCSDSDomain = brandId.startsWith("qa") || brandId.startsWith("le") ? QA_CSDS : Infra.instance.getApplicationContext().getResources().getString(R.string.csds_url);
        this.mBrandId = brandId;
        String decryptedToken = this.mPreferenceManager.getStringValue(KEY_ACCOUNT_TOKEN_ENC, this.mBrandId, null);
        if (TextUtils.isEmpty((CharSequence)decryptedToken)) {
            this.mToken = this.mPreferenceManager.getStringValue(KEY_ACCOUNT_TOKEN, this.mBrandId, null);
            this.mPreferenceManager.remove(KEY_ACCOUNT_TOKEN, this.mBrandId);
            this.saveToken();
        } else {
            this.mToken = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)decryptedToken);
        }
        String decryptedNonAuth = this.mPreferenceManager.getStringValue(KEY_ACCOUNT_NON_AUTH_ENC, this.mBrandId, null);
        if (!TextUtils.isEmpty((CharSequence)decryptedNonAuth)) {
            this.mNonAuthCode = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)decryptedNonAuth);
        }
        if (!TextUtils.isEmpty((CharSequence)(decryptedConsumerId = this.mPreferenceManager.getStringValue(KEY_CONSUMER_ID_ENC, this.mBrandId, null)))) {
            this.mOriginalConsumerId = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)decryptedConsumerId);
        }
        if (!TextUtils.isEmpty((CharSequence)(decryptedConnectorId = this.mPreferenceManager.getStringValue(KEY_CONNECTOR_ID_ENC, this.mBrandId, null)))) {
            this.mConnectorId = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)decryptedConnectorId);
        }
        this.mConnectionParamsCache = new ConnectionParamsCache(this.mBrandId);
        LPLog.INSTANCE.d(TAG, "restoring mOriginalConsumerId = " + LPLog.INSTANCE.mask((Object)this.mOriginalConsumerId) + ", mConnectorId = " + this.mConnectorId);
        LPLog.INSTANCE.d(TAG, "restoring data: mNonAuthCode = " + LPLog.INSTANCE.mask((Object)this.mNonAuthCode));
        LPLog.INSTANCE.d(TAG, "restoring data: mToken = " + LPLog.INSTANCE.mask((Object)this.mToken));
    }

    public void setToken(String token) {
        this.mToken = token;
        this.saveToken();
    }

    private void saveToken() {
        LPLog.INSTANCE.d(TAG, "setToken: storing token in preferences - " + LPLog.INSTANCE.mask((Object)this.mToken));
        String encryptedToken = DBEncryptionHelper.encrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)this.mToken);
        this.mPreferenceManager.setStringValue(KEY_ACCOUNT_TOKEN_ENC, this.mBrandId, encryptedToken);
    }

    public String getToken() {
        return this.mToken;
    }

    public void sendAuthenticationCompletedStatus() {
        Bundle connectionBundle = new Bundle();
        connectionBundle.putString("BROADCAST_KEY_BRAND_ID", this.mBrandId);
        LocalBroadcast.sendBroadcast((String)BROADCAST_KEY_AUTH_COMPLETED_ACTION, (Bundle)connectionBundle);
    }

    public void setNonAuthCode(String nonAuthCode) {
        this.mNonAuthCode = nonAuthCode;
        LPLog.INSTANCE.d(TAG, "setNonAuthCode: storing mNonAuthCode in preferences " + LPLog.INSTANCE.mask((Object)nonAuthCode));
        String encryptedToken = DBEncryptionHelper.encrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)this.mNonAuthCode);
        this.mPreferenceManager.setStringValue(KEY_ACCOUNT_NON_AUTH_ENC, this.mBrandId, encryptedToken);
    }

    public String getNonAuthCode() {
        return this.mNonAuthCode;
    }

    public LPAuthenticationParams getLPAuthenticationParams() {
        return this.mLPAuthenticationParams;
    }

    public void setLPAuthenticationParams(LPAuthenticationParams lpAuthenticationParams) {
        this.mLPAuthenticationParams = lpAuthenticationParams;
        this.savePublicKey();
    }

    private void savePublicKey() {
        List decryptedKeys;
        if (this.mLPAuthenticationParams != null && (decryptedKeys = this.mLPAuthenticationParams.getCertificatePinningKeys()) != null && decryptedKeys.size() > 0) {
            HashSet<String> encryptedKeys = new HashSet<String>(decryptedKeys.size());
            for (String key : decryptedKeys) {
                String encryptedKey = DBEncryptionHelper.encrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)key);
                encryptedKeys.add(encryptedKey);
            }
            this.mPreferenceManager.setStringsSet(CERTIFICATE_PUBLIC_KEYS_ENC, this.mBrandId, encryptedKeys);
        }
    }

    private List<String> getCachedPublicKey() {
        Set encryptedKeys = this.mPreferenceManager.getStringSet(CERTIFICATE_PUBLIC_KEYS_ENC, this.mBrandId, null);
        ArrayList<String> decryptedKeys = null;
        if (encryptedKeys != null) {
            decryptedKeys = new ArrayList<String>(encryptedKeys.size());
            for (String key : encryptedKeys) {
                String decryptedKey = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)key);
                decryptedKeys.add(decryptedKey);
            }
        }
        return decryptedKeys;
    }

    public boolean isAuthenticated() {
        return this.mLPAuthenticationParams.isAuthenticated();
    }

    public boolean isAuthenticatedCompleted() {
        return !TextUtils.isEmpty((CharSequence)this.mToken);
    }

    public List<String> getCertificatePinningKeys() {
        if (this.mLPAuthenticationParams != null) {
            return this.mLPAuthenticationParams.getCertificatePinningKeys();
        }
        return this.getCachedPublicKey();
    }

    public String getDomain() {
        return this.mCSDSDomain;
    }

    public boolean setCSDSMap(HashMap<String, String> csdsUrls) {
        return this.mConnectionParamsCache.updateCsdsDomains(csdsUrls);
    }

    public boolean isCsdsDataMissing() {
        return !this.mConnectionParamsCache.isCsdsFilled();
    }

    public String getServiceUrl(String serviceName) {
        if (!this.mConnectionParamsCache.isCsdsFilled()) {
            return null;
        }
        return this.mConnectionParamsCache.getServiceDomain(serviceName);
    }

    public void setAppId(String appId) {
        this.mAppId = appId;
    }

    public String getAppId() {
        return this.mAppId;
    }

    public IConnectionParamsCache getConnectionParamsCache() {
        return this.mConnectionParamsCache;
    }

    public boolean isHostAppJWTExpired() {
        String jwt = this.mLPAuthenticationParams.getHostAppJWT();
        return TokenUtils.isJwtExpired(jwt);
    }

    public boolean isTokenExpired() {
        String jwt = this.getToken();
        return TokenUtils.isJwtExpired(jwt);
    }

    public boolean isAutoMessagesEnabled() {
        return this.mConnectionParamsCache.isAutoMessagesFeatureEnabled();
    }

    public void setOriginalConsumerId(String originalConsumerId) {
        this.mOriginalConsumerId = originalConsumerId;
        String encryptedConsumerId = DBEncryptionHelper.encrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)originalConsumerId);
        this.mPreferenceManager.setStringValue(KEY_CONSUMER_ID_ENC, this.mBrandId, encryptedConsumerId);
    }

    public String getOriginalConsumerId() {
        return this.mOriginalConsumerId;
    }

    public void setConnectorId(String connectorId) {
        this.mConnectorId = connectorId;
        String encryptedConnectorId = DBEncryptionHelper.encrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)connectorId);
        this.mPreferenceManager.setStringValue(KEY_CONNECTOR_ID_ENC, this.mBrandId, encryptedConnectorId);
    }

    public String getConnectorId() {
        return this.mConnectorId;
    }

    public boolean isInUnAuthMode() {
        LPAuthenticationType authType = this.getLPAuthenticationParams().getAuthType();
        return authType == LPAuthenticationType.UN_AUTH;
    }
}

