/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.ContentValues;
import android.database.Cursor;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.infra.utils.Queue;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.Dialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AmsConversations
extends BaseDBRepository
implements ShutDown,
Clearable {
    private static final String TAG = "AmsConversations";
    private static final String BROADCAST_UPDATE_CONVERSATION = "BROADCAST_UPDATE_CONVERSATION";
    public static final String BROADCAST_UPDATE_CSAT_CONVERSATION = "BROADCAST_UPDATE_CSAT_CONVERSATION";
    public static final String BROADCAST_UPDATE_CONVERSATION_CLOSED = "BROADCAST_UPDATE_CONVERSATION_CLOSED";
    private static final String BROADCAST_UPDATE_NEW_CONVERSATION_MSG = "BROADCAST_UPDATE_NEW_CONVERSATION_MSG";
    private static final String BROADCAST_UPDATE_UNREAD_MSG = "BROADCAST_UPDATE_UNREAD_MSG";
    public static final String BROADCAST_UPDATE_CONVERSATION_TTR = "BROADCAST_UPDATE_CONVERSATION_TTR";
    public static final String BROADCAST_UPDATE_FORM_URL = "BROADCAST_UPDATE_FORM_URL";
    private static final String BROADCAST_CONVERSATION_FRAGMENT_CLOSED = "BROADCAST_CONVERSATION_FRAGMENT_CLOSED";
    public static final String DELAY_TILL_WHEN = "DELAY_TILL_WHEN";
    public static final String DELAY_TILL_WHEN_CHANGED = "DELAY_TILL_WHEN_CHANGED";
    public static final String BROADCAST_UPDATE_CONVERSATION_OFF_HOURS = "BROADCAST_UPDATE_CONVERSATION_OFF_HOURS";
    public static final String KEY_CONVERSATION_ID = "CONVERSATION_ID";
    public static final String KEY_CONVERSATION_TTR_TIME = "CONVERSATION_TTR_TIME";
    public static final String KEY_CONVERSATION_TARGET_ID = "CONVERSATION_TARGET_ID";
    public static final String KEY_CONVERSATION_STATE = "CONVERSATION_STATE";
    public static final String KEY_CONVERSATION_SHOWED_CSAT = "CONVERSATION_SHOWED_CSAT";
    public static final String KEY_CONVERSATION_ASSIGNED_AGENT = "CONVERSATION_ASSIGNED_AGENT";
    public static final String KEY_WELCOME_CONVERSATION_ID = "WELCOME_CONVERSATION_ID";
    protected final Messaging mController;
    private Map<String, Conversation> mConversationsByAccountId = new HashMap<String, Conversation>();
    private Map<String, Conversation> mConversationsByServerId = new HashMap<String, Conversation>();
    private Queue<Long> pendingConversationRequestId = new Queue();

    public AmsConversations(Messaging controller) {
        super("conversations");
        this.mController = controller;
    }

    public Conversation getConversation(String brandId) {
        return this.getConversationFromTargetIdMap(brandId);
    }

    public DataBaseCommand<Conversation> getActiveConversation(String targetId) {
        return new DataBaseCommand(() -> {
            Conversation conversation = this.mConversationsByAccountId.get(targetId);
            if (conversation != null) {
                if (conversation.getState() == ConversationState.OPEN || conversation.getState() == ConversationState.PENDING) {
                    return conversation;
                }
                return null;
            }
            Cursor cursor = this.getDB().query(null, "target_id=? and state in (?, ?) order by _id desc limit 1", new String[]{targetId, String.valueOf(ConversationState.OPEN.ordinal()), String.valueOf(ConversationState.PENDING.ordinal())}, null, null, null);
            return AmsConversations.readConversation(cursor);
        });
    }

    public DataBaseCommand<Conversation> getConversationById(String targetId, String convId) {
        return new DataBaseCommand(() -> {
            Conversation conversation = this.mConversationsByServerId.get(convId);
            if (conversation != null) {
                return conversation;
            }
            Cursor cursor = this.getDB().query(null, "target_id=? and conversation_id=? ", new String[]{targetId, convId}, null, null, null);
            return AmsConversations.readConversation(cursor);
        });
    }

    private void setConversation(String brandId, Conversation conversation) {
        if (this.getConversationFromTargetIdMap(brandId) == null && conversation == null) {
            return;
        }
        this.addConversationToMaps(brandId, conversation);
        AmsConversations.sendUpdateStateIntent(conversation);
    }

    public boolean isConversationActive(String targetId) {
        Conversation conversation = this.getConversationFromTargetIdMap(targetId);
        return conversation != null && conversation.getState() == ConversationState.OPEN;
    }

    public void loadOpenConversationForBrand(String targetId) {
        DataBaseExecutor.execute(() -> {
            Cursor cursor = this.getDB().query(null, "target_id=? and state in (?, ?) order by _id desc limit 1", new String[]{targetId, String.valueOf(ConversationState.OPEN.ordinal()), String.valueOf(ConversationState.PENDING.ordinal())}, null, null, null);
            Conversation conversation = AmsConversations.readConversation(cursor);
            if (conversation != null) {
                LPLog.INSTANCE.d(TAG, "Setting current conversation for " + targetId + ". conversation id = " + conversation.getConversationId());
                this.setConversation(targetId, conversation);
            }
        });
    }

    private static Conversation readConversation(Cursor cursor) {
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    Conversation conversation = new Conversation(cursor);
                    return conversation;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    public void updateCurrentConversation(ConversationData data) {
        Conversation conversation = this.getConversationFromTargetIdMap(data.targetId);
        ContentValues conversationValues = new ContentValues();
        if (conversation.getState() != data.state) {
            conversation.setState(data.state);
            conversationValues.put("state", Integer.valueOf(data.state != null ? data.state.ordinal() : -1));
        }
        if (conversation.getConversationTTRType() != data.conversationTTRType) {
            conversation.setConversationTTRType(data.conversationTTRType);
            switch (data.conversationTTRType) {
                case URGENT: {
                    this.mController.mEventsProxy.onConversationMarkedAsUrgent();
                    break;
                }
                case NORMAL: {
                    this.mController.mEventsProxy.onConversationMarkedAsNormal();
                }
            }
            conversationValues.put("ttr_type", Integer.valueOf(data.conversationTTRType.ordinal()));
        }
        if (conversation.getRequestId() != data.requestId) {
            conversation.setRequestId(data.requestId);
            conversationValues.put("request_id", Long.valueOf(data.requestId));
        }
        if (!TextUtils.equals((CharSequence)conversation.getConversationId(), (CharSequence)conversation.getConversationId())) {
            conversation.setConversationId(data.conversationId);
            conversationValues.put("conversation_id", data.conversationId);
        }
        if (conversation.getUnreadMessages() != data.unreadMessages) {
            conversation.setUnreadMessages(data.unreadMessages);
            conversationValues.put("unread_msg_count", Integer.valueOf(data.unreadMessages));
            AmsConversations.sendUpdateUnreadMsgIntent(conversation);
        }
        if (conversation.getStartTimestamp() != data.startTs) {
            conversation.setStartTimestamp(data.startTs);
            conversationValues.put("start_timestamp", Long.valueOf(data.startTs));
        }
        if (conversationValues.size() > 0) {
            DataBaseExecutor.execute(() -> {
                this.getDB().update(conversationValues, "conversation_id=?", new String[]{String.valueOf(data.conversationId)});
                AmsConversations.sendUpdateStateIntent(conversation);
            });
        }
    }

    public DataBaseCommand<Conversation> updateCurrentConversationServerID(ConversationData data) {
        Conversation conversation = this.getConversationFromServerIdMap("TEMP_CONVERSATION");
        this.removeTempConversationFromMaps(data.targetId);
        conversation.setState(data.state);
        conversation.setConversationTTRType(data.conversationTTRType);
        conversation.setRequestId(data.requestId);
        conversation.setConversationId(data.conversationId);
        this.addConversationToMaps(data.targetId, conversation);
        return new DataBaseCommand(() -> {
            this.getDB().insert(AmsConversations.getContentValues(conversation));
            AmsConversations.sendUpdateStateIntent(conversation);
            LPLog.INSTANCE.d(TAG, "Finished updating conversation with server id");
            return conversation;
        });
    }

    public DataBaseCommand<Void> deleteTempConversationServerID() {
        return new DataBaseCommand(() -> {
            this.getDB().removeAll("conversation_id=?", new String[]{"TEMP_CONVERSATION"});
            LPLog.INSTANCE.d(TAG, "Finished removing temp conversation");
            return null;
        });
    }

    public void createPendingConversation(String targetId, String brandId, long requestId) {
        this.createConversation(targetId, brandId, ConversationState.PENDING, requestId);
    }

    public void createQueuedConversation(String targetId, String brandId, long requestId) {
        this.createConversation(targetId, brandId, ConversationState.QUEUED, requestId);
    }

    private void createConversation(String targetId, String brandId, ConversationState conversationState, long requestId) {
        Conversation conversation = new Conversation(targetId, brandId);
        conversation.setConversationId("TEMP_CONVERSATION");
        conversation.setState(conversationState);
        conversation.setConversationTTRType(TTRType.NORMAL);
        conversation.setRequestId(requestId);
        this.addConversationToMaps(targetId, conversation);
        DataBaseExecutor.execute(() -> {
            ContentValues conversationValues = new ContentValues();
            conversationValues.put("brand_id", conversation.getBrandId());
            conversationValues.put("target_id", conversation.getTargetId());
            conversationValues.put("conversation_id", conversation.getConversationId());
            conversationValues.put("state", Integer.valueOf(conversation.getState().ordinal()));
            conversationValues.put("ttr_type", Integer.valueOf(conversation.getConversationTTRType().ordinal()));
            conversationValues.put("request_id", Long.valueOf(conversation.getRequestId()));
            conversationValues.put("unread_msg_count", Integer.valueOf(-1));
            conversationValues.put("start_timestamp", Long.valueOf(System.currentTimeMillis()));
            this.getDB().insert(conversationValues);
            LPLog.INSTANCE.d(TAG, "create New Pending Conversation - tempID = " + conversation.getConversationId());
            AmsConversations.sendUpdateStateIntent(conversation);
        });
    }

    public Conversation createNewCurrentConversation(ConversationData data) {
        Conversation conversation = new Conversation(data);
        this.addConversationToMaps(data.targetId, conversation);
        DataBaseExecutor.execute(() -> {
            this.getDB().insert(AmsConversations.getContentValues(conversation));
            LPLog.INSTANCE.i(TAG, "Create new current conversation - conversation Id = " + data.conversationId);
            AmsConversations.sendUpdateStateIntent(conversation);
            AmsConversations.sendUpdateNewConversationIntent(conversation);
        });
        return conversation;
    }

    public DataBaseCommand<Conversation> updateClosedConversation(ConversationData conversationData, boolean shouldUpdateUI) {
        String brandId = conversationData.targetId;
        Conversation conversation = this.getConversationFromTargetIdMap(brandId);
        shouldUpdateUI = this.shouldNotifyUIConversationClosed(conversationData.closeReason, conversationData.brandId, conversationData.endTs, shouldUpdateUI);
        CSAT.CSAT_SHOW_STATUS isShowedCsat = AmsConversations.calculateShowedCsat(conversationData, shouldUpdateUI);
        if (conversation != null && conversationData.conversationId.equals(conversation.getConversationId())) {
            if (conversation.getState() != ConversationState.CLOSE) {
                LPLog.INSTANCE.i(TAG, "Closing conversation " + conversationData.conversationId + ", close reason:" + (Object)((Object)conversationData.closeReason) + ", close ts:" + conversationData.endTs);
                conversation.setState(ConversationState.CLOSE);
                conversation.getTTRManager().cancelAll();
                conversation.setCloseReason(conversationData.closeReason);
                conversation.setEndTimestamp(conversationData.endTs);
            }
            conversation.setShowedCSAT(isShowedCsat);
        }
        boolean finalUpdateUI = shouldUpdateUI;
        return new DataBaseCommand(() -> {
            Cursor cursor = this.getDB().query(null, "conversation_id=?", new String[]{conversationData.conversationId}, null, null, null);
            Conversation conversation1 = AmsConversations.readConversation(cursor);
            if (conversation1 == null) {
                LPLog.INSTANCE.i(TAG, "Old conversation " + conversationData.conversationId + " does not exist in DB. creating new one closed conversation, close reason:" + (Object)((Object)conversationData.closeReason) + ", close ts:" + conversationData.endTs);
                conversation1 = new Conversation(conversationData);
                conversation1.setConversationId(conversationData.conversationId);
                conversation1.setConversationTTRType(conversationData.conversationTTRType);
                conversation1.setCloseReason(conversationData.closeReason);
                conversation1.setEndTimestamp(conversationData.endTs);
                conversation1.setState(ConversationState.CLOSE);
                conversation1.setShowedCSAT(isShowedCsat);
                this.getDB().insert(AmsConversations.getContentValues(conversation1));
            } else {
                String assignedAgentId = conversationData.getAssignedAgentId();
                if (conversation1.getState() != ConversationState.CLOSE) {
                    LPLog.INSTANCE.d(TAG, "Closing current conversation.. ");
                    conversation1.setState(ConversationState.CLOSE);
                    conversation1.setCloseReason(conversationData.closeReason);
                    conversation1.setEndTimestamp(conversationData.endTs);
                    conversation1.setShowedCSAT(isShowedCsat);
                    this.getDB().update(AmsConversations.getContentValues(conversation1), "conversation_id=?", new String[]{String.valueOf(conversation1.getConversationId())});
                    if (finalUpdateUI) {
                        AmsConversations.sendUpdateCSATConversationIntent(conversation1, assignedAgentId);
                    }
                    AmsConversations.sendConversationClosedIntent(conversation1, assignedAgentId);
                } else {
                    if (conversation1.isShowedCSAT() != isShowedCsat) {
                        conversation1.setShowedCSAT(isShowedCsat);
                        this.getDB().update(AmsConversations.getContentValues(conversation1), "conversation_id=?", new String[]{String.valueOf(conversation1.getConversationId())});
                    }
                    if (finalUpdateUI) {
                        AmsConversations.sendUpdateCSATConversationIntent(conversation1, assignedAgentId);
                    }
                    AmsConversations.sendConversationClosedIntent(conversation1, assignedAgentId);
                    return null;
                }
            }
            return conversation1;
        });
    }

    public void notifyClosedConversationFromDB(String brandId) {
        DataBaseExecutor.execute(() -> {
            LPLog.INSTANCE.d(TAG, "notifyClosedConversationFromDB");
            Cursor c = this.getDB().rawQuery("select * from conversations where end_timestamp = ( SELECT MAX ( end_timestamp ) from  conversations where brand_id = ? and state = ? )", new Object[]{brandId, ConversationState.CLOSE.ordinal()});
            if (c != null) {
                try {
                    Conversation conversation = AmsConversations.readConversation(c);
                    if (conversation != null) {
                        String assignedAgentId;
                        ArrayList<Dialog> dialogs;
                        LPLog.INSTANCE.d(TAG, "notifyClosedConversationFromDB : " + conversation.getConversationId());
                        LPLog.INSTANCE.d(TAG, "notifyClosedConversationFromDB conversation.isShowedCSAT(): " + (Object)((Object)conversation.isShowedCSAT()));
                        Dialog currentDialog = this.mController.amsDialogs.getActiveDialog();
                        if (currentDialog == null && (dialogs = this.mController.amsDialogs.getDialogsByConversationId(conversation.getConversationId())).size() != 0) {
                            currentDialog = dialogs.get(0);
                        }
                        String string2 = assignedAgentId = currentDialog != null ? currentDialog.getAssignedAgentId() : "";
                        if (conversation.isShowedCSAT() == CSAT.CSAT_SHOW_STATUS.NOT_SHOWN) {
                            LPLog.INSTANCE.d(TAG, "notifyClosedConversationFromDB : " + conversation.getConversationId());
                            if (this.shouldNotifyUIConversationClosed(conversation.getCloseReason(), brandId, conversation.getEndTimestamp(), true)) {
                                AmsConversations.sendUpdateCSATConversationIntent(conversation, assignedAgentId);
                            }
                        }
                        AmsConversations.sendConversationClosedIntent(conversation, assignedAgentId);
                    }
                }
                finally {
                    c.close();
                }
            }
        });
    }

    private boolean shouldNotifyUIConversationClosed(CloseReason closeReason, String brandId, long closeTS, boolean updateUI) {
        if (updateUI) {
            if (this.isAutoClose(closeReason)) {
                LPLog.INSTANCE.d(TAG, "Updating closed conversation. Close Reason = System. do not update UI.");
                updateUI = false;
            } else {
                updateUI = this.checkExpiry(brandId, closeTS, updateUI);
            }
        }
        return updateUI;
    }

    private boolean isAutoClose(CloseReason closeReason) {
        return closeReason == CloseReason.TIMEOUT || closeReason == CloseReason.SYSTEM;
    }

    private boolean checkExpiry(String brandId, long closeTS, boolean updateUI) {
        int expirationInMinutes = Configuration.getInteger((int)R.integer.csatSurveyExpirationInMinutes);
        if (expirationInMinutes != 0) {
            long expirationInMillis;
            long endTime;
            long clockDiff = this.mController.mConnectionController.getClockDiff(brandId);
            long now = System.currentTimeMillis();
            if (now - (endTime = clockDiff + closeTS) > (expirationInMillis = TimeUnit.MINUTES.toMillis(expirationInMinutes))) {
                LPLog.INSTANCE.d(TAG, "Closing conversation- time expired for CSAT. endTime = " + endTime + " expirationInMinutes = " + expirationInMinutes);
                updateUI = false;
            }
        }
        return updateUI;
    }

    public static CSAT.CSAT_SHOW_STATUS calculateShowedCsat(ConversationData conversationData, boolean updateUI) {
        CSAT.CSAT_SHOW_STATUS isShowedCsat = CSAT.CSAT_SHOW_STATUS.NOT_SHOWN;
        if (updateUI) {
            if (conversationData.csat != null) {
                isShowedCsat = conversationData.csat.isShowedCsat();
            }
        } else {
            isShowedCsat = CSAT.CSAT_SHOW_STATUS.NO_NEED_TO_SHOW;
        }
        return isShowedCsat;
    }

    private static void sendConversationClosedIntent(Conversation conversation, String assignedAgentId) {
        Bundle extras = new Bundle();
        extras.putString(KEY_CONVERSATION_TARGET_ID, conversation.getTargetId());
        extras.putString(KEY_CONVERSATION_ID, conversation.getConversationId());
        extras.putString(KEY_CONVERSATION_ASSIGNED_AGENT, assignedAgentId);
        LPLog.INSTANCE.d(TAG, "Sending Conversation autoClosed update with : " + extras);
        LocalBroadcast.sendBroadcast((String)BROADCAST_UPDATE_CONVERSATION_CLOSED, (Bundle)extras);
    }

    private static void sendUpdateStateIntent(Conversation conversation) {
        Bundle extras = new Bundle();
        extras.putString(KEY_CONVERSATION_TARGET_ID, conversation.getTargetId());
        extras.putString(KEY_CONVERSATION_ID, conversation.getConversationId());
        extras.putInt(KEY_CONVERSATION_STATE, conversation.getState().ordinal());
        LPLog.INSTANCE.d(TAG, "Sending Conversation update with : " + extras);
        LocalBroadcast.sendBroadcast((String)BROADCAST_UPDATE_CONVERSATION, (Bundle)extras);
    }

    private static void sendUpdateCSATConversationIntent(Conversation conversation, String assignedAgentId) {
        Bundle extras = new Bundle();
        extras.putString(KEY_CONVERSATION_TARGET_ID, conversation.getTargetId());
        extras.putString(KEY_CONVERSATION_ID, conversation.getConversationId());
        extras.putInt(KEY_CONVERSATION_STATE, conversation.getState().ordinal());
        extras.putString(KEY_CONVERSATION_ASSIGNED_AGENT, assignedAgentId);
        extras.putInt(KEY_CONVERSATION_SHOWED_CSAT, conversation.isShowedCSAT().getValue());
        LPLog.INSTANCE.d(TAG, "Sending Conversation CSAT update with : " + extras);
        LocalBroadcast.sendBroadcast((String)BROADCAST_UPDATE_CSAT_CONVERSATION, (Bundle)extras);
    }

    private static void sendUpdateNewConversationIntent(Conversation conversation) {
        Bundle extras = new Bundle();
        extras.putString(KEY_CONVERSATION_TARGET_ID, conversation.getTargetId());
        extras.putString(KEY_CONVERSATION_ID, conversation.getConversationId());
        LPLog.INSTANCE.d(TAG, "Sending Conversation update with : " + extras);
        LocalBroadcast.sendBroadcast((String)BROADCAST_UPDATE_NEW_CONVERSATION_MSG, (Bundle)extras);
    }

    private static void sendUpdateUnreadMsgIntent(Conversation conversation) {
        Bundle extras = new Bundle();
        extras.putString(KEY_CONVERSATION_TARGET_ID, conversation.getTargetId());
        LPLog.INSTANCE.d(TAG, "Sending Conversation update with : " + extras);
        LocalBroadcast.sendBroadcast((String)BROADCAST_UPDATE_UNREAD_MSG, (Bundle)extras);
    }

    private static ContentValues getContentValues(Conversation conversation) {
        ContentValues conversationValues = new ContentValues();
        conversationValues.put("conversation_id", conversation.getConversationId());
        conversationValues.put("brand_id", conversation.getBrandId());
        conversationValues.put("target_id", conversation.getTargetId());
        conversationValues.put("state", Integer.valueOf(conversation.getState() != null ? conversation.getState().ordinal() : -1));
        conversationValues.put("ttr_type", Integer.valueOf(conversation.getConversationTTRType() != null ? conversation.getConversationTTRType().ordinal() : -1));
        conversationValues.put("request_id", Long.valueOf(conversation.getRequestId()));
        conversationValues.put("close_reason", Integer.valueOf(conversation.getCloseReason() != null ? conversation.getCloseReason().ordinal() : -1));
        conversationValues.put("start_timestamp", Long.valueOf(conversation.getStartTimestamp()));
        conversationValues.put("end_timestamp", Long.valueOf(conversation.getEndTimestamp()));
        conversationValues.put("csat_status", Integer.valueOf(conversation.isShowedCSAT().getValue()));
        conversationValues.put("unread_msg_count", Integer.valueOf(conversation.getUnreadMessages()));
        return conversationValues;
    }

    public void updateTTRType(String targetId, TTRType type, long effectiveTTR) {
        Conversation conversation = this.getConversationFromTargetIdMap(targetId);
        if (conversation != null) {
            conversation.getTTRManager().updateTTR(targetId, effectiveTTR);
            if (type != conversation.getConversationTTRType()) {
                conversation.setConversationTTRType(type);
                DataBaseExecutor.execute(() -> {
                    ContentValues conversationValues = new ContentValues();
                    conversationValues.put("ttr_type", Integer.valueOf(type.ordinal()));
                    this.getDB().update(conversationValues, "conversation_id=?", new String[]{String.valueOf(conversation.getConversationId())});
                });
            }
        }
    }

    public long calculateEffectiveTTR(String targetId, long ttrValue, long manualTTR, long delayTTR, long clockDiff) {
        long effectiveTTR = -1L;
        Conversation conversation = this.getConversationFromTargetIdMap(targetId);
        if (conversation != null) {
            effectiveTTR = conversation.getTTRManager().calculateEffectiveTTR(targetId, ttrValue, manualTTR, delayTTR, clockDiff);
        }
        return effectiveTTR;
    }

    public void resetEffectiveTTR(String targetId) {
        Conversation conversation = this.getConversationFromTargetIdMap(targetId);
        if (conversation != null) {
            conversation.getTTRManager().resetEffectiveTTR();
        }
    }

    public void showTTR(String targetId) {
        Conversation conversation = this.getConversationFromTargetIdMap(targetId);
        if (conversation != null) {
            conversation.getTTRManager().showTTR(targetId);
        }
    }

    public void notifyOffHoursStatus(String brandId) {
        Conversation conversation = this.getConversationFromBrandIdMap(brandId);
        if (conversation != null) {
            conversation.getTTRManager().updateIfOffHours(brandId);
        }
    }

    public void updateCSAT(String brandId, String conversationIdToUpdate) {
        Conversation conversation = this.getConversationFromTargetIdMap(brandId);
        if (conversation != null && conversationIdToUpdate.equals(conversation.getConversationId())) {
            conversation.setShowedCSAT(CSAT.CSAT_SHOW_STATUS.SHOWN);
        }
        DataBaseExecutor.execute(() -> {
            ContentValues conversationValues = new ContentValues();
            conversationValues.put("csat_status", Integer.valueOf(CSAT.CSAT_SHOW_STATUS.SHOWN.getValue()));
            this.getDB().update(conversationValues, "conversation_id=?", new String[]{String.valueOf(conversationIdToUpdate)});
        });
    }

    public DataBaseCommand<Conversation> queryConversationById(String serverID) {
        return new DataBaseCommand(() -> {
            Cursor c = this.getDB().rawQuery("select * from conversations where conversation_id = ?", new Object[]{serverID});
            Conversation conversation = null;
            if (c != null) {
                conversation = AmsConversations.readConversation(c);
            }
            return conversation;
        });
    }

    private void addConversationToMaps(String targetId, Conversation conversation) {
        this.mConversationsByAccountId.put(targetId, conversation);
        this.mConversationsByServerId.put(conversation.getConversationId(), conversation);
        LPLog.INSTANCE.d(TAG, "Putting conversation in ConversationMap. Conversation Id: " + conversation.getConversationId() + " targetId: " + conversation.getTargetId());
    }

    private void removeTempConversationFromMaps(String targetId) {
        Conversation conversationByAccount = this.mConversationsByAccountId.get(targetId);
        if (conversationByAccount != null && conversationByAccount.getConversationId().equals("TEMP_CONVERSATION")) {
            this.mConversationsByAccountId.remove(targetId);
        }
        this.mConversationsByServerId.remove("TEMP_CONVERSATION");
        LPLog.INSTANCE.d(TAG, "Removing temp conversation Id: TEMP_CONVERSATION targetId: " + targetId);
    }

    private Conversation getConversationFromBrandIdMap(String brandId) {
        String conversationServerId;
        Conversation conversation = this.mConversationsByAccountId.get(brandId);
        if (conversation != null && (conversationServerId = conversation.getConversationId()) != null && this.mConversationsByServerId.get(conversationServerId) == null) {
            this.mConversationsByServerId.put(conversationServerId, conversation);
        }
        return conversation;
    }

    private void removeAllConversationsFromMaps(String targetId) {
        if (this.isConversationActive(targetId)) {
            LPLog.INSTANCE.w(TAG, "removeAllConversationsFromMaps: current conversation from brand " + targetId + " is active. Did not remove");
            return;
        }
        Conversation conversationByAccount = this.mConversationsByAccountId.get(targetId);
        if (conversationByAccount != null) {
            String conversationId = conversationByAccount.getConversationId();
            this.mConversationsByServerId.remove(conversationId);
            LPLog.INSTANCE.d(TAG, "removeAllConversationsFromMaps: Removing conversation ID" + conversationId);
            this.mConversationsByAccountId.remove(targetId);
            LPLog.INSTANCE.d(TAG, "Removed conversations of targetId: " + targetId);
        }
    }

    public DataBaseCommand<Integer> clearClosedConversations(final String targetId) {
        this.removeAllConversationsFromMaps(targetId);
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){
            String whereString = "target_id=? and state=?";
            String[] whereArgs = new String[]{targetId, String.valueOf(ConversationState.CLOSE.ordinal())};

            public Integer query() {
                return AmsConversations.this.getDB().removeAll(this.whereString, this.whereArgs);
            }
        });
    }

    public DataBaseCommand<Integer> clearAllConversations(final String targetId) {
        this.removeAllConversationsFromMaps(targetId);
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){
            String whereString = "target_id=?";
            String[] whereArgs = new String[]{targetId};

            public Integer query() {
                return AmsConversations.this.getDB().removeAll(this.whereString, this.whereArgs);
            }
        });
    }

    public Conversation getConversationFromTargetIdMap(String targetId) {
        String conversationServerId;
        Conversation conversation = this.mConversationsByAccountId.get(targetId);
        if (conversation != null && (conversationServerId = conversation.getConversationId()) != null && this.mConversationsByServerId.get(conversationServerId) == null) {
            this.mConversationsByServerId.put(conversationServerId, conversation);
        }
        return conversation;
    }

    private Conversation getConversationFromServerIdMap(String conversationServerId) {
        Conversation conversation = this.mConversationsByServerId.get(conversationServerId);
        if (conversation == null) {
            for (Map.Entry<String, Conversation> convEntry : this.mConversationsByAccountId.entrySet()) {
                Conversation convEntryValue = convEntry.getValue();
                String convEntryValueServerId = convEntryValue.getConversationId();
                if (!conversationServerId.equals(convEntryValueServerId)) continue;
                this.mConversationsByServerId.put(conversationServerId, convEntryValue);
                return convEntryValue;
            }
        }
        return conversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation getNewestClosedConversation(String targetId) {
        Cursor c = this.getDB().rawQuery("select * from conversations where target_id = ? and state = ? order by end_timestamp DESC limit 1", new Object[]{targetId, ConversationState.CLOSE.ordinal()});
        if (c != null && c.moveToFirst()) {
            try {
                if (c.getCount() == 1) {
                    Conversation conversation = new Conversation(c);
                    return conversation;
                }
            }
            finally {
                c.close();
            }
        }
        return null;
    }

    public void setUpdateRequestInProgress(String conversationId, int numUpdateInProgress) {
        Conversation conversation = this.getConversation(conversationId);
        if (conversation != null) {
            LPLog.INSTANCE.d(TAG, "adding update request in progress for conversation: " + conversationId + ", requests in progress: " + numUpdateInProgress);
            conversation.setUpdateInProgress(numUpdateInProgress);
        }
        DataBaseExecutor.execute(() -> {
            LPLog.INSTANCE.d(TAG, "update request for conversation in DB: " + conversationId + ", numUpdateInProgress: " + numUpdateInProgress);
            ContentValues conversationValues = new ContentValues();
            conversationValues.put("concurrent_requests_counter", Integer.valueOf(numUpdateInProgress));
            this.getDB().update(conversationValues, "conversation_id=?", new String[]{String.valueOf(conversationId)});
        });
    }

    public void addUpdateRequestInProgress(String conversationId) {
        Conversation conversation = this.getConversation(conversationId);
        if (conversation != null) {
            int mUpdateInProgress = conversation.getUpdateInProgress() + 1;
            LPLog.INSTANCE.d(TAG, "adding update request in progress for conversation: " + conversationId + ", requests in progress: " + mUpdateInProgress);
            conversation.setUpdateInProgress(mUpdateInProgress);
        }
        this.updateRequestsInProgress(conversationId, 1);
    }

    public void removeUpdateRequestInProgress(String conversationId) {
        Conversation conversation = this.getConversation(conversationId);
        if (conversation != null) {
            int mUpdateInProgress = conversation.getUpdateInProgress() - 1;
            LPLog.INSTANCE.d(TAG, "removing update request for conversation: " + conversationId + ", requests in progress: " + mUpdateInProgress);
            conversation.setUpdateInProgress(mUpdateInProgress);
        }
        this.updateRequestsInProgress(conversationId, -1);
    }

    private void updateRequestsInProgress(String conversationId, int addValue) {
        DataBaseExecutor.execute(() -> {
            try (Cursor c = this.getDB().query(new String[]{"concurrent_requests_counter"}, "conversation_id = ? ", new String[]{conversationId}, null, null, null);){
                int updateInProgress = 0;
                if (c != null && c.moveToFirst()) {
                    updateInProgress = c.getInt(c.getColumnIndex("concurrent_requests_counter"));
                }
                LPLog.INSTANCE.d(TAG, "update request for conversation in DB: " + conversationId + ", requests in progress: " + updateInProgress + " added value = " + addValue);
                ContentValues conversationValues = new ContentValues();
                conversationValues.put("concurrent_requests_counter", Integer.valueOf(updateInProgress + addValue));
                this.getDB().update(conversationValues, "conversation_id=?", new String[]{String.valueOf(conversationId)});
            }
        });
    }

    public void updateConversationState(String targetId, String conversationId, ConversationState state) {
        Conversation conversation = this.getConversation(targetId);
        if (conversation != null) {
            LPLog.INSTANCE.d(TAG, "update conversation state, new state = " + (Object)((Object)state));
            conversation.setState(state);
        }
        DataBaseExecutor.execute(() -> {
            LPLog.INSTANCE.d(TAG, "update new state for conversation in DB: " + conversationId + ", state: " + (Object)((Object)state));
            ContentValues conversationValues = new ContentValues();
            conversationValues.put("state", Integer.valueOf(state.ordinal()));
            this.getDB().update(conversationValues, "conversation_id=?", new String[]{String.valueOf(conversationId)});
        });
    }

    public DataBaseCommand<List<Conversation>> getNotUpdatedConversations(String brandId) {
        return new DataBaseCommand(() -> {
            try (Cursor c = this.getDB().rawQuery("select * from conversations where brand_id = ? and concurrent_requests_counter > 0 ", new Object[]{brandId});){
                if (c != null) {
                    ArrayList<Conversation> conversations = new ArrayList<Conversation>(c.getCount());
                    while (c.moveToNext()) {
                        conversations.add(new Conversation(c));
                    }
                    ArrayList<Conversation> arrayList = conversations;
                    return arrayList;
                }
            }
            return null;
        });
    }

    public void clear() {
        for (Conversation conversation : this.mConversationsByAccountId.values()) {
            conversation.getTTRManager().clear();
        }
        for (Conversation conversation : this.mConversationsByServerId.values()) {
            conversation.getTTRManager().clear();
        }
        this.mConversationsByAccountId.clear();
        this.mConversationsByServerId.clear();
    }

    public void shutDown() {
        for (Conversation conversation : this.mConversationsByAccountId.values()) {
            conversation.getTTRManager().shutDown();
        }
    }

    public void markAllPendingConversationsAsFailed(String brandId) {
        Conversation conversation = this.getConversationFromTargetIdMap(brandId);
        if (conversation != null && (conversation.getState() == ConversationState.PENDING || conversation.getState() == ConversationState.QUEUED)) {
            conversation.setState(ConversationState.CLOSE);
            conversation.setEndTimestamp(System.currentTimeMillis());
        }
        DataBaseExecutor.execute(() -> {
            String where = "state =? AND brand_id = ?";
            ContentValues contentValues = new ContentValues();
            contentValues.put("state", Integer.valueOf(ConversationState.CLOSE.ordinal()));
            int result = this.getDB().update(contentValues, where, new String[]{String.valueOf(ConversationState.PENDING.ordinal()), brandId});
            LPLog.INSTANCE.d(TAG, String.format(Locale.ENGLISH, "Updated %d pending conversation as Closed on DB", result));
        });
    }

    public void createDummyConversationForWelcomeMessage(String brandId, String dummyConversationId, long startTime) {
        DataBaseExecutor.execute(() -> {
            ContentValues conversationValues = new ContentValues();
            conversationValues.put("brand_id", brandId);
            conversationValues.put("target_id", brandId);
            conversationValues.put("conversation_id", dummyConversationId);
            conversationValues.put("state", Integer.valueOf(ConversationState.LOCKED.ordinal()));
            conversationValues.put("ttr_type", Integer.valueOf(TTRType.NORMAL.ordinal()));
            conversationValues.put("request_id", Integer.valueOf(-1));
            conversationValues.put("unread_msg_count", Integer.valueOf(-1));
            conversationValues.put("start_timestamp", Long.valueOf(startTime));
            this.getDB().insert(conversationValues);
            LPLog.INSTANCE.d(TAG, "created dummy conversation for first message- startTime = " + startTime);
        });
    }

    public void enqueuePendingConversationRequestId(Long requestId) {
        this.pendingConversationRequestId.add((Object)requestId);
    }

    @Nullable
    public Long dequeuePendingConversationRequestId() {
        return (Long)this.pendingConversationRequestId.poll();
    }

    public void notifyConversationFragmentClosedEvent() {
        LocalBroadcast.sendBroadcast((String)BROADCAST_CONVERSATION_FRAGMENT_CLOSED);
        this.mController.mEventsProxy.onConversationFragmentClosed();
    }
}

