/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.SetUserProfile;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.MessagingUserProfile;
import org.json.JSONException;
import org.json.JSONObject;

public class SetUsersProfileRequest
extends BaseAMSSocketRequest<ReqBody.StringResp, SetUsersProfileRequest> {
    private static final String TAG = "SetUsersProfileRequest";
    private final MessagingUserProfile mProfile;
    private final AmsUsers mAmsUsers;
    private final String mBrandId;

    public SetUsersProfileRequest(AmsUsers amsUsers, String mSocketUrl, String brandId, MessagingUserProfile userProfile) {
        super(mSocketUrl);
        this.mBrandId = brandId;
        this.mProfile = userProfile;
        this.mAmsUsers = amsUsers;
    }

    protected BaseResponseHandler<ReqBody.StringResp, SetUsersProfileRequest> getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, SetUsersProfileRequest>(){

            public String getAPIResponseType() {
                return "StringResponse";
            }

            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            protected boolean handle(ReqBody.StringResp response) {
                LPLog.INSTANCE.d(SetUsersProfileRequest.TAG, "Received response: " + LPLog.INSTANCE.mask((Object)response.getBody()));
                if (response.code == 200) {
                    SetUsersProfileRequest.this.mProfile.setBrandID(SetUsersProfileRequest.this.mBrandId);
                    SetUsersProfileRequest.this.mAmsUsers.updateUserProfile(SetUsersProfileRequest.this.mProfile);
                } else {
                    LPLog.INSTANCE.w(SetUsersProfileRequest.TAG, "Received response code other than 200 (" + response.code + "). Did not update DB");
                }
                return true;
            }
        };
    }

    protected String getData() {
        return new SetUserProfile(this.mProfile).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }
}

