package com.liveperson.messaging.commands;

import com.liveperson.infra.Command;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;

/**
 * Created by shiranr on 1/17/18.
 */

public abstract class BasicQueryMessagesCommand implements Command {

    protected final String brandID;
    protected final String conversationId;
    protected final String dialogId;
    protected final Messaging controller;
    protected boolean mUpdateUI;
    protected BaseAmsSocketConnectionCallback mResponseCallBack = null;

    public BasicQueryMessagesCommand(Messaging controller, String brandId, String conversationId, String dialogId, boolean updateUI) {
        this.controller = controller;
        this.brandID = brandId;
        this.conversationId = conversationId;
        this.dialogId = dialogId;
        this.mUpdateUI = updateUI;
    }

    public void setResponseCallBack(BaseAmsSocketConnectionCallback callBack) {
        this.mResponseCallBack = callBack;
    }
}
