package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.GenerateURLForUploadFile;
import com.liveperson.api.response.IOnUrlReady;
import com.liveperson.messaging.Messaging;

/**
 * Created by Ilya Gazman on 11/10/2015.
 * <p/>
 * A request to send message
 */
public class GetUrlForUploadRequest extends BaseGetUrlRequest {

    private static final String TAG = "GetUrlForUploadRequest";
    private int mFileSize;
    private String mFileType;

    /**
     * This constructor creates a SendMessageRequest with the next requestID (auto incremented)
     *
     * @param brandId
     * @param fileSize
     */
    public GetUrlForUploadRequest(Messaging controller, String brandId, int fileSize,String fileType, IOnUrlReady listener) {
        super(controller, brandId, listener);

        mFileSize = fileSize;
        mFileType = fileType;

    }

    @Override
    protected String getData() {
        return new GenerateURLForUploadFile(mFileType, mFileSize).toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }


}