package com.liveperson.messaging.offline.api

import androidx.annotation.WorkerThread
import com.liveperson.messaging.model.Conversation

interface OfflineConversationRepository {

    /**
     * Remove the offline conversation from cache and from the database
     * @param targetId the target id
     */
    @WorkerThread
    fun clearOfflineConversation(targetId: String)

    /**
     * Retrieve the offline conversation from cache or from the database, or create a new offline
     * conversation if one doesn't exist yet.
     * @param targetId the target id
     * @param brandId the brand id
     * @param requestId the request id
     * @return the stored offline conversation or a newly created one
     */
    @WorkerThread
    fun getOrCreateOfflineConversation(targetId: String, brandId: String, requestId: Long): Conversation

    /**
     * Query the database for retrieving the count of real conversations
     * @return the number of real conversations stored in the database
     */
    @WorkerThread
    fun queryRealConversationsCount(): Int
}