package com.liveperson.messaging.wm.impl

import android.content.ContentResolver
import android.content.ContentValues
import android.net.Uri
import com.liveperson.messaging.wm.core.MultiProcessEditorHelper

/**
 * Default implementation of MultiProcessEditor helper that
 * interacts with multi-process store using ContentResolver API.
 *
 * @param contentResolver ContentResolver associated with ContentProvider
 * that uses multi-process shared preferences to store values.
 * @param uriGenerator generator for welcome message provider uri
 * to receive values
 *
 *
 * @see MultiProcessEditorHelper for documentation of implemented methods
 */
internal class MultiProcessEditorHelperImpl constructor(
    private val contentResolver: ContentResolver,
    private val uriGenerator: (key: String, type: String) -> Uri
) : MultiProcessEditorHelper {
    override fun commit(contentValues: ContentValues): Boolean {
        return contentResolver.insert(uriGenerator(COMMON_KEY, COMMON_TYPE), contentValues) != null
    }

    override fun apply(contentValues: ContentValues) {
        contentResolver.insert(uriGenerator(COMMON_KEY, COMMON_TYPE), contentValues)
    }

    override fun remove(key: String) {
        contentResolver.delete(uriGenerator(key, COMMON_TYPE), null, null)
    }

    override fun clear() {
        contentResolver.delete(uriGenerator(COMMON_KEY, COMMON_KEY), null, null)
    }
}