/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing.image;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.network.http.RestRequestParams;

public class UploadImageTaskBundle
extends UploadFileTaskBundle {
    private boolean mImageFromCamera;
    private boolean addBlurEffect;

    @Override
    public UploadImageTaskBundle addBrandId(String brandId) {
        super.addBrandId(brandId);
        return this;
    }

    @Override
    public UploadImageTaskBundle addTargetId(String targetId) {
        super.addTargetId(targetId);
        return this;
    }

    @Override
    public UploadImageTaskBundle addSwiftDomain(String swiftDomain) {
        super.addSwiftDomain(swiftDomain);
        return this;
    }

    @Override
    public UploadImageTaskBundle addRestDomain(RestRequestParams restRequestParams) {
        super.addRestDomain(restRequestParams);
        return this;
    }

    @Override
    public UploadImageTaskBundle addFileUri(Uri fileUri) {
        super.addFileUri(fileUri);
        return this;
    }

    @Override
    public UploadImageTaskBundle addMessage(MaskedMessage maskedMessage) {
        super.addMessage(maskedMessage);
        return this;
    }

    public UploadImageTaskBundle addImageFromCamera(boolean imageFromCamera) {
        this.mImageFromCamera = imageFromCamera;
        return this;
    }

    public UploadImageTaskBundle addBlurEffect(boolean blurEffect) {
        this.addBlurEffect = blurEffect;
        return this;
    }

    @Override
    public UploadImageTaskBundle build(int taskId, Context context) {
        this.setTaskID(taskId);
        this.mFilePath = ImageUtils.getImagePath((Context)context, (Uri)this.mFileUri);
        if ("content".equals(this.mFileUri.getScheme())) {
            String extensionFromMimeType;
            ContentResolver cR = context.getContentResolver();
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            this.mFileContentType = cR.getType(this.mFileUri);
            if (this.mFileContentType != null && (extensionFromMimeType = mime.getExtensionFromMimeType(this.mFileContentType)) != null) {
                this.mFileTypeExtension = extensionFromMimeType.toUpperCase();
            }
        } else {
            String fileExtensionFromUrl = MimeTypeMap.getFileExtensionFromUrl((String)this.mFileUri.toString());
            if (fileExtensionFromUrl != null) {
                this.mFileTypeExtension = fileExtensionFromUrl.toUpperCase();
            }
            if (this.mFileTypeExtension != null) {
                this.mFileContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(this.mFileTypeExtension.toLowerCase());
            }
        }
        if (!"jpg".equalsIgnoreCase(this.mFileTypeExtension) && !"png".equalsIgnoreCase(this.mFileTypeExtension)) {
            this.mFileTypeExtension = "jpg".toUpperCase();
        }
        if ("image/gif".equals(this.mFileContentType)) {
            this.mFileContentType = "image/jpeg";
        }
        return this;
    }

    public boolean isImageFromCamera() {
        return this.mImageFromCamera;
    }

    public boolean shouldAddBlurEffect() {
        return this.addBlurEffect;
    }
}

