/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.ContentValues;
import android.database.Cursor;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.model.MultiDialog;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.utils.ClockUtils;
import com.liveperson.infra.utils.CollectionsUtil;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.cache.DialogsCacheProvider;
import com.liveperson.messaging.commands.tasks.FetchConversationManager;
import com.liveperson.messaging.model.AmsConnection;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;
import com.liveperson.messaging.offline.OfflineDialogRepositoryImpl;
import com.liveperson.messaging.offline.OfflineMessagingManager;
import com.liveperson.messaging.offline.api.OfflineDialogRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AmsDialogs
extends BaseDBRepository
implements DialogsCacheProvider,
ShutDown,
Clearable {
    private static final String TAG = "AmsDialogs";
    public static final String KEY_DIALOG_ID = "DIALOG_ID";
    public static final String KEY_DIALOG_TARGET_ID = "KEY_DIALOG_TARGET_ID";
    public static final String KEY_DIALOG_STATE = "KEY_DIALOG_STATE";
    public static final String KEY_DIALOG_SHOWED_CSAT = "KEY_DIALOG_SHOWED_CSAT";
    public static final String KEY_DIALOG_ASSIGNED_AGENT = "KEY_DIALOG_ASSIGNED_AGENT";
    public static final String KEY_WELCOME_DIALOG_ID = "KEY_WELCOME_DIALOG_ID";
    protected final Messaging mController;
    @Nullable
    private Dialog mActiveDialog;
    private String activeCoBrowseDialogId;
    private Map<String, Dialog> mDialogsByDialogId = new HashMap<String, Dialog>();
    private HashSet<Integer> acceptedSequenceEvents = new HashSet();
    private final OfflineDialogRepository mOfflineDialogRepository;

    public AmsDialogs(Messaging controller) {
        super("dialogs");
        this.mController = controller;
        this.mOfflineDialogRepository = new OfflineDialogRepositoryImpl(this);
    }

    public DataBaseCommand<Dialog> queryActiveDialog(String brandId) {
        return new DataBaseCommand(() -> {
            Dialog dialog = this.mActiveDialog;
            if (dialog != null && dialog.getBrandId().equals(brandId)) {
                if ((dialog.getState() == DialogState.OPEN || dialog.getState() == DialogState.PENDING) && dialog.getChannelType() == MultiDialog.ChannelType.MESSAGING) {
                    return dialog;
                }
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000089, "queryActiveDialog: Impossible case! The active dialog is not open");
            }
            String[] params = new String[]{brandId, String.valueOf(DialogState.OPEN.ordinal()), String.valueOf(DialogState.PENDING.ordinal()), String.valueOf(MultiDialog.ChannelType.MESSAGING.ordinal())};
            String query = "target_id=? and state in (?, ?) and channel_type =? order by _id desc";
            Cursor cursor = this.getDB().query(null, query, params, null, null, null);
            ArrayList<Dialog> parsedDialogs = AmsDialogs.readDialogs(cursor);
            if (parsedDialogs.size() == 0) {
                LPLog.INSTANCE.d(TAG, "queryActiveDialog: Active dialog not found in DB");
                return null;
            }
            if (parsedDialogs.size() > 1) {
                LPLog.INSTANCE.w(TAG, "queryActiveDialog: More than 1 open dialogs found in DB");
            }
            this.mActiveDialog = parsedDialogs.get(0);
            return this.mActiveDialog;
        });
    }

    private void addDialog(String brandId, Dialog dialog) {
        if (this.getDialogById(brandId) == null && dialog == null) {
            return;
        }
        this.addDialogToMaps(dialog);
        AmsDialogs.sendUpdateStateIntent(dialog);
    }

    public void loadOpenDialogsForBrand(String targetId) {
        DataBaseExecutor.execute(() -> {
            Cursor cursor = this.getDB().query(null, "target_id=? and state in (?, ?) order by _id desc limit 1", new String[]{targetId, String.valueOf(DialogState.OPEN.ordinal()), String.valueOf(DialogState.PENDING.ordinal())}, null, null, null);
            ArrayList<Dialog> dialogs = AmsDialogs.readDialogs(cursor);
            for (Dialog dialog : dialogs) {
                LPLog.INSTANCE.d(TAG, "Setting current dialog for " + targetId + ". dialog id = " + dialog.getDialogId());
                this.addDialog(targetId, dialog);
            }
        });
    }

    private Dialog readDialog(Cursor cursor) {
        Dialog result = null;
        ArrayList<Dialog> dialogs = AmsDialogs.readDialogs(cursor);
        if (dialogs.size() == 1) {
            result = dialogs.get(0);
        }
        return result;
    }

    @NonNull
    private static ArrayList<Dialog> readDialogs(Cursor cursor) {
        ArrayList<Dialog> dialogs = new ArrayList<Dialog>();
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    do {
                        dialogs.add(new Dialog(cursor));
                    } while (cursor.moveToNext());
                }
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000008A, "Exception while reading Dialogs.", (Throwable)e);
            }
            finally {
                cursor.close();
            }
        }
        return dialogs;
    }

    public static HashMap<String, Dialog> extractDialogsToMap(ConversationData data) {
        ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(data);
        HashMap<String, Dialog> dialogHashMap = new HashMap<String, Dialog>(dialogs.size());
        for (Dialog dialog : dialogs) {
            dialogHashMap.put(dialog.getDialogId(), dialog);
        }
        return dialogHashMap;
    }

    public static ArrayList<Dialog> extractDialogs(ConversationData data) {
        ArrayList<Dialog> result = new ArrayList<Dialog>();
        if (data.dialogs == null || data.dialogs.length == 0) {
            Dialog dialog = new Dialog(data);
            result.add(dialog);
        } else {
            for (DialogData dialogData : data.dialogs) {
                result.add(new Dialog(dialogData, data));
            }
        }
        if (result.size() > 1) {
            LPLog.INSTANCE.v(TAG, "Before sort: " + result);
            Collections.sort(result, (dialog1, dialog2) -> -Long.compare(dialog1.getStartTimestamp(), dialog2.getStartTimestamp()));
            LPLog.INSTANCE.v(TAG, "After sort: " + result);
        }
        return result;
    }

    @Nullable
    public static Dialog getOpenDialog(ArrayList<Dialog> dialogs) {
        if (dialogs.size() == 0) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000008B, "getOpenDialog: Got an empty dialogs list");
            return null;
        }
        ArrayList filtered = CollectionsUtil.filter(dialogs, dialog -> dialog.isOpen() && dialog.getChannelType() == MultiDialog.ChannelType.MESSAGING);
        if (filtered.size() == 0) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000008C, "getOpenDialog: Missing open dialog in conversation");
            return null;
        }
        if (filtered.size() > 1) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000008D, "getOpenDialog: Too many simultaneous open dialogs found in conversation: ");
        }
        return (Dialog)filtered.get(0);
    }

    public void updateDialogs(ConversationData data) {
        ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(data);
        for (Dialog dialog : dialogs) {
            this.updateDialogDatabase(dialog, data);
        }
    }

    private void updateDialogDatabase(Dialog updatedDialog, ConversationData data) {
        Dialog dialog = this.getDialogById(updatedDialog.getDialogId());
        if (dialog == null) {
            return;
        }
        ContentValues dialogValues = new ContentValues();
        DialogState dialogState = updatedDialog.getState();
        if (dialog.getState() != dialogState) {
            dialog.setState(dialogState);
            dialogValues.put("state", Integer.valueOf(dialogState != null ? dialogState.ordinal() : -1));
        }
        if (dialog.getConversationTTRType() != updatedDialog.getConversationTTRType()) {
            dialog.setConversationTTRType(updatedDialog.getConversationTTRType());
            switch (updatedDialog.getConversationTTRType()) {
                case URGENT: {
                    this.mController.mEventsProxy.onConversationMarkedAsUrgent();
                    break;
                }
                case NORMAL: {
                    this.mController.mEventsProxy.onConversationMarkedAsNormal();
                }
            }
            dialogValues.put("ttr_type", Integer.valueOf(updatedDialog.getConversationTTRType().ordinal()));
        }
        if (dialog.getRequestId() != data.requestId) {
            dialog.setRequestId(data.requestId);
            dialogValues.put("request_id", Long.valueOf(data.requestId));
        }
        if (!TextUtils.equals((CharSequence)dialog.getConversationId(), (CharSequence)dialog.getConversationId())) {
            dialog.setConversationId(updatedDialog.getConversationId());
            dialogValues.put("conversation_id", updatedDialog.getConversationId());
        }
        String assignedAgentId = updatedDialog.getAssignedAgentId();
        if (!TextUtils.equals((CharSequence)dialog.getAssignedAgentId(), (CharSequence)assignedAgentId)) {
            dialog.setAssignedAgentId(assignedAgentId);
            dialogValues.put("assigned_agent_id", assignedAgentId);
        }
        if (dialog.getUnreadMessages() != updatedDialog.getUnreadMessages()) {
            dialog.setUnreadMessages(updatedDialog.getUnreadMessages());
            dialogValues.put("unread_msg_count", Integer.valueOf(updatedDialog.getUnreadMessages()));
            AmsDialogs.sendUpdateUnreadMsgIntent(dialog);
        }
        if (dialog.getStartTimestamp() != updatedDialog.getStartTimestamp()) {
            dialog.setStartTimestamp(updatedDialog.getStartTimestamp());
            dialogValues.put("start_timestamp", Long.valueOf(updatedDialog.getStartTimestamp()));
        }
        if (dialogValues.size() > 0) {
            String dialogId = dialog.getDialogId();
            dialogValues.put("dialog_id", dialogId);
            dialogValues.put("dialog_type", dialog.getDialogType().toString());
            DataBaseExecutor.execute(() -> {
                this.getDB().update(dialogValues, "dialog_id=?", new String[]{String.valueOf(dialogId)});
                AmsDialogs.sendUpdateStateIntent(dialog);
                LPLog.INSTANCE.d(TAG, FlowTags.DIALOGS, "Updated new dialog's data in DB. Dialog: " + dialogId);
            });
        }
    }

    public DataBaseCommand<Void> deleteDialogByBrandAndDialogId(String brandId, String dialogId) {
        return new DataBaseCommand(() -> {
            String whereClause = "brand_id = ? AND dialog_id = ?";
            String[] whereArgs = new String[]{brandId, dialogId};
            this.getDB().removeAll(whereClause, whereArgs);
            Dialog dialog = this.mDialogsByDialogId.remove(dialogId);
            LPLog.INSTANCE.d(TAG, "Finished removing dialog. Dialog: " + dialog);
            return null;
        });
    }

    public void createPendingDialog(String targetId, String brandId, long requestId) {
        this.createDialog(targetId, brandId, DialogState.PENDING, requestId);
    }

    public void createQueuedDialog(String targetId, String brandId, long requestId) {
        this.createDialog(targetId, brandId, DialogState.QUEUED, requestId);
    }

    private void createDialog(String targetId, String brandId, DialogState dialogState, long requestId) {
        Dialog dialog = new Dialog(targetId, brandId);
        dialog.setConversationId("TEMP_CONVERSATION");
        dialog.setDialogId("TEMP_DIALOG");
        dialog.setChannelType(MultiDialog.ChannelType.MESSAGING);
        dialog.setDialogType(DialogType.MAIN);
        dialog.setState(dialogState);
        dialog.setConversationTTRType(TTRType.NORMAL);
        dialog.setRequestId(requestId);
        this.addDialogToMaps(dialog);
        ContentValues dialogValues = new ContentValues();
        dialogValues.put("dialog_type", dialog.getDialogType().toString());
        DataBaseExecutor.execute(() -> {
            dialogValues.put("dialog_id", dialog.getDialogId());
            dialogValues.put("conversation_id", dialog.getConversationId());
            dialogValues.put("brand_id", dialog.getBrandId());
            dialogValues.put("target_id", dialog.getTargetId());
            dialogValues.put("state", Integer.valueOf(dialog.getState().ordinal()));
            dialogValues.put("ttr_type", Integer.valueOf(dialog.getConversationTTRType().ordinal()));
            dialogValues.put("assigned_agent_id", "");
            dialogValues.put("request_id", Long.valueOf(dialog.getRequestId()));
            dialogValues.put("last_server_sequence", Long.valueOf(0L));
            dialogValues.put("unread_msg_count", Integer.valueOf(-1));
            dialogValues.put("start_timestamp", Long.valueOf(System.currentTimeMillis()));
            this.getDB().insert(dialogValues);
            LPLog.INSTANCE.d(TAG, "create New Pending Dialog - temp ID = " + dialog.getDialogId());
            AmsDialogs.sendUpdateStateIntent(dialog);
        });
    }

    public void updateLastServerSequenceByDialogId(String dialogId, int serverSequence) {
        Dialog dialog = this.getDialogById(dialogId);
        if (dialog != null && dialog.getLastServerSequence() != serverSequence) {
            boolean updated = false;
            long lastServerSequence = dialog.getLastServerSequence();
            if (lastServerSequence + 1L == (long)serverSequence) {
                dialog.setLastServerSequence(serverSequence);
                LPLog.INSTANCE.d(TAG, "Got an expected sequence!! last sequence = " + lastServerSequence + " (1) , new current sequence : " + serverSequence);
                updated = true;
            } else {
                LPLog.INSTANCE.d(TAG, "Failed! Got an unexpected sequence!! last sequence = " + lastServerSequence + " (1),  new unexpected sequence : " + serverSequence);
                this.acceptedSequenceEvents.add(serverSequence);
            }
            updated = this.updateNextWaitingSequences(dialog, updated);
            if (updated) {
                LPLog.INSTANCE.d(TAG, "Running update last server sequence in db command. new last sequence = " + dialog.getLastServerSequence());
                this.updateSequenceInDb(dialog);
            }
        }
    }

    private boolean updateNextWaitingSequences(Dialog dialog, boolean updated) {
        int nextSequence = dialog.getLastServerSequence() + 1;
        HashSet<Integer> sequencesToRemove = new HashSet<Integer>();
        while (this.acceptedSequenceEvents.contains(nextSequence)) {
            LPLog.INSTANCE.d(TAG, "Waited sequence " + nextSequence + " this is the new last server sequence!");
            sequencesToRemove.add(nextSequence);
            dialog.setLastServerSequence(nextSequence);
            ++nextSequence;
            updated = true;
        }
        if (!sequencesToRemove.isEmpty()) {
            this.acceptedSequenceEvents.removeAll(sequencesToRemove);
        }
        return updated;
    }

    private void removeOldWaitingSequences(int serverSequence) {
        HashSet<Integer> sequencesToRemove = new HashSet<Integer>();
        for (Integer sequence : this.acceptedSequenceEvents) {
            if (sequence > serverSequence) continue;
            LPLog.INSTANCE.d(TAG, "Waited sequence " + sequence + " deleted after query messages!");
            sequencesToRemove.add(sequence);
        }
        if (!sequencesToRemove.isEmpty()) {
            this.acceptedSequenceEvents.removeAll(sequencesToRemove);
        }
    }

    public void updateSequenceForCobrowseDialog(Dialog dialog, int serverSequence) {
        if (dialog == null || dialog.getChannelType() != MultiDialog.ChannelType.COBROWSE) {
            return;
        }
        this.updateSequenceInDb(dialog, serverSequence);
    }

    private void updateSequenceInDb(Dialog dialog) {
        this.updateSequenceInDb(dialog, dialog.getLastServerSequence());
    }

    private void updateSequenceInDb(Dialog dialog, int serverSequence) {
        DataBaseExecutor.execute(() -> {
            ContentValues dialogValues = new ContentValues();
            dialogValues.put("last_server_sequence", Integer.valueOf(serverSequence));
            String whereClause = "dialog_id=?";
            String[] whereArgs = new String[]{dialog.getDialogId()};
            int updatedRows = this.getDB().update(dialogValues, "dialog_id=?", whereArgs);
            LPLog.INSTANCE.d(TAG, "update sequence in db " + serverSequence + " for " + dialog.getDialogId() + " without gap. updated rows = " + updatedRows);
            dialog.setLastServerSequence(serverSequence);
            AmsDialogs.sendUpdateStateIntent(dialog);
        });
    }

    private DataBaseCommand<Boolean> updateLastServerSequenceByDialogId(String dialogId, int serverSequence, int sequenceGap, boolean updateUI) {
        Dialog dialog = this.getDialogById(dialogId);
        if (dialog != null) {
            long lastServerSequence = dialog.getLastServerSequence();
            if (lastServerSequence + (long)sequenceGap == (long)serverSequence) {
                dialog.setLastServerSequence(serverSequence);
                LPLog.INSTANCE.d(TAG, "Got an expected sequence!! last sequence = " + lastServerSequence + " gap = " + sequenceGap + ", new current sequence : " + serverSequence);
                this.removeOldWaitingSequences(serverSequence);
            } else {
                LPLog.INSTANCE.d(TAG, "Failed! Got an unexpected sequence!! last sequence = " + lastServerSequence + " gap = " + sequenceGap + ", new unexpected sequence : " + serverSequence);
                return null;
            }
        }
        return this.getUpdateSequenceInDb(dialogId, serverSequence, sequenceGap, updateUI, dialog);
    }

    @NonNull
    private DataBaseCommand<Boolean> getUpdateSequenceInDb(String dialogId, int serverSequence, int sequenceGap, boolean updateUI, Dialog dialog) {
        return new DataBaseCommand(() -> {
            ContentValues dialogValues = new ContentValues();
            dialogValues.put("last_server_sequence", Integer.valueOf(serverSequence));
            String whereClause = "dialog_id=? and last_server_sequence+" + sequenceGap + " = " + serverSequence;
            Object[] whereArgs = new String[]{dialogId};
            int updatedRows = this.getDB().update(dialogValues, whereClause, (String[])whereArgs);
            LPLog.INSTANCE.d(TAG, "update sequence " + serverSequence + " for " + dialogId + ". gap = " + sequenceGap + ". updated rows = " + updatedRows);
            if (dialog != null && updateUI) {
                AmsDialogs.sendUpdateStateIntent(dialog);
            }
            if (updatedRows > 0) {
                return true;
            }
            Cursor c = this.getDB().rawQuery("select last_server_sequence from dialogs where dialog_id =?", whereArgs);
            if (c.moveToFirst()) {
                int lastServerSequenceInDb = c.getInt(c.getColumnIndex("last_server_sequence"));
                LPLog.INSTANCE.d(TAG, "No rows updated! last sequence stored in db : " + lastServerSequenceInDb);
            }
            c.close();
            return false;
        });
    }

    public DataBaseCommand<Dialog> updateCurrentDialogServerId(ConversationData data) {
        Dialog dialog;
        if (this.mController.getOfflineManager().isOfflineModeEnabled()) {
            Dialog offlineDialog = this.getDialogById("OFFLINE_DIALOG");
            Dialog tempDialog = this.getDialogById("TEMP_DIALOG");
            if (offlineDialog == null) {
                dialog = tempDialog;
            } else {
                dialog = offlineDialog;
                if (tempDialog != null) {
                    ArrayList<SendMessageRequest> pendingRequests = tempDialog.getPendingData().getPendingMessages();
                    dialog.getPendingData().addToPendingRequests(pendingRequests);
                    tempDialog.getPendingData().clearPendingRequests();
                }
            }
        } else {
            dialog = this.getDialogById("TEMP_DIALOG");
        }
        if (dialog == null) {
            return null;
        }
        this.removeDialogFromCache(data.targetId, "OFFLINE_DIALOG");
        this.removeTempDialog(data.targetId);
        dialog.setState(DialogState.parse(data.state));
        dialog.setStartTimestamp(data.startTs);
        dialog.setDialogId(DialogData.extractDialogId(data));
        dialog.setConversationId(data.conversationId);
        dialog.setConversationTTRType(data.conversationTTRType);
        dialog.setRequestId(data.requestId);
        dialog.setAssignedAgentId(data.getAssignedAgentId());
        this.addDialogToMaps(dialog);
        return new DataBaseCommand(() -> {
            this.getDB().insert(AmsDialogs.getContentValues(dialog));
            AmsDialogs.sendUpdateStateIntent(dialog);
            LPLog.INSTANCE.d(TAG, "Finished updating dialog with server id");
            return dialog;
        });
    }

    public DataBaseCommand<Dialog> updateClosedDialog(ConversationData conversationData, boolean shouldUpdateUI) {
        ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(conversationData);
        Dialog dialog = dialogs.get(0);
        return this.updateClosedDialog(conversationData, dialog, shouldUpdateUI);
    }

    public DataBaseCommand<Dialog> updateClosedDialog(ConversationData conversationData, Dialog dialog, boolean shouldUpdateUI) {
        LPLog.INSTANCE.d(TAG, FlowTags.DIALOGS, "updateClosedDialog: Closing dialog: " + dialog.getDialogId());
        dialog.setState(DialogState.CLOSE);
        String brandId = dialog.getTargetId();
        shouldUpdateUI = this.shouldNotifyUIDialogClosed(dialog.getCloseReason(), brandId, dialog.getEndTimestamp(), shouldUpdateUI);
        CSAT.CSAT_SHOW_STATUS csatShowStatus = AmsConversations.calculateShowedCsat(conversationData, shouldUpdateUI);
        Dialog dialogToClose = this.mDialogsByDialogId.get(dialog.getDialogId());
        if (dialogToClose != null) {
            if (dialogToClose.getState() != DialogState.CLOSE) {
                LPLog.INSTANCE.d(TAG, FlowTags.DIALOGS, "Closing dialog " + dialogToClose.getDialogId() + ", close reason:" + (Object)((Object)dialog.getCloseReason()) + ", close ts:" + dialog.getEndTimestamp());
                dialogToClose.getTTRManager().cancelAll();
                dialogToClose.setCloseReason(dialog.getCloseReason());
                dialogToClose.setEndTimestamp(dialog.getEndTimestamp());
                dialogToClose.setAssignedAgentId(dialog.getAssignedAgentId());
                dialogToClose.setState(DialogState.CLOSE);
            }
            dialogToClose.setShowedCSAT(csatShowStatus);
        }
        if (this.mActiveDialog != null && this.mActiveDialog.getDialogId().equals(dialog.getDialogId())) {
            LPLog.INSTANCE.d(TAG, FlowTags.DIALOGS, "updateClosedDialog: Cleaning active dialog: " + this.mActiveDialog.getDialogId());
            this.mActiveDialog = null;
        }
        boolean finalUpdateUI = shouldUpdateUI;
        return new DataBaseCommand(() -> {
            Cursor cursor = this.getDB().query(null, "dialog_id=?", new String[]{dialog.getDialogId()}, null, null, null);
            Dialog result = this.readDialog(cursor);
            if (result == null) {
                LPLog.INSTANCE.i(TAG, "Old dialog " + dialog.getDialogId() + " does not exist in DB. creating new one closed conversation, close reason:" + (Object)((Object)dialog.getCloseReason()) + ", close ts:" + dialog.getEndTimestamp());
                this.getDB().insert(AmsDialogs.getContentValues(dialog));
            } else if (result.getState() != DialogState.CLOSE) {
                LPLog.INSTANCE.d(TAG, "Closing current dialog.. ");
                result.setState(DialogState.CLOSE);
                result.setCloseReason(dialog.getCloseReason());
                result.setEndTimestamp(dialog.getEndTimestamp());
                result.setAssignedAgentId(dialog.getAssignedAgentId());
                result.setShowedCSAT(csatShowStatus);
                this.getDB().update(AmsDialogs.getContentValues(dialog), "dialog_id=?", new String[]{String.valueOf(dialog.getDialogId())});
                if (finalUpdateUI) {
                    AmsDialogs.sendUpdateCSATDialogIntent(dialog);
                }
                AmsConnection connection = this.mController.mConnectionController.getConnection(dialog.getBrandId());
                OfflineMessagingManager manager = this.mController.getOfflineManager();
                if (connection != null && connection.isUpdated() && result.getDialogType() == DialogType.POST_SURVEY && manager != null && manager.shouldCreateConversationAfterPCS()) {
                    manager.createNewConversationIfNeeded();
                }
                AmsDialogs.sendDialogClosedIntent(dialog, dialog.getAssignedAgentId());
            } else {
                if (dialog.isShowedCSAT() != csatShowStatus) {
                    dialog.setShowedCSAT(csatShowStatus);
                    this.getDB().update(AmsDialogs.getContentValues(dialog), "dialog_id=?", new String[]{String.valueOf(dialog.getDialogId())});
                }
                if (finalUpdateUI) {
                    AmsDialogs.sendUpdateCSATDialogIntent(dialog);
                }
                AmsDialogs.sendDialogClosedIntent(dialog, dialog.getAssignedAgentId());
                return null;
            }
            return dialog;
        });
    }

    private boolean shouldNotifyUIDialogClosed(CloseReason closeReason, String brandId, long closeTS, boolean updateUI) {
        if (updateUI) {
            if (Dialog.isAutoClose(closeReason)) {
                LPLog.INSTANCE.d(TAG, "Updating closed dialog. Close Reason = System. do not update UI.");
                updateUI = false;
            } else {
                updateUI = this.checkExpiry(brandId, closeTS, updateUI);
            }
        }
        return updateUI;
    }

    private boolean checkExpiry(String brandId, long closeTimestamp, boolean updateUI) {
        int expirationInMinutes = Configuration.getInteger((int)R.integer.csatSurveyExpirationInMinutes);
        if (expirationInMinutes != 0) {
            long expirationInMillis;
            long endTime;
            long clockDiff = this.mController.mConnectionController.getClockDiff(brandId);
            long now = System.currentTimeMillis();
            if (now - (endTime = clockDiff + closeTimestamp) > (expirationInMillis = TimeUnit.MINUTES.toMillis(expirationInMinutes))) {
                LPLog.INSTANCE.d(TAG, "Closing dialog - time expired for CSAT. endTime = " + endTime + " expirationInMinutes = " + expirationInMinutes);
                updateUI = false;
            }
        }
        return updateUI;
    }

    private static void sendUpdateStateIntent(Dialog dialog) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        extras.putString(KEY_DIALOG_ID, dialog.getDialogId());
        extras.putInt(KEY_DIALOG_STATE, dialog.getState().ordinal());
        extras.putString(KEY_DIALOG_ASSIGNED_AGENT, dialog.getAssignedAgentId());
        LPLog.INSTANCE.d(TAG, "Sending dialog update with : " + extras);
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_DIALOG", (Bundle)extras);
    }

    private static void sendDialogClosedIntent(Dialog dialog, String assignedAgentId) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        extras.putString(KEY_DIALOG_ID, dialog.getDialogId());
        extras.putString(KEY_DIALOG_ASSIGNED_AGENT, assignedAgentId);
        LPLog.INSTANCE.d(TAG, "Sending dialog autoClosed update with : " + extras);
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_DIALOG_CLOSED", (Bundle)extras);
    }

    private static void sendUpdateCSATDialogIntent(Dialog dialog) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        extras.putString(KEY_DIALOG_ID, dialog.getDialogId());
        extras.putInt(KEY_DIALOG_STATE, dialog.getState().ordinal());
        extras.putString(KEY_DIALOG_ASSIGNED_AGENT, dialog.getAssignedAgentId());
        extras.putInt(KEY_DIALOG_SHOWED_CSAT, dialog.isShowedCSAT().getValue());
        LPLog.INSTANCE.d(TAG, "Sending dialog CSAT update with : " + extras);
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_CSAT_DIALOG", (Bundle)extras);
    }

    private static void sendUpdateNewDialogIntent(Dialog dialog) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        extras.putString(KEY_DIALOG_ID, dialog.getDialogId());
        LPLog.INSTANCE.d(TAG, "Sending dialog update with : " + extras);
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_NEW_DIALOG_MSG", (Bundle)extras);
    }

    private static void sendUpdateUnreadMsgIntent(Dialog dialog) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        LPLog.INSTANCE.d(TAG, "Sending dialog update with : " + extras);
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_DIALOG_UNREAD_MSG", (Bundle)extras);
    }

    private static ContentValues getContentValues(Dialog dialog) {
        ContentValues dialogValues = new ContentValues();
        dialogValues.put("conversation_id", dialog.getConversationId());
        dialogValues.put("dialog_id", dialog.getDialogId());
        dialogValues.put("dialog_type", dialog.getDialogType().toString());
        dialogValues.put("channel_type", dialog.getChannelType().toString());
        dialogValues.put("brand_id", dialog.getBrandId());
        dialogValues.put("target_id", dialog.getTargetId());
        dialogValues.put("state", Integer.valueOf(dialog.getState() != null ? dialog.getState().ordinal() : -1));
        dialogValues.put("ttr_type", Integer.valueOf(dialog.getConversationTTRType() != null ? dialog.getConversationTTRType().ordinal() : -1));
        dialogValues.put("assigned_agent_id", dialog.getAssignedAgentId());
        dialogValues.put("request_id", Long.valueOf(dialog.getRequestId()));
        dialogValues.put("close_reason", Integer.valueOf(dialog.getCloseReason() != null ? dialog.getCloseReason().ordinal() : -1));
        dialogValues.put("start_timestamp", Long.valueOf(dialog.getStartTimestamp()));
        dialogValues.put("end_timestamp", Long.valueOf(dialog.getEndTimestamp()));
        dialogValues.put("last_server_sequence", Integer.valueOf(dialog.getLastServerSequence()));
        dialogValues.put("csat_status", Integer.valueOf(dialog.isShowedCSAT().getValue()));
        dialogValues.put("unread_msg_count", Integer.valueOf(dialog.getUnreadMessages()));
        return dialogValues;
    }

    public void resetEffectiveTTR(String targetId) {
        Dialog dialog = this.getDialogById(targetId);
        if (dialog != null) {
            dialog.getTTRManager().resetEffectiveTTR();
        }
    }

    public DataBaseCommand<Dialog> queryDialogById(String dialogId) {
        return new DataBaseCommand(() -> {
            Cursor c = this.getDB().rawQuery("select * from dialogs where dialog_id = ?", new Object[]{dialogId});
            Dialog dialog = null;
            if (c != null) {
                dialog = this.readDialog(c);
            }
            return dialog;
        });
    }

    private void addDialogToMaps(Dialog dialog) {
        if (!dialog.isClosed()) {
            this.setActiveDialog(dialog);
        }
        this.cacheDialog(dialog);
        LPLog.INSTANCE.d(TAG, "Putting dialog in dialogs ,ap. Dialog ID: " + dialog.getDialogId() + " targetId: " + dialog.getTargetId());
    }

    private void removeTempDialog(String targetId) {
        LPLog.INSTANCE.d(TAG, "Removing temp dialog Id: TEMP_DIALOG target Id: " + targetId);
        Dialog dialog = this.mActiveDialog;
        if (dialog != null && dialog.getDialogId().equals("TEMP_DIALOG")) {
            LPLog.INSTANCE.d(TAG, FlowTags.DIALOGS, "removeDialog: Cleaning active dialog: " + this.mActiveDialog.getDialogId());
            this.mActiveDialog = null;
        }
        this.removeDialogFromCache(targetId, "TEMP_DIALOG");
    }

    private void removeAllDialogsFromMaps(String targetId) {
        if (this.mActiveDialog != null && this.mActiveDialog.isOpenOrPending()) {
            LPLog.INSTANCE.w(TAG, "removeAllDialogsFromMaps: current dialog from brand " + targetId + " is active. Did not remove");
            return;
        }
        this.mDialogsByDialogId.clear();
        this.mActiveDialog = null;
        LPLog.INSTANCE.d(TAG, "removeAllDialogsFromMaps: Removing all dialogs");
    }

    public DataBaseCommand<Integer> clearClosedDialogs(final String targetId) {
        this.removeAllDialogsFromMaps(targetId);
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){
            String whereString = "target_id=? and state=?";
            String[] whereArgs = new String[]{targetId, String.valueOf(DialogState.CLOSE.ordinal())};

            public Integer query() {
                return AmsDialogs.this.getDB().removeAll(this.whereString, this.whereArgs);
            }
        });
    }

    public DataBaseCommand<Integer> clearAllDialogs(final String targetId) {
        this.removeAllDialogsFromMaps(targetId);
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){
            String whereString = "target_id=?";
            String[] whereArgs = new String[]{targetId};

            public Integer query() {
                return AmsDialogs.this.getDB().removeAll(this.whereString, this.whereArgs);
            }
        });
    }

    @Override
    @Nullable
    public Dialog getActiveDialog() {
        Dialog dialog = this.mActiveDialog;
        if (dialog != null && dialog.isClosed()) {
            dialog = null;
        }
        return dialog;
    }

    @Override
    @Nullable
    public Dialog getDialogById(String dialogId) {
        return this.mDialogsByDialogId.get(dialogId);
    }

    public void getDialogByIdAsync(String dialogId, ICallback<Dialog, Exception> callback) {
        Dialog dialog = this.mDialogsByDialogId.get(dialogId);
        if (dialog != null) {
            callback.onSuccess((Object)dialog);
        } else {
            this.queryDialogById(dialogId).setPostQueryOnBackground(dialog1 -> {
                if (dialog1 != null) {
                    callback.onSuccess(dialog1);
                } else {
                    callback.onError((Throwable)new Exception("Dialog not found"));
                }
            }).execute();
        }
    }

    public ArrayList<Dialog> getDialogsByConversationId(String conversationId) {
        ArrayList<Dialog> dialogs = new ArrayList<Dialog>();
        if (conversationId == null) {
            return dialogs;
        }
        for (Map.Entry<String, Dialog> dialogEntry : this.mDialogsByDialogId.entrySet()) {
            Dialog dialogEntryValue = dialogEntry.getValue();
            String dialogEntryConversationId = dialogEntryValue.getConversationId();
            if (!conversationId.equals(dialogEntryConversationId)) continue;
            dialogs.add(dialogEntryValue);
        }
        return dialogs;
    }

    public DataBaseCommand<Dialog> fetchPreviousDialog(String targetId) {
        return new DataBaseCommand(() -> {
            Dialog dialog;
            block9: {
                Dialog dialog2 = null;
                Cursor c = this.getNextDialogToFetch(targetId);
                try {
                    if (c != null && c.moveToFirst()) {
                        dialog2 = this.readDialog(c);
                        this.cacheDialog(dialog2);
                        FetchConversationManager conversationManager = new FetchConversationManager(this.mController);
                        Conversation conversation = (Conversation)this.mController.amsConversations.queryConversationById(dialog2.getConversationId()).executeSynchronously();
                        ArrayList dialogs = (ArrayList)this.mController.amsDialogs.queryDialogsByConversationId(conversation.getConversationId()).executeSynchronously();
                        conversationManager.fetchConversation(conversation, dialogs);
                    }
                    dialog = dialog2;
                    if (c == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (c != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                c.close();
            }
            return dialog;
        });
    }

    public void clearFetchConversationRequestDialogs() {
        FetchConversationManager.clearDialogRequestStatusMap();
    }

    @Override
    public void cacheDialog(Dialog dialog) {
        this.mDialogsByDialogId.put(dialog.getDialogId(), dialog);
    }

    @Override
    public void removeDialogFromCache(String targetId, String dialogId) {
        Dialog dialog = this.mDialogsByDialogId.get(dialogId);
        if (dialog != null && dialog.getTargetId().equals(targetId)) {
            this.mDialogsByDialogId.remove(dialogId);
            LPLog.INSTANCE.d(TAG, "Removed dialog from cache: " + dialogId);
        } else {
            LPLog.INSTANCE.d(TAG, "Dialog not found in cache: " + dialogId);
        }
    }

    private Cursor getNextDialogToFetch(String targetId) {
        String sql = "SELECT * FROM dialogs WHERE target_id = ? AND last_server_sequence = -1 AND dialog_id != ? ORDER BY start_timestamp DESC limit 1";
        return this.getDB().rawQuery(sql, new Object[]{targetId, "OFFLINE_DIALOG"});
    }

    public void addUpdateRequestInProgress(String dialogId) {
        Dialog dialog = this.getDialogById(dialogId);
        if (dialog != null) {
            int mUpdateInProgress = dialog.getUpdateInProgress() + 1;
            LPLog.INSTANCE.d(TAG, "adding update request in progress for dialog: " + dialogId + ", requests in progress: " + mUpdateInProgress);
            dialog.setUpdateInProgress(mUpdateInProgress);
        }
        this.updateRequestsInProgress(dialogId, 1);
    }

    public void removeUpdateRequestInProgress(String dialogId) {
        Dialog dialog = this.getDialogById(dialogId);
        if (dialog != null) {
            int mUpdateInProgress = dialog.getUpdateInProgress() - 1;
            LPLog.INSTANCE.d(TAG, "removing update request for dialog ID: " + dialogId + ", requests in progress: " + mUpdateInProgress);
            dialog.setUpdateInProgress(mUpdateInProgress);
        }
        this.updateRequestsInProgress(dialogId, -1);
    }

    private void updateRequestsInProgress(String dialogId, int addValue) {
        DataBaseExecutor.execute(() -> {
            try (Cursor c = this.getDB().query(new String[]{"concurrent_requests_counter"}, "dialog_id = ? ", new String[]{dialogId}, null, null, null);){
                int updateInProgress = 0;
                if (c != null && c.moveToFirst()) {
                    updateInProgress = c.getInt(c.getColumnIndex("concurrent_requests_counter"));
                }
                LPLog.INSTANCE.d(TAG, "update request for dialog in DB: " + dialogId + ", requests in progress: " + updateInProgress + " added value = " + addValue);
                ContentValues dialogValues = new ContentValues();
                dialogValues.put("concurrent_requests_counter", Integer.valueOf(updateInProgress + addValue));
                this.getDB().update(dialogValues, "conversation_id=?", new String[]{String.valueOf(dialogId)});
            }
        });
    }

    public void updateDialogState(String dialogId, DialogState state) {
        Dialog dialog = this.getActiveDialog();
        if (dialog != null) {
            LPLog.INSTANCE.d(TAG, "update dialog state, new state = " + (Object)((Object)state));
            dialog.setState(state);
        }
        DataBaseExecutor.execute(() -> {
            LPLog.INSTANCE.d(TAG, "update new state for dialog in DB: " + dialogId + ", state: " + (Object)((Object)state));
            ContentValues dialogValues = new ContentValues();
            dialogValues.put("state", Integer.valueOf(state.ordinal()));
            this.getDB().update(dialogValues, "dialog_id=?", new String[]{String.valueOf(dialogId)});
        });
    }

    public void clear() {
        for (Dialog dialog : this.mDialogsByDialogId.values()) {
            dialog.getTTRManager().clear();
        }
        this.acceptedSequenceEvents.clear();
        this.mDialogsByDialogId.clear();
        this.mActiveDialog = null;
    }

    public void shutDown() {
        for (Dialog dialog : this.mDialogsByDialogId.values()) {
            dialog.getTTRManager().shutDown();
        }
    }

    public void createNewCurrentDialog(Dialog dialog) {
        DataBaseExecutor.execute(() -> {
            this.getDB().insert(AmsDialogs.getContentValues(dialog));
            LPLog.INSTANCE.i(TAG, "Created new current dialog with ID: " + dialog.getDialogId());
            AmsDialogs.sendUpdateStateIntent(dialog);
            AmsDialogs.sendUpdateNewDialogIntent(dialog);
        });
    }

    public void createDummyDialogForWelcomeMessage(String brandId, String dummyConversationId, String dummyDialogId, long lastMessageSequence, long startTime) {
        DataBaseExecutor.execute(() -> {
            ContentValues dialogValues = new ContentValues();
            dialogValues.put("brand_id", brandId);
            dialogValues.put("target_id", brandId);
            dialogValues.put("dialog_id", dummyDialogId);
            dialogValues.put("conversation_id", dummyConversationId);
            dialogValues.put("state", Integer.valueOf(DialogState.LOCKED.ordinal()));
            dialogValues.put("ttr_type", Integer.valueOf(TTRType.NORMAL.ordinal()));
            dialogValues.put("assigned_agent_id", "");
            dialogValues.put("request_id", Integer.valueOf(-1));
            dialogValues.put("last_server_sequence", Long.valueOf(lastMessageSequence));
            dialogValues.put("unread_msg_count", Integer.valueOf(-1));
            dialogValues.put("start_timestamp", Long.valueOf(startTime));
            this.getDB().insert(dialogValues);
            LPLog.INSTANCE.d(TAG, "created dummy dialog for first message- startTime = " + startTime);
        });
    }

    public DataBaseCommand<ArrayList<Dialog>> queryOpenDialogsOfConversation(String conversationId) {
        return new DataBaseCommand(() -> {
            Cursor cursor = this.getDB().query(null, "conversation_id=? and state in (?, ?) order by _id desc", new String[]{conversationId, String.valueOf(DialogState.OPEN.ordinal()), String.valueOf(DialogState.PENDING.ordinal())}, null, null, null);
            return AmsDialogs.readDialogs(cursor);
        });
    }

    public DataBaseCommand<ArrayList<Dialog>> queryDialogsByConversationId(String conversationId) {
        return new DataBaseCommand(() -> {
            Cursor c = this.getDB().rawQuery("select * from dialogs where conversation_id = ?", new Object[]{conversationId});
            ArrayList dialogs = null;
            if (c != null) {
                dialogs = AmsDialogs.readDialogs(c);
            }
            return dialogs != null ? dialogs : new ArrayList();
        });
    }

    public DataBaseCommand<Boolean> hasWelcomeMessageDialog() {
        return new DataBaseCommand(() -> {
            try (Cursor cursor = this.getDB().rawQuery("select * from dialogs where dialog_id = ?", new Object[]{KEY_WELCOME_DIALOG_ID});){
                if (cursor != null && cursor.moveToFirst()) {
                    Boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
    }

    public void setActiveDialog(Dialog activeDialog) {
        if (activeDialog == null) {
            return;
        }
        if (activeDialog.getChannelType().equals((Object)MultiDialog.ChannelType.COBROWSE)) {
            return;
        }
        if (this.mActiveDialog != null && !this.mActiveDialog.getDialogId().equals(activeDialog.getDialogId())) {
            LPLog.INSTANCE.d(TAG, FlowTags.DIALOGS, "Setting a new active dialog: " + activeDialog.getDialogId());
        }
        this.mDialogsByDialogId.put(activeDialog.getDialogId(), activeDialog);
        this.mActiveDialog = activeDialog;
    }

    public void setActiveCoBrowseDialogId(String dialogId) {
        this.activeCoBrowseDialogId = dialogId;
    }

    public String getActiveCoBrowseDialogId() {
        return this.activeCoBrowseDialogId;
    }

    public void closeActiveDialog() {
        Dialog activeDialog;
        if (this.mActiveDialog != null && (activeDialog = this.mDialogsByDialogId.get(this.mActiveDialog.getDialogId())) != null) {
            activeDialog.setState(DialogState.CLOSE);
        }
        this.mActiveDialog = null;
    }

    public void markPendingDialogsAsFailed(String brandId) {
        Dialog dialog = this.mActiveDialog;
        if (dialog != null && (dialog.getState() == DialogState.PENDING || dialog.getState() == DialogState.QUEUED)) {
            dialog.setState(DialogState.CLOSE);
            dialog.setEndTimestamp(ClockUtils.getSyncedTimestamp());
        }
        DataBaseExecutor.execute(() -> {
            String where = "state =? AND brand_id = ?";
            ContentValues contentValues = new ContentValues();
            contentValues.put("state", Integer.valueOf(DialogState.CLOSE.ordinal()));
            int result = this.getDB().update(contentValues, where, new String[]{String.valueOf(DialogState.PENDING.ordinal()), brandId});
            LPLog.INSTANCE.d(TAG, String.format(Locale.ENGLISH, "Updated %d pending dialog as Closed on DB", result));
        });
    }

    public boolean areMoreMessagesAvailableToFetch(String targetId) {
        boolean shouldFetch = false;
        ConversationViewParams conversationViewParams = this.mController.getConversationViewParams();
        if (conversationViewParams.getHistoryConversationsStateToDisplay() == LPConversationsHistoryStateToDisplay.OPEN) {
            return shouldFetch;
        }
        Cursor c = this.getNextDialogToFetch(targetId);
        if (c != null) {
            if (c.getCount() == 1 && c.moveToFirst()) {
                Dialog dialog = this.readDialog(c);
                if (dialog.getDialogId().equals("TEMP_DIALOG")) {
                    return false;
                }
                shouldFetch = true;
                if (conversationViewParams.isFilterOn()) {
                    long historyConversationsMaxDays = (long)conversationViewParams.getHistoryConversationsMaxDays() * 86400000L;
                    switch (conversationViewParams.getHistoryConversationMaxDaysType()) {
                        case endConversationDate: {
                            if (dialog.getEndTimestamp() < System.currentTimeMillis() - historyConversationsMaxDays) {
                                shouldFetch = false;
                            }
                        }
                        case startConversationDate: {
                            if (dialog.getStartTimestamp() >= System.currentTimeMillis() - historyConversationsMaxDays) break;
                            shouldFetch = false;
                        }
                    }
                }
            } else {
                c.close();
            }
        }
        return shouldFetch;
    }

    public void saveMessagesResult(@Nullable String dialogId, @NonNull ArrayList<ContentEventNotification> messagesResult, boolean firstNotification, boolean shouldUpdateUI, @NonNull ICallback<Dialog, Exception> callback) {
        Dialog currentDialog = this.getDialogById(dialogId);
        if (currentDialog == null) {
            Dialog dialog = (Dialog)this.queryDialogById(dialogId).executeSynchronously();
            if (dialog != null) {
                this.saveMessages(dialog, messagesResult, firstNotification, shouldUpdateUI, callback);
            }
        } else {
            this.saveMessages(currentDialog, messagesResult, firstNotification, shouldUpdateUI, callback);
        }
    }

    private void saveMessages(Dialog dialog, ArrayList<ContentEventNotification> messagesResult, boolean firstNotification, boolean shouldUpdateUI, ICallback<Dialog, Exception> callback) {
        if (messagesResult.size() == 0) {
            LPLog.INSTANCE.d(TAG, "No messages in query response.");
            int lastServerSequence = dialog.getLastServerSequence() == -1 ? 0 : dialog.getLastServerSequence();
            DataBaseCommand<Boolean> command = this.updateLastServerSequenceByDialogId(dialog.getDialogId(), lastServerSequence, 1, shouldUpdateUI);
            if (command != null) {
                command.execute();
            }
            callback.onError((Throwable)new Exception("Empty results - no messages"));
            return;
        }
        int lastContentSequence = -1;
        for (int i = messagesResult.size() - 1; i >= 0; --i) {
            if (messagesResult.get((int)i).sequence <= -1) continue;
            lastContentSequence = messagesResult.get((int)i).sequence;
            break;
        }
        LPLog.INSTANCE.d(TAG, dialog.getDialogId() + " - Last sequence event received in query messages response: " + lastContentSequence);
        if (lastContentSequence == -1 || lastContentSequence < dialog.getLastServerSequence()) {
            LPLog.INSTANCE.d(TAG, dialog.getDialogId() + " - didn't receive any new sequence " + lastContentSequence);
            if (dialog.isClosed()) {
                this.mController.amsMessages.updateMultipleMessages(messagesResult, dialog.getDialogId()).setPostQueryOnBackground(data -> {
                    LPLog.INSTANCE.d(TAG, "Finished updating " + messagesResult.size() + " messages for dialog id " + dialog.getDialogId());
                    callback.onSuccess((Object)dialog);
                }).execute();
            } else {
                callback.onSuccess((Object)dialog);
            }
            return;
        }
        DataBaseCommand<Boolean> command = this.updateLastServerSequenceByDialogId(dialog.getDialogId(), lastContentSequence, lastContentSequence - dialog.getLastServerSequence(), shouldUpdateUI);
        if (command != null) {
            command.executeSynchronously();
        }
        String originatorId = this.mController.getOriginatorId(dialog.getTargetId());
        long clockDiff = this.mController.mConnectionController.getClockDiff(dialog.getBrandId());
        this.mController.amsMessages.addMultipleMessages(messagesResult, dialog, originatorId, dialog.getBrandId(), dialog.getTargetId(), dialog.getDialogId(), dialog.getConversationId(), clockDiff, firstNotification, shouldUpdateUI).execute();
        callback.onSuccess((Object)dialog);
    }

    public static boolean isUmsSupportingDialogs() {
        return UmsCompatibilityManager.isSupportingDialogs();
    }

    public static void setIsUmsSupportingDialogs(boolean isSupportingDialogs) {
        UmsCompatibilityManager.setIsSupportingDialogs(isSupportingDialogs);
    }

    public OfflineDialogRepository getOfflineDialogRepository() {
        return this.mOfflineDialogRepository;
    }

    public class BROADCASTS {
        public static final String UPDATE_DIALOG = "BROADCAST_UPDATE_DIALOG";
        public static final String UPDATE_CSAT_DIALOG = "BROADCAST_UPDATE_CSAT_DIALOG";
        public static final String UPDATE_DIALOG_CLOSED = "BROADCAST_UPDATE_DIALOG_CLOSED";
        public static final String UPDATE_NEW_DIALOG_MSG = "BROADCAST_UPDATE_NEW_DIALOG_MSG";
        public static final String UPDATE_UNREAD_MSG = "BROADCAST_UPDATE_DIALOG_UNREAD_MSG";
    }

    private static class UmsCompatibilityManager {
        private static Boolean _isSupportingDialogs;

        private UmsCompatibilityManager() {
        }

        private static boolean isSupportingDialogs() {
            if (_isSupportingDialogs == null) {
                _isSupportingDialogs = Infra.instance.getApplicationContext().getSharedPreferences("LP_COMPATIBILITY", 0).getBoolean("IS_SUPPORTING_DIALOGS", false);
                if (_isSupportingDialogs.booleanValue()) {
                    LPLog.INSTANCE.d(AmsDialogs.TAG, FlowTags.DIALOGS, "Communicating with a new UMS, multi-dialog is supported!");
                } else {
                    LPLog.INSTANCE.d(AmsDialogs.TAG, FlowTags.DIALOGS, "Communicating with a legacy UMS, multi-dialog is not supported!");
                }
            }
            return _isSupportingDialogs;
        }

        private static void setIsSupportingDialogs(Boolean isSupportingDialogs) {
            if (UmsCompatibilityManager.isSupportingDialogs() == isSupportingDialogs) {
                return;
            }
            if (isSupportingDialogs.booleanValue()) {
                LPLog.INSTANCE.d(AmsDialogs.TAG, FlowTags.DIALOGS, "Communicating with UMS that has multi-dialog support!");
            } else {
                LPLog.INSTANCE.d(AmsDialogs.TAG, FlowTags.DIALOGS, "Communicating with UMS that HAS NO multi-dialog support!");
            }
            _isSupportingDialogs = isSupportingDialogs;
            Infra.instance.getApplicationContext().getSharedPreferences("LP_COMPATIBILITY", 0).edit().putBoolean("IS_SUPPORTING_DIALOGS", isSupportingDialogs.booleanValue()).apply();
        }

        private static class FileNames {
            static final String TEMP_COMPATIBILITY_PERSISTENCE = "LP_COMPATIBILITY";

            private FileNames() {
            }
        }

        private static class Keys {
            static final String IS_SUPPORTING_DIALOGS = "IS_SUPPORTING_DIALOGS";

            private Keys() {
            }
        }
    }
}

