/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.net.Uri;
import android.text.TextUtils;
import com.liveperson.api.request.QueryMessages;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.infra.utils.Synchronizer;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.BasicQueryMessagesCommand;
import com.liveperson.messaging.model.AmsAccount;
import com.liveperson.messaging.model.Dialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QueryMessagesINCACommand
extends BasicQueryMessagesCommand {
    private static final String TAG = "QueryMessagesINCACommand";
    private static final String INCA_GET_MESSAGES_URL = "https://%s/messaging_history/api/account/%s/conversations/conversation/content/%s";
    private static final String SEARCH_QUERY = "search";
    private static final int REQUEST_TIMEOUT = 30000;

    public QueryMessagesINCACommand(Messaging controller, String brandId, String conversationId, String dialogId, boolean updateUI) {
        super(controller, brandId, conversationId, dialogId, updateUI);
    }

    public void execute() {
        String incaDomain = this.controller.mAccountsController.getServiceUrl(this.brandID, "msgHist");
        if (!TextUtils.isEmpty((CharSequence)incaDomain)) {
            String historyUrl = String.format(INCA_GET_MESSAGES_URL, incaDomain, this.brandID, SEARCH_QUERY);
            Uri uri = Uri.parse((String)historyUrl).buildUpon().appendQueryParameter("conversationId", this.conversationId).appendQueryParameter("source", "SDK_Android_History").build();
            LPLog.INSTANCE.d(TAG, "Getting inca messages url " + uri.toString());
            HttpGetRequest httpGetRequest = new HttpGetRequest(uri.toString(), LPTraceType.INCA_GET_CONV_MESSAGES_REQ);
            AmsAccount account = this.controller.mAccountsController.getAccount(this.brandID);
            String token = account == null ? "" : account.getToken();
            httpGetRequest.addHeader("Authorization", "Bearer " + token);
            httpGetRequest.setCertificatePinningKeys(this.controller.mAccountsController.getCertificatePinningKeys(this.brandID));
            httpGetRequest.setTimeout(30000);
            httpGetRequest.setCallback((ICallback)new ICallback<String, Exception>(){

                public void onSuccess(String res) {
                    LPLog.INSTANCE.d(QueryMessagesINCACommand.TAG, "onSuccess with INCA history response details " + res);
                    if (TextUtils.isEmpty((CharSequence)res)) {
                        return;
                    }
                    try {
                        JSONObject jsonObject = new JSONObject(res);
                        JSONArray array = jsonObject.optJSONArray("messageEventRecords");
                        QueryMessages.Response response = new QueryMessages.Response(array);
                        Object messagesResult = response.getBody();
                        QueryMessagesINCACommand.this.saveMessagesResults((ArrayList)messagesResult);
                    }
                    catch (JSONException e) {
                        LPLog.INSTANCE.e(QueryMessagesINCACommand.TAG, ErrorCode.ERR_000000CB, "JSONException while parsing " + res, (Throwable)e);
                    }
                }

                public void onError(Exception exception) {
                    LPLog.INSTANCE.e(QueryMessagesINCACommand.TAG, ErrorCode.ERR_000000CC, "Exception", (Throwable)exception);
                    QueryMessagesINCACommand.this.onHandleResponseCompletedFailed(exception);
                }
            });
            HttpHandler.execute((HttpRequest)httpGetRequest);
            this.onRequestSent();
        }
    }

    private void saveMessagesResults(ArrayList<ContentEventNotification> messagesResult) {
        HashMap messagesByDialogIdMap = new HashMap();
        messagesByDialogIdMap.put(this.dialogId, new ArrayList());
        for (ContentEventNotification notification : messagesResult) {
            if (TextUtils.isEmpty((CharSequence)notification.dialogId)) {
                LPLog.INSTANCE.e(TAG, FlowTags.DIALOGS, ErrorCode.ERR_000000CD, "Dialog ID of message is empty after fetching from INCA");
                notification.dialogId = this.conversationId;
            }
            if (!messagesByDialogIdMap.containsKey(notification.dialogId)) {
                messagesByDialogIdMap.put(notification.dialogId, new ArrayList());
            }
            ((ArrayList)messagesByDialogIdMap.get(notification.dialogId)).add(notification);
        }
        Synchronizer synchronizer = new Synchronizer(extra -> {
            boolean allDoneSuccessfully = true;
            for (Boolean doneSuccessfully : extra) {
                if (doneSuccessfully == null) continue;
                allDoneSuccessfully &= doneSuccessfully.booleanValue();
            }
            if (allDoneSuccessfully) {
                this.onHandleResponseCompletedSuccessfully();
            } else {
                this.onHandleResponseCompletedFailed(null);
            }
        });
        for (Map.Entry entry : messagesByDialogIdMap.entrySet()) {
            final Synchronizer.Holder holder = synchronizer.createHolder();
            if (((ArrayList)entry.getValue()).isEmpty()) {
                LPLog.INSTANCE.e(TAG, FlowTags.DIALOGS, ErrorCode.ERR_000000CE, "Received empty messages list.");
            }
            this.controller.amsDialogs.saveMessagesResult((String)entry.getKey(), (ArrayList)entry.getValue(), true, this.mUpdateUI, new ICallback<Dialog, Exception>(){

                public void onSuccess(Dialog value) {
                    holder.release((Object)true);
                }

                public void onError(Exception exception) {
                    holder.release((Object)false);
                }
            });
        }
    }

    private void onRequestSent() {
        if (!TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.controller.amsConversations.addUpdateRequestInProgress(this.conversationId);
        }
    }

    private void onRequestCompleted() {
        if (!TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.controller.amsConversations.removeUpdateRequestInProgress(this.conversationId);
        }
    }

    private void onHandleResponseCompletedFailed(Exception exception) {
        this.onRequestCompleted();
        if (this.mResponseCallBack != null) {
            Exception cause = exception == null ? new Exception("unexpected QueryMessages") : exception;
            DataBaseExecutor.execute(() -> this.mResponseCallBack.onTaskError(SocketTaskType.QUERY_MESSAGES, cause));
        }
    }

    private void onHandleResponseCompletedSuccessfully() {
        this.onRequestCompleted();
        if (this.mResponseCallBack != null) {
            DataBaseExecutor.execute(() -> this.mResponseCallBack.onTaskSuccess());
        }
    }
}

