package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.SynchronizedAmsConnectionUpdateCallback;

/**
 * Created by Ilya Gazman on 11/16/2015.
 * <p/>
 * Base connection task to obtain user data
 */
public class RefreshNotUpdatedConversationsTask extends BaseAmsSocketConnectionTask {

    private static final String TAG = "RefreshNotUpdatedConversationsTask";
    private final Messaging mController;

    public RefreshNotUpdatedConversationsTask(Messaging controller) {
        mController = controller;
    }

    @Override
    public void execute() {
        new SynchronizedAmsConnectionUpdateCallback(mController.mConnectionController, mBrandId, () -> {
	        LPLog.INSTANCE.d(TAG, "run RefreshNotUpdatedConversationsTask");
            mController.amsConversations.getNotUpdatedConversations(mBrandId)
                    .setPostQueryOnBackground(
                            conversations -> {
                                FetchConversationManager fetchConversationManager = new FetchConversationManager(mController);

                                if (conversations == null || conversations.size() == 0) {
	                                LPLog.INSTANCE.d(TAG, "All conversation are up to date.");
                                } else {
                                    for (Conversation conversation : conversations) {
                                        if (mController.amsConversations.isRefreshingConversation(conversation.getConversationId())) {
                                            LPLog.INSTANCE.d(TAG, "Conversation is already been refreshed: " + conversation.getConversationId());
                                            continue;
                                        }
                                        LPLog.INSTANCE.d(TAG, "refreshing conversation : " + conversation.getConversationId());

                                        String conversationServerId = conversation.getConversationId();
                                        mController.amsConversations.setUpdateRequestInProgress(conversationServerId, 0);
                                        fetchConversationManager.refreshConversation(conversation);
                                    }

	                                LPLog.INSTANCE.d(TAG, "finished refreshing " + conversations.size() + " conversations");
                                }
                            }).execute();

            mController.amsConversations.updateUnmaskedData(mBrandId);
        }).execute();
        mCallback.onTaskSuccess();
    }
}
