package com.liveperson.messaging.model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by ofira on 14/10/2015.
 */
public class AgentData implements Parcelable {

    public String mFirstName;
    public String mLastName;
    public String mAvatarURL;
    public String mEmployeeId;
    public String mNickName;
    public String mAgentId;

    public AgentData(){

    }
    protected AgentData(Parcel in) {
        mFirstName = in.readString();
        mLastName = in.readString();
        mAvatarURL = in.readString();
        mEmployeeId = in.readString();
        mNickName = in.readString();
        mAgentId = in.readString();
    }

    @Override
    public String toString() {
        return new StringBuilder().
                append("[").
                append(mFirstName).append(" ").
                append(mLastName).append(" ").
                append(mAvatarURL).append(" ").
                append(mEmployeeId).append(" ").
                append(mNickName).append(" ").
                append(mAgentId).append(" ").
                append("]").
                toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(mFirstName);
        dest.writeString(mLastName);
        dest.writeString(mAvatarURL);
        dest.writeString(mEmployeeId);
        dest.writeString(mNickName);
        dest.writeString(mAgentId);
    }


    public static final Creator<AgentData> CREATOR = new Creator<AgentData>() {
        @Override
        public AgentData createFromParcel(Parcel in) {
            return new AgentData(in);
        }

        @Override
        public AgentData[] newArray(int size) {
            return new AgentData[size];
        }
    };

}
