package com.liveperson.messaging.model;

import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.background.CoBrowseManager;

import org.json.JSONException;
import org.json.JSONObject;

public class CoBrowseMetadata {

    private static final String TAG = "CoBrowseMetadata";
    public static final String COLLABORATION_CALL_INVITED = "COLLABORATION_CALL_INVITED";
    public static final String COLLABORATION_CALL_ACCEPTED = "COLLABORATION_CALL_ACCEPTED";
    public static final String COLLABORATION_CALL_DECLINED = "COLLABORATION_CALL_DECLINED";
    public static final String COLLABORATION_CALL_ENDED = "COLLABORATION_CALL_ENDED";
    public static final String COLLABORATION_CALL_ENDED_BY_CONSUMER = "COLLABORATION_CALL_ENDED_BY_CONSUMER";
    public static final String COLLABORATION_CALL_ENDED_BY_AGENT = "COLLABORATION_CALL_ENDED_BY_AGENT";
    public static final String COLLABORATION_CALL_TIMEOUT = "COLLABORATION_CALL_TIMEOUT";
    public static final String COLLABORATION_CALL_NOT_JOINED = "COLLABORATION_CALL_NOT_JOINED";
    public static final String COLLABORATION_CALL_JOINED = "COLLABORATION_CALL_JOINED";
    public static final String COLLABORATION_CALL_CANCEL_INVITATION = "COLLABORATION_CALL_CANCEL_INVITATION";
    public static final String COLLABORATION_CALL_CONSUMER_LEFT = "COLLABORATION_CALL_CONSUMER_LEFT";

    public String serviceId;
    public double expires;
    public String sessionState;
    public String dialogId;
    public String mode;
    public String notificationKey;
    public String callLink;

    public CoBrowseMetadata(JSONObject obj) {
        try {
            if(obj.has("dialogId"))  dialogId = obj.getString("dialogId");
            if(obj.has("expires")) expires = obj.getDouble("expires");
            if(obj.has("sessionState")) sessionState = obj.getString("sessionState");
            if(obj.has("serviceId")) serviceId = obj.getString("serviceId");
            if(obj.has("mode")) mode = obj.getString("mode");
            if(obj.has("notificationKey")) notificationKey = obj.getString("notificationKey");
            if(obj.has("callLink")) callLink = obj.getString("callLink");
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject getJsonObject() {
        try {
            JSONObject obj = new JSONObject();
            obj.put("serviceId", serviceId);
            obj.put("expires", expires);
            obj.put("sessionState", sessionState);
            obj.put("dialogId", dialogId);
            obj.put("mode", mode);
            obj.put("notificationKey", notificationKey);
            obj.put("callLink", callLink);

            return obj;
        } catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "getJsonString: error parsing quick reply json", e);
            return null;
        }
    }

    public String getAutomaticMessageKey() {
        if("invited".equals(notificationKey)) return COLLABORATION_CALL_INVITED;
        if("accepted".equals(notificationKey)) return COLLABORATION_CALL_ACCEPTED;
        if("declined".equals(notificationKey)) return COLLABORATION_CALL_DECLINED;
        if("ended".equals(notificationKey)) return COLLABORATION_CALL_ENDED;
        if("ended_by_consumer".equals(notificationKey)) return COLLABORATION_CALL_ENDED_BY_CONSUMER;
        if("ended_by_agent".equals(notificationKey)) return COLLABORATION_CALL_ENDED_BY_AGENT;
        if("timeout".equals(notificationKey)) return COLLABORATION_CALL_TIMEOUT;
        if("not_joined".equals(notificationKey)) return COLLABORATION_CALL_NOT_JOINED;
        if("joined".equals(notificationKey)) return COLLABORATION_CALL_JOINED;
        if("cancel_invitation".equals(notificationKey)) return COLLABORATION_CALL_CANCEL_INVITATION;
        if("consumer_left".equals(notificationKey)) return COLLABORATION_CALL_CONSUMER_LEFT;
        return null;
    }

    public boolean isJoined() {
        return CoBrowseManager.NOTIFICATION_KEY_JOINED.equals(notificationKey);
    }

    public boolean isJoinable() {
        if((CoBrowseManager.NOTIFICATION_KEY_JOINED.equals(notificationKey) || CoBrowseManager.NOTIFICATION_KEY_ACCEPTED.equals(notificationKey)) && CoBrowseManager.STATUS_ACCEPTED.equals(sessionState)) {
            return true;
        }
        if(CoBrowseManager.NOTIFICATION_KEY_CONSUMER_LEFT.equals(notificationKey) && CoBrowseManager.STATUS_ACCEPTED.equals(sessionState)) {
            return true;
        }
        return false;
    }

    public boolean isInvite() {
        return CoBrowseManager.STATUS_INVITED.equals(sessionState);
    }

    public boolean isPresentable() {
        return isClosed() ? false : (isInvite() || isJoinable());
    }

    public boolean isClosed() {
        return CoBrowseManager.STATUS_CLOSED.equals(sessionState);
    }

    public boolean isVideoCall() {
        return CoBrowseManager.MODE_VIDEO_CALL.equals(mode);
    }

    public boolean isVoiceCall() {
        return CoBrowseManager.MODE_VOICE_CALL.equals(mode);
    }

}
