/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.liveperson.api.sdk.LPConversationData;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.infra.utils.LPDeprecated;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.model.AgentData;
import java.io.Serializable;

public class LivePersonIntents {
    public static void sendOnConversationStarted(Context context, LPConversationData convData) {
        Intent intent = new Intent("LP_ON_CONVERSATION_STARTED_INTENT_ACTION");
        intent.putExtra("LP_CONVERSATION_DATA_INTENT_PARCELABLE_EXTRA", (Parcelable)convData);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnConversationResolved(Context context, LPConversationData convData) {
        Intent intent = new Intent("LP_ON_CONVERSATION_RESOLVED_INTENT_ACTION");
        intent.putExtra("LP_CONVERSATION_DATA_INTENT_PARCELABLE_EXTRA", (Parcelable)convData);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnConversationFragmentClosed(Context context) {
        Intent intent = new Intent("LP_ON_CONVERSATION_FRAGMENT_CLOSED_INTENT_ACTION");
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnConversationMarkedAsUrgent(Context context) {
        Intent intent = new Intent("LP_ON_CONVERSATION_MARKED_AS_URGENT_INTENT_ACTION");
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnConversationMarkedAsNormal(Context context) {
        Intent intent = new Intent("LP_ON_CONVERSATION_MARKED_AS_NORMAL_INTENT_ACTION");
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnAgentTyping(Context context, boolean isTyping) {
        Intent intent = new Intent("LP_ON_AGENT_TYPING_INTENT_ACTION");
        intent.putExtra("LP_AGENT_IS_TYPING_INTENT_BOOLEAN_EXTRA", isTyping);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnAgentDetailsChanged(Context context, AgentData agentData) {
        Intent intent = new Intent("LP_ON_AGENT_DETAILS_CHANGED_INTENT_ACTION");
        intent.putExtra("LP_AGENT_DATA_INTENT_PARCELABLE_EXTRA", (Parcelable)agentData);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnOfflineHoursChanges(Context context, boolean isOffHoursOn) {
        Intent intent = new Intent("LP_ON_OFFLINE_HOURS_CHANGES_INTENT_ACTION");
        intent.putExtra("LP_IS_OFFLINE_HOURS_ON_INTENT_BOOLEAN_EXTRA", isOffHoursOn);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnUserDeniedPermission(Context context, PermissionType permissionType, boolean doNotShowAgainMarked) {
        Intent intent = new Intent("LP_ON_USER_DENIED_PERMISSION");
        intent.putExtra("LP_PERMISSION_TYPE_EXTRA", permissionType.ordinal());
        intent.putExtra("LP_PERMISSION_DO_NOT_SHOW_AGAIN_EXTRA", doNotShowAgainMarked);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnUserActionOnPreventedPermission(Context context, PermissionType permissionType) {
        Intent intent = new Intent("LP_ON_USER_ACTION_ON_PREVENTED_PERMISSION");
        intent.putExtra("LP_PERMISSION_TYPE_EXTRA", permissionType.ordinal());
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnAgentAvatarTapped(Context context, AgentData agentData) {
        Intent intent = new Intent("LP_ON_AGENT_AVATAR_TAPPED_INTENT_ACTION");
        intent.putExtra("LP_AGENT_DATA_INTENT_PARCELABLE_EXTRA", (Parcelable)agentData);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnStructuredContentLinkClicked(Context context, String uri) {
        Intent intent = new Intent("LP_ON_STRUCTURED_CONTENT_LINK_CLICKED");
        intent.putExtra("LP_LINK_URI_EXTRA", uri);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnCsatLaunched(Context context) {
        Intent intent = new Intent("LP_ON_CSAT_LAUNCHED_INTENT_ACTION");
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnCsatDismissed(Context context) {
        Intent intent = new Intent("LP_ON_CSAT_DISMISSED_INTENT_ACTION");
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnCsatSubmitted(Context context, String conversationId, Integer starRating) {
        Intent intent = new Intent("LP_ON_CSAT_SUBMITTED_INTENT_ACTION");
        intent.putExtra("LP_CONVERSATION_ID_INTENT_STRING_EXTRA", conversationId);
        intent.putExtra("LP_CSAT_STAR_RATING_INTENT_INT_EXTRA", (Serializable)starRating);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnCsatSkipped(Context context) {
        Intent intent = new Intent("LP_ON_CSAT_SKIPPED_INTENT_ACTION");
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnTokenExpired(Context context) {
        Intent intent = new Intent("LP_ON_TOKEN_EXPIRED_INTENT_ACTION");
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnUserExpired(Context context) {
        Intent intent = new Intent("LP_ON_UNAUTHENTICATED_USER_EXPIRED_INTENT_ACTION");
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnConnectionChanged(Context context, boolean isUpdated) {
        Intent intent = new Intent("LP_ON_CONNECTION_CHANGED_INTENT_ACTION");
        intent.putExtra("LP_IS_CONNECTED_INTENT_BOOLEAN_EXTRA", isUpdated);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnErrorIntent(Context context, TaskType type, String message) {
        Intent intent = new Intent("LP_ON_ERROR_INTENT_ACTION");
        intent.putExtra("LP_ON_ERROR_MESSAGE_INTENT_STRING_EXTRA", message);
        intent.putExtra("LP_ON_ERROR_TASK_TYPE_INTENT_INT_EXTRA", type.ordinal());
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static void sendOnErrorIntent(Context context, LpError lpError, String message) {
        Intent intent = new Intent("LP_ON_ERROR_TYPE_INTENT_ACTION");
        intent.putExtra("LP_ON_ERROR_MESSAGE_INTENT_STRING_EXTRA", message);
        intent.putExtra("LP_ON_ERROR_INTENT_INT_EXTRA", lpError.ordinal());
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public static LPConversationData getLPConversationData(Intent intent) {
        return (LPConversationData)intent.getParcelableExtra("LP_CONVERSATION_DATA_INTENT_PARCELABLE_EXTRA");
    }

    public static boolean getAgentTypingValue(Intent intent) {
        return intent.getBooleanExtra("LP_AGENT_IS_TYPING_INTENT_BOOLEAN_EXTRA", false);
    }

    public static AgentData getAgentData(Intent intent) {
        return (AgentData)intent.getParcelableExtra("LP_AGENT_DATA_INTENT_PARCELABLE_EXTRA");
    }

    public static boolean getOfflineHoursOn(Intent intent) {
        return intent.getBooleanExtra("LP_IS_OFFLINE_HOURS_ON_INTENT_BOOLEAN_EXTRA", false);
    }

    public static PermissionType getPermissionType(Intent intent) {
        int permissionType = intent.getIntExtra("LP_PERMISSION_TYPE_EXTRA", -1);
        if (permissionType >= 0 && permissionType < PermissionType.values().length) {
            return PermissionType.values()[permissionType];
        }
        return null;
    }

    public static boolean getPermissionDoNotShowAgainMarked(Intent intent) {
        return intent.getBooleanExtra("LP_PERMISSION_DO_NOT_SHOW_AGAIN_EXTRA", false);
    }

    public static String getLinkUri(Intent intent) {
        return intent.getStringExtra("LP_LINK_URI_EXTRA");
    }

    public static String getConversationID(Intent intent) {
        return intent.getStringExtra("LP_CONVERSATION_ID_INTENT_STRING_EXTRA");
    }

    public static int getCsatStarRating(Intent intent) {
        return intent.getIntExtra("LP_CSAT_STAR_RATING_INTENT_INT_EXTRA", -1);
    }

    public static boolean getConnectedValue(Intent intent) {
        return intent.getBooleanExtra("LP_IS_CONNECTED_INTENT_BOOLEAN_EXTRA", false);
    }

    public static TaskType getOnErrorTaskType(Intent intent) {
        int taskTypeInt = intent.getIntExtra("LP_ON_ERROR_TASK_TYPE_INTENT_INT_EXTRA", -1);
        if (taskTypeInt >= 0 && taskTypeInt < TaskType.values().length) {
            return TaskType.values()[taskTypeInt];
        }
        return null;
    }

    @NonNull
    public static LpError getErrorType(Intent intent) {
        int errorTypeIndex = intent.getIntExtra("LP_ON_ERROR_INTENT_INT_EXTRA", -1);
        if (errorTypeIndex >= 0 && errorTypeIndex < LpError.values().length) {
            return LpError.values()[errorTypeIndex];
        }
        return LpError.UNKNOWN;
    }

    public static String getOnErrorMessage(Intent intent) {
        return intent.getStringExtra("LP_ON_ERROR_MESSAGE_INTENT_STRING_EXTRA");
    }

    public static IntentFilter getIntentFilterForAllEvents() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("LP_ON_ERROR_INTENT_ACTION");
        filter.addAction("LP_ON_ERROR_TYPE_INTENT_ACTION");
        filter.addAction("LP_ON_TOKEN_EXPIRED_INTENT_ACTION");
        filter.addAction("LP_ON_CONVERSATION_STARTED_INTENT_ACTION");
        filter.addAction("LP_ON_CONVERSATION_RESOLVED_INTENT_ACTION");
        filter.addAction("LP_ON_CONVERSATION_FRAGMENT_CLOSED_INTENT_ACTION");
        filter.addAction("LP_ON_CONNECTION_CHANGED_INTENT_ACTION");
        filter.addAction("LP_ON_AGENT_TYPING_INTENT_ACTION");
        filter.addAction("LP_ON_AGENT_DETAILS_CHANGED_INTENT_ACTION");
        filter.addAction("LP_ON_CSAT_LAUNCHED_INTENT_ACTION");
        filter.addAction("LP_ON_CSAT_DISMISSED_INTENT_ACTION");
        filter.addAction("LP_ON_CSAT_SKIPPED_INTENT_ACTION");
        filter.addAction("LP_ON_CSAT_SUBMITTED_INTENT_ACTION");
        filter.addAction("LP_ON_CONVERSATION_MARKED_AS_URGENT_INTENT_ACTION");
        filter.addAction("LP_ON_CONVERSATION_MARKED_AS_NORMAL_INTENT_ACTION");
        filter.addAction("LP_ON_OFFLINE_HOURS_CHANGES_INTENT_ACTION");
        filter.addAction("LP_ON_AGENT_AVATAR_TAPPED_INTENT_ACTION");
        filter.addAction("LP_ON_USER_DENIED_PERMISSION");
        filter.addAction("LP_ON_USER_ACTION_ON_PREVENTED_PERMISSION");
        filter.addAction("LP_ON_STRUCTURED_CONTENT_LINK_CLICKED");
        filter.addAction("LP_ON_UNAUTHENTICATED_USER_EXPIRED_INTENT_ACTION");
        return filter;
    }

    public static interface ILivePersonIntentAction {
        public static final String LP_ON_CONVERSATION_STARTED_INTENT_ACTION = "LP_ON_CONVERSATION_STARTED_INTENT_ACTION";
        public static final String LP_ON_CONVERSATION_RESOLVED_INTENT_ACTION = "LP_ON_CONVERSATION_RESOLVED_INTENT_ACTION";
        public static final String LP_ON_CONVERSATION_FRAGMENT_CLOSED_INTENT_ACTION = "LP_ON_CONVERSATION_FRAGMENT_CLOSED_INTENT_ACTION";
        public static final String LP_ON_CONVERSATION_MARKED_AS_URGENT_INTENT_ACTION = "LP_ON_CONVERSATION_MARKED_AS_URGENT_INTENT_ACTION";
        public static final String LP_ON_CONVERSATION_MARKED_AS_NORMAL_INTENT_ACTION = "LP_ON_CONVERSATION_MARKED_AS_NORMAL_INTENT_ACTION";
        public static final String LP_ON_AGENT_TYPING_INTENT_ACTION = "LP_ON_AGENT_TYPING_INTENT_ACTION";
        public static final String LP_ON_AGENT_DETAILS_CHANGED_INTENT_ACTION = "LP_ON_AGENT_DETAILS_CHANGED_INTENT_ACTION";
        public static final String LP_ON_OFFLINE_HOURS_CHANGES_INTENT_ACTION = "LP_ON_OFFLINE_HOURS_CHANGES_INTENT_ACTION";
        public static final String LP_ON_USER_DENIED_PERMISSION = "LP_ON_USER_DENIED_PERMISSION";
        public static final String LP_ON_USER_ACTION_ON_PREVENTED_PERMISSION = "LP_ON_USER_ACTION_ON_PREVENTED_PERMISSION";
        public static final String LP_ON_AGENT_AVATAR_TAPPED_INTENT_ACTION = "LP_ON_AGENT_AVATAR_TAPPED_INTENT_ACTION";
        public static final String LP_ON_STRUCTURED_CONTENT_LINK_CLICKED = "LP_ON_STRUCTURED_CONTENT_LINK_CLICKED";
        public static final String LP_ON_CSAT_LAUNCHED_INTENT_ACTION = "LP_ON_CSAT_LAUNCHED_INTENT_ACTION";
        public static final String LP_ON_CSAT_DISMISSED_INTENT_ACTION = "LP_ON_CSAT_DISMISSED_INTENT_ACTION";
        public static final String LP_ON_CSAT_SUBMITTED_INTENT_ACTION = "LP_ON_CSAT_SUBMITTED_INTENT_ACTION";
        public static final String LP_ON_CSAT_SKIPPED_INTENT_ACTION = "LP_ON_CSAT_SKIPPED_INTENT_ACTION";
        public static final String LP_ON_TOKEN_EXPIRED_INTENT_ACTION = "LP_ON_TOKEN_EXPIRED_INTENT_ACTION";
        public static final String LP_ON_UNAUTHENTICATED_USER_EXPIRED_INTENT_ACTION = "LP_ON_UNAUTHENTICATED_USER_EXPIRED_INTENT_ACTION";
        public static final String LP_ON_CONNECTION_CHANGED_INTENT_ACTION = "LP_ON_CONNECTION_CHANGED_INTENT_ACTION";
        @Deprecated
        @LPDeprecated(since=1601280000)
        public static final String LP_ON_ERROR_INTENT_ACTION = "LP_ON_ERROR_INTENT_ACTION";
        public static final String LP_ON_ERROR_TYPE_INTENT_ACTION = "LP_ON_ERROR_TYPE_INTENT_ACTION";
    }

    public static interface ILivePersonIntentExtras {
        public static final String LP_CONVERSATION_DATA_INTENT_PARCELABLE_EXTRA = "LP_CONVERSATION_DATA_INTENT_PARCELABLE_EXTRA";
        public static final String LP_AGENT_IS_TYPING_INTENT_BOOLEAN_EXTRA = "LP_AGENT_IS_TYPING_INTENT_BOOLEAN_EXTRA";
        public static final String LP_AGENT_DATA_INTENT_PARCELABLE_EXTRA = "LP_AGENT_DATA_INTENT_PARCELABLE_EXTRA";
        public static final String LP_IS_OFFLINE_HOURS_ON_INTENT_BOOLEAN_EXTRA = "LP_IS_OFFLINE_HOURS_ON_INTENT_BOOLEAN_EXTRA";
        public static final String LP_PERMISSION_TYPE_EXTRA = "LP_PERMISSION_TYPE_EXTRA";
        public static final String LP_PERMISSION_DO_NOT_SHOW_AGAIN_EXTRA = "LP_PERMISSION_DO_NOT_SHOW_AGAIN_EXTRA";
        public static final String LP_LINK_URI_EXTRA = "LP_LINK_URI_EXTRA";
        public static final String LP_CONVERSATION_ID_INTENT_STRING_EXTRA = "LP_CONVERSATION_ID_INTENT_STRING_EXTRA";
        public static final String LP_CSAT_STAR_RATING_INTENT_INT_EXTRA = "LP_CSAT_STAR_RATING_INTENT_INT_EXTRA";
        public static final String LP_IS_CONNECTED_INTENT_BOOLEAN_EXTRA = "LP_IS_CONNECTED_INTENT_BOOLEAN_EXTRA";
        @Deprecated
        @LPDeprecated(since=1601280000)
        public static final String LP_ON_ERROR_TASK_TYPE_INTENT_INT_EXTRA = "LP_ON_ERROR_TASK_TYPE_INTENT_INT_EXTRA";
        public static final String LP_ON_ERROR_INTENT_INT_EXTRA = "LP_ON_ERROR_INTENT_INT_EXTRA";
        public static final String LP_ON_ERROR_MESSAGE_INTENT_STRING_EXTRA = "LP_ON_ERROR_MESSAGE_INTENT_STRING_EXTRA";
    }
}

