/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.api.request.GetClock;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.otel.LPTelemetryManager;
import com.liveperson.infra.otel.LPTraceSpan;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.network.socket.general_requests.ClockRequest;

public class GetClockTask
extends BaseAmsSocketConnectionTask {
    private static final String TAG = "GetClockTask";
    private final Messaging mController;

    public GetClockTask(Messaging controller) {
        this.mController = controller;
    }

    public void execute() {
        LPLog.INSTANCE.i(TAG, "Running get clock task...");
        final LPTraceSpan traceSpan = LPTelemetryManager.INSTANCE.begin(LPTraceType.UMS_GET_CLOCK_REQ);
        ClockRequest baseSocketRequest = new ClockRequest(this.mController.mConnectionController, this.mController.mAccountsController.getConnectionUrl(this.mBrandId), this.mBrandId);
        baseSocketRequest.addCallback((ResponseCallback)new ResponseCallback<GetClock.Response>(){

            public void onSuccess(GetClock.Response data) {
                if (traceSpan != null) {
                    traceSpan.end();
                }
                GetClockTask.this.mCallback.onTaskSuccess();
            }

            public void onError() {
                if (traceSpan != null) {
                    traceSpan.cancel();
                }
                GetClockTask.this.mCallback.onTaskError(SocketTaskType.GET_CLOCK, new Exception("get clock error"));
            }
        });
        SocketManager.getInstance().send((BaseSocketRequest)baseSocketRequest);
    }
}

