/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.LptagData;
import com.liveperson.infra.network.http.requests.LptagRequest;
import com.liveperson.infra.utils.DispatchQueue;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.controller.connection.IConnectionParamsCache;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public class LptagTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "LptagTask";
    private final AccountsController mAccountsController;
    private DispatchQueue mDispatchQueue;
    private int mRetryCounter;
    private LptagRequest mLptagRequest = null;

    public LptagTask(AccountsController accountsController) {
        this.mAccountsController = accountsController;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running LPTag task...");
        AmsConnectionAnalytics.lptagTaskStart();
        this.mDispatchQueue = new DispatchQueue("Lptag");
        this.mRetryCounter = 0;
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        String domain = Infra.instance.getLptagEnvironment().getLptagDomain();
        this.mLptagRequest = new LptagRequest(domain, this.mBrandId, certificates, (ICallback)new ICallback<LptagData, Exception>(){

            public void onSuccess(LptagData lptagData) {
                if (lptagData != null) {
                    if (lptagData.getMaxRetries() > 0) {
                        if (LptagTask.this.mRetryCounter < lptagData.getMaxRetries()) {
                            LPLog.INSTANCE.d(LptagTask.TAG, "onSuccess: Need retry. MaxRetries = " + lptagData.getMaxRetries() + ", current retry = " + LptagTask.this.mRetryCounter + ", RetryTimeout = " + lptagData.getRetryTimeout());
                            LptagTask.this.mRetryCounter++;
                            LptagTask.this.mDispatchQueue.postRunnable(() -> LptagTask.this.mLptagRequest.execute(), (long)lptagData.getRetryTimeout());
                        } else {
                            LPLog.INSTANCE.d(LptagTask.TAG, "Done all retries but still didn't get reply. AutoMessages is off. Return success");
                            LptagTask.this.mCallback.onTaskSuccess();
                        }
                    } else {
                        IConnectionParamsCache cache = LptagTask.this.mAccountsController.getConnectionParamsCache(LptagTask.this.mBrandId);
                        if (cache != null) {
                            cache.setAutoMessagesFeatureEnabled(lptagData.isAutoMessagesFeatureEnabled());
                        }
                        LPLog.INSTANCE.d(LptagTask.TAG, "onSuccess: Got AutoMessages feature: " + lptagData.isAutoMessagesFeatureEnabled());
                        AmsConnectionAnalytics.lptagTaskEnd();
                        LptagTask.this.mCallback.onTaskSuccess();
                    }
                } else {
                    LPLog.INSTANCE.d(LptagTask.TAG, "onSuccess: No AutoMessages feature received from LPTag");
                    AmsConnectionAnalytics.lptagTaskEnd();
                    LptagTask.this.mCallback.onTaskSuccess();
                }
            }

            public void onError(Exception e) {
                AmsConnectionAnalytics.lptagTaskEnd();
                if (e instanceof SSLPeerUnverifiedException) {
                    LptagTask.this.mCallback.onTaskError(TaskType.INVALID_CERTIFICATE, LpError.INVALID_CERTIFICATE, e);
                } else {
                    LptagTask.this.mCallback.onTaskError(TaskType.CSDS, LpError.CSDS, e);
                }
            }
        });
        this.mLptagRequest.execute();
    }

    @Override
    public String getName() {
        return TAG;
    }
}

