/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.os.Bundle;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.tasks.OfflineModeSubscriptionRequestCallback;
import com.liveperson.messaging.network.socket.requests.SubscribeMessagingEventsRequest;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/liveperson/messaging/commands/tasks/MessagingEventSubscriptionManager;", "", "()V", "subscribedDialogUIUpdate", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "subscribedDialogs", "addSubscription", "", "controller", "Lcom/liveperson/messaging/Messaging;", "brandID", "conversationId", "dialogId", "fromSeq", "", "updateUI", "clearAllSubscriptions", "onReceivedEvent", "shouldUpdateUI", "Companion", "messaging_release"})
public final class MessagingEventSubscriptionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HashMap<String, Boolean> subscribedDialogs = new HashMap();
    @NotNull
    private HashMap<String, Boolean> subscribedDialogUIUpdate = new HashMap();
    @NotNull
    private static final String SUCCESS = "TASK_SUCCESS";
    @NotNull
    private static final String ERROR_MESSAGE = "TASK_ERROR_MESSAGE";
    @NotNull
    private static final String MESSAGE_EVENT_COMPLETED = "MESSAGE_EVENT_COMPLETED";

    public final void addSubscription(@NotNull Messaging controller, @NotNull String brandID, @NotNull String conversationId, @NotNull String dialogId, int fromSeq, boolean updateUI) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)brandID, (String)"brandID");
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        Intrinsics.checkNotNullParameter((Object)dialogId, (String)"dialogId");
        int fromSeq2 = fromSeq;
        if (fromSeq2 == -1) {
            fromSeq2 = 0;
        }
        String $this$guard$iv = controller.mAccountsController.getConnectionUrl(brandID);
        boolean $i$f$guard = false;
        if ($this$guard$iv == null) {
            String $this$addSubscription_u24lambda_u2d0 = $this$guard$iv;
            boolean bl = false;
            LPLog.INSTANCE.w("SubscriptionManager", "The brand (wih ID: " + brandID + ") has no connection URL!");
            return;
        }
        String it$iv = $this$guard$iv;
        boolean bl = false;
        String url = it$iv;
        if (!((Map)this.subscribedDialogs).containsKey(dialogId)) {
            LPLog.INSTANCE.w("SubscriptionManager", "Adding subscription for dialogId: " + dialogId + " from seq: " + fromSeq2);
            ((Map)this.subscribedDialogs).put(dialogId, true);
            Boolean bl2 = updateUI;
            ((Map)this.subscribedDialogUIUpdate).put(dialogId, bl2);
            SubscribeMessagingEventsRequest request = new SubscribeMessagingEventsRequest(url, conversationId, dialogId, fromSeq2);
            request.addCallback(new OfflineModeSubscriptionRequestCallback(request, controller, dialogId));
            SocketManager.getInstance().send((BaseSocketRequest)request);
        } else {
            LPLog.INSTANCE.w("SubscriptionManager", "Already added subscription for dialogId: " + dialogId + " Subscription already exists!");
        }
    }

    public static /* synthetic */ void addSubscription$default(MessagingEventSubscriptionManager messagingEventSubscriptionManager, Messaging messaging, String string2, String string3, String string4, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        messagingEventSubscriptionManager.addSubscription(messaging, string2, string3, string4, n, bl);
    }

    public final boolean onReceivedEvent(@NotNull String dialogId) {
        Intrinsics.checkNotNullParameter((Object)dialogId, (String)"dialogId");
        Boolean oldValue = this.subscribedDialogs.get(dialogId);
        if (oldValue == null) {
            oldValue = false;
        }
        if (Intrinsics.areEqual((Object)oldValue, (Object)true)) {
            LPLog.INSTANCE.w("SubscriptionManager", "onReceivedEvent! sending intent notification received for dialogId: " + dialogId);
            Bundle bundle = new Bundle();
            bundle.putBoolean(SUCCESS, true);
            LocalBroadcast.sendBroadcast((String)(MESSAGE_EVENT_COMPLETED + dialogId), (Bundle)bundle);
            ((Map)this.subscribedDialogs).put(dialogId, false);
        }
        return oldValue;
    }

    public final boolean shouldUpdateUI(@NotNull String conversationId) {
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        Boolean oldValue = this.subscribedDialogUIUpdate.get(conversationId);
        ((Map)this.subscribedDialogUIUpdate).put(conversationId, true);
        if (oldValue == null) {
            oldValue = false;
        }
        return oldValue;
    }

    public final void clearAllSubscriptions() {
        this.subscribedDialogs.clear();
    }

    @NotNull
    public static final String getSUCCESS() {
        return Companion.getSUCCESS();
    }

    @NotNull
    public static final String getERROR_MESSAGE() {
        return Companion.getERROR_MESSAGE();
    }

    @NotNull
    public static final String getMESSAGE_EVENT_COMPLETED() {
        return Companion.getMESSAGE_EVENT_COMPLETED();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/liveperson/messaging/commands/tasks/MessagingEventSubscriptionManager$Companion;", "", "()V", "ERROR_MESSAGE", "", "getERROR_MESSAGE$annotations", "getERROR_MESSAGE", "()Ljava/lang/String;", "MESSAGE_EVENT_COMPLETED", "getMESSAGE_EVENT_COMPLETED$annotations", "getMESSAGE_EVENT_COMPLETED", "SUCCESS", "getSUCCESS$annotations", "getSUCCESS", "onError", "", "conversationId", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSUCCESS() {
            return SUCCESS;
        }

        @JvmStatic
        public static /* synthetic */ void getSUCCESS$annotations() {
        }

        @NotNull
        public final String getERROR_MESSAGE() {
            return ERROR_MESSAGE;
        }

        @JvmStatic
        public static /* synthetic */ void getERROR_MESSAGE$annotations() {
        }

        @NotNull
        public final String getMESSAGE_EVENT_COMPLETED() {
            return MESSAGE_EVENT_COMPLETED;
        }

        @JvmStatic
        public static /* synthetic */ void getMESSAGE_EVENT_COMPLETED$annotations() {
        }

        public final void onError(@NotNull String conversationId) {
            Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
            Bundle bundle = new Bundle();
            bundle.putBoolean(Companion.getSUCCESS(), false);
            LocalBroadcast.sendBroadcast((String)(Companion.getMESSAGE_EVENT_COMPLETED() + conversationId), (Bundle)bundle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

