/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.net.Uri;
import com.liveperson.api.response.model.QueryParams;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpOpenStreamRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import okhttp3.Response;

public class DownloadFileRequest
implements Command {
    private static final String TAG = "DownloadFileRequest";
    private static final int DOWNLOAD_IMAGE_TIMEOUT = 30000;
    private String mRelativePath;
    private QueryParams mQueryParams;
    private ICallback<byte[], Exception> mCallback;
    private String mDomain;
    private List<String> mCertificates;

    public DownloadFileRequest(String domain, String relativePath, QueryParams queryParams, List<String> certificates, ICallback<byte[], Exception> callback) {
        this.mRelativePath = relativePath;
        this.mQueryParams = queryParams;
        this.mCallback = callback;
        this.mDomain = domain;
        this.mCertificates = certificates;
    }

    public void execute() {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https");
        builder.path(this.mDomain + this.mRelativePath);
        this.mQueryParams.appendQueryParameter(builder);
        HttpOpenStreamRequest httpGetRequest = new HttpOpenStreamRequest(builder.build().toString());
        httpGetRequest.setTimeout(30000);
        httpGetRequest.setCertificatePinningKeys(this.mCertificates);
        LPLog.INSTANCE.d(TAG, "Downloading file from swift...");
        httpGetRequest.setCallback((ICallback)new ICallback<Response, Exception>(){

            public void onSuccess(Response response) {
                InputStream is = response.body().byteStream();
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    int nRead;
                    LPLog.INSTANCE.d(DownloadFileRequest.TAG, "Downloading file from swift....  ");
                    byte[] data = new byte[16384];
                    while ((nRead = is.read(data, 0, data.length)) != -1) {
                        bos.write(data, 0, nRead);
                    }
                    bos.flush();
                    byte[] byteArray = bos.toByteArray();
                    LPLog.INSTANCE.d(DownloadFileRequest.TAG, "Downloading file from swift - byteArray.length  = " + byteArray.length);
                    DownloadFileRequest.this.mCallback.onSuccess((Object)byteArray);
                }
                catch (IOException exception) {
                    DownloadFileRequest.this.mCallback.onError((Throwable)exception);
                }
            }

            public void onError(Exception exception) {
                DownloadFileRequest.this.mCallback.onError((Throwable)exception);
            }
        });
        HttpHandler.execute((HttpRequest)httpGetRequest);
    }
}

