/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.content.Context;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.callbacks.PKCEParamsCallBack;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.model.JWKInfo;
import com.liveperson.infra.model.PKCEParams;
import com.liveperson.infra.model.errors.PkceGenerateError;
import com.liveperson.infra.model.types.PkceGenerateFailureReason;
import com.liveperson.infra.network.http.requests.CSDSRequest;
import com.liveperson.infra.network.http.requests.JWKSRequest;
import com.liveperson.infra.utils.PKCEUtils;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/liveperson/messaging/network/http/GeneratePKCEParamsRequest;", "Lcom/liveperson/infra/Command;", "context", "Landroid/content/Context;", "brandId", "", "lpAuthenticationParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "callback", "Lcom/liveperson/infra/callbacks/PKCEParamsCallBack;", "(Landroid/content/Context;Ljava/lang/String;Lcom/liveperson/infra/auth/LPAuthenticationParams;Lcom/liveperson/infra/callbacks/PKCEParamsCallBack;)V", "getBrandId", "()Ljava/lang/String;", "getCallback", "()Lcom/liveperson/infra/callbacks/PKCEParamsCallBack;", "getContext", "()Landroid/content/Context;", "csdsDomain", "getLpAuthenticationParams", "()Lcom/liveperson/infra/auth/LPAuthenticationParams;", "execute", "", "Companion", "messaging_release"})
public final class GeneratePKCEParamsRequest
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String brandId;
    @Nullable
    private final LPAuthenticationParams lpAuthenticationParams;
    @NotNull
    private final PKCEParamsCallBack callback;
    @Nullable
    private String csdsDomain;
    @NotNull
    private static final String TAG = "GeneratePKCEParamsRequest";
    @NotNull
    private static final String LP_IDP_SERVICE_NAME = "idp";

    public GeneratePKCEParamsRequest(@NotNull Context context, @NotNull String brandId, @Nullable LPAuthenticationParams lpAuthenticationParams, @NotNull PKCEParamsCallBack callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.context = context;
        this.brandId = brandId;
        this.lpAuthenticationParams = lpAuthenticationParams;
        this.callback = callback;
        this.csdsDomain = StringsKt.startsWith$default((String)this.brandId, (String)"qa", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.brandId, (String)"le", (boolean)false, (int)2, null) ? this.context.getResources().getString(R.string.csds_qa_url) : this.context.getResources().getString(R.string.csds_url);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @Nullable
    public final LPAuthenticationParams getLpAuthenticationParams() {
        return this.lpAuthenticationParams;
    }

    @NotNull
    public final PKCEParamsCallBack getCallback() {
        return this.callback;
    }

    public void execute() {
        LPAuthenticationParams lPAuthenticationParams = this.lpAuthenticationParams;
        new CSDSRequest(this.csdsDomain, this.brandId, LP_IDP_SERVICE_NAME, lPAuthenticationParams != null ? lPAuthenticationParams.getCertificatePinningKeys() : null, (ICallback)new ICallback<HashMap<String, String>, Exception>(this){
            final /* synthetic */ GeneratePKCEParamsRequest this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable HashMap<String, String> csdsUrls) {
                Map map = csdsUrls;
                if (!(map == null || map.isEmpty())) {
                    String string2 = csdsUrls.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"csdsUrls.toString()");
                    LPLog.INSTANCE.i("GeneratePKCEParamsRequest", string2);
                    String lpIdpDomain = csdsUrls.get("idp");
                    if (lpIdpDomain != null) {
                        new JWKSRequest(lpIdpDomain, (ICallback)new ICallback<JWKInfo, Exception>(this.this$0){
                            final /* synthetic */ GeneratePKCEParamsRequest this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public void onSuccess(@Nullable JWKInfo jwkInfo) {
                                if (jwkInfo != null) {
                                    try {
                                        PKCEParams params = PKCEUtils.INSTANCE.generatePKCEParams(jwkInfo.getKId(), jwkInfo.getJwk());
                                        this.this$0.getCallback().onPKCEGenerateSuccess(params);
                                        return;
                                    }
                                    catch (Exception e) {
                                        this.this$0.getCallback().onPKCEGenerateFailed(new PkceGenerateError(PkceGenerateFailureReason.GENERATE_JWE, e));
                                    }
                                } else {
                                    this.this$0.getCallback().onPKCEGenerateFailed(new PkceGenerateError(PkceGenerateFailureReason.LP_JWKS, new Exception("Failed to get JWK - null value")));
                                }
                            }

                            public void onError(@Nullable Exception exception) {
                                Exception it = exception;
                                boolean bl = false;
                                LPLog.INSTANCE.e("GeneratePKCEParamsRequest", ErrorCode.ERR_0000016C, "JWKSRequest onError: ", (Throwable)it);
                                this.this$0.getCallback().onPKCEGenerateFailed(new PkceGenerateError(PkceGenerateFailureReason.LP_JWKS, exception));
                            }
                        }).execute();
                    }
                } else {
                    LPLog.INSTANCE.e("GeneratePKCEParamsRequest", ErrorCode.ERR_0000016C, "CSDSRequest: Received empty CSDS domain map");
                    this.this$0.getCallback().onPKCEGenerateFailed(new PkceGenerateError(PkceGenerateFailureReason.CSDS_DOMAIN, new Exception("Failed to get CSDS domain")));
                }
            }

            public void onError(@Nullable Exception exception) {
                Exception it = exception;
                boolean bl = false;
                LPLog.INSTANCE.e("GeneratePKCEParamsRequest", ErrorCode.ERR_0000016C, "CSDSRequest onError: ", (Throwable)it);
                this.this$0.getCallback().onPKCEGenerateFailed(new PkceGenerateError(PkceGenerateFailureReason.CSDS_DOMAIN, exception));
            }
        }).execute();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/liveperson/messaging/network/http/GeneratePKCEParamsRequest$Companion;", "", "()V", "LP_IDP_SERVICE_NAME", "", "TAG", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

