package com.liveperson.api.request;

import android.text.TextUtils;

import com.liveperson.api.response.AbstractResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Shayl on 8/9/2015.
 */
public class SubscribeExConversations extends AbstractRequest {

    private static final String SUBSCRIBE_EX_CONVERSATIONS_TYPE = "cqm.SubscribeExConversations";
    private static final String BODY_MAX_LAST_UPDATE_TIME = "maxLastUpdatedTime";
    private static final String BODY_MIN_LAST_UPDATE_TIME = "minLastUpdatedTime";
    private static final String BODY_AGENT_IDS = "agentIds";
    private static final String BODY_CONSUMER_ID = "consumerId";
    private static final String BODY_BRAND_ID = "brandId";
    private static final String BODY_MAX_TTR = "maxETTR";
    private static final String BODY_CONV_STATE = "convState";// : [ "OPEN", "CLOSED", "LOCKED" ]
    private static final String BODY_CONV_STAGE = "stage";// : [ "OPEN", "CLOSED", "LOCKED" ]


    private String consumerId;
    private long maxLastUpdatedTime;
    private long minLastUpdatedTime;
    private String[] agentIds;
    private String brandId;
    private int maxETTR;
    private String[] convStage;

    public SubscribeExConversations(String consumerId,
                                    long maxLastUpdatedTime,
                                    long minLastUpdatedTime,
                                    String[] agentIds,
                                    String brandId,
                                    int maxETTR,
                                    String[] conversationStages) {
        super();
        this.consumerId = consumerId;
        this.maxLastUpdatedTime = maxLastUpdatedTime;
        this.minLastUpdatedTime = minLastUpdatedTime;
        this.agentIds = agentIds;
        this.brandId = brandId;
        this.maxETTR = maxETTR;
        this.convStage = conversationStages;
    }

    @Override
    public String getMessageType() {
        return SUBSCRIBE_EX_CONVERSATIONS_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        body.put(BODY_MAX_LAST_UPDATE_TIME, maxLastUpdatedTime != -1 ? maxLastUpdatedTime : JSONObject.NULL);
        body.put(BODY_MIN_LAST_UPDATE_TIME, minLastUpdatedTime != -1 ? minLastUpdatedTime : JSONObject.NULL);

        JSONArray jsonArray = new JSONArray();
        for (String agentId : agentIds) {
            jsonArray.put(agentId);
        }

        body.put(BODY_AGENT_IDS, jsonArray);
        body.put(BODY_CONSUMER_ID, consumerId);
        body.put(BODY_BRAND_ID, brandId);
        body.put(BODY_MAX_TTR, maxETTR > 0 ? maxETTR : JSONObject.NULL);

        jsonArray = new JSONArray();
        for (String s : convStage) {
            jsonArray.put(s);
        }

        body.put(BODY_CONV_STATE, jsonArray);
        body.put(BODY_CONV_STAGE, jsonArray);

        json.put(AbstractRequest.JSON_KEY_BODY, body);
    }


    public static class Response extends AbstractResponse {
        private static final String SUBSCRIPTION_ID = "subscriptionId";
        public static final String SUBSCRIBE_EX_CONVERSATIONS_RESPONSE_TYPE = "cqm.SubscribeExConversationsResponse" ;

        Body body = new Body();


        public Response(JSONObject obj) throws JSONException {
            super(obj);

            JSONObject innerBody = obj.getJSONObject(JSON_KEY_BODY);
            body.subscriptionId = innerBody.getString(SUBSCRIPTION_ID);
            if (TextUtils.isEmpty(body.subscriptionId)){
                throw new JSONException("no subscription id");
            }
        }

        public Object getBody() {
            return body;
        }

        public static class Body {
            public String subscriptionId;
        }
    }

}
