package com.liveperson.api.request;


import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.CsatStatus;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.ConversationField;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Shayl on 8/9/2015.
 */
public class UpdateConversationField extends AbstractRequest {

    public static final String CONVERSATION_STAGE_FIELD = "Stage";
    @Deprecated
    private static final String CONVERSATION_STATE_FIELD = "ConversationStateField";

    /**
     * This is a temp method (it shouldn't exist on versions newer than 3.3) that helps in determining which if the fields should be in use (the deprecated one or the new one).
     * @return
     */
    public static String CONVERSATION_STATE_FIELD() {
        return AmsDialogs.isUmsSupportingDialogs() ? CONVERSATION_STAGE_FIELD : CONVERSATION_STATE_FIELD;
    }

    public static final String CONVERSATION_CSAT_RATE = "CSATRate";
    public static final String TTR_FIELD = "TTRField";
    public static final String UPDATE_CONVERSATION_FIELD_TYPE = "cm.UpdateConversationField";
    private static final String UPDATE = "UPDATE";

    public static final String CONVERSATION_ID = "conversationId";
    public static final String FIELD = "field";
    private static final String TYPE = "type";
    private static final String USER_ID = "userId";
    private static final String ROLE = "role";
    private static final String DIALOG = "dialog";
    private static final String DIALOG_ID = "dialogId";
    private static final String STATE = "state";
    private static final String CLOSED_BY = "closedBy";
    @Deprecated
    public static final String CONVERSATION_STATE = "conversationState";
    public static final String CONVERSATION_STAGE = "stage";
    public static final String CONVERSATION_CSAT = "csatRate";
    public static final String CONVERSATION_CSAT_YESNO_VALUE = "csatResolutionConfirmation";
    public static final String CONVERSATION_CSAT_STATUS = "status";
    public static final String CONVERSATION_FIELD = "conversationField";
    public static final String PARTICIPANTS_CHANGE_FIELD = "ParticipantsChange";
    public static final String DIALOG_CHANGE_FIELD = "DialogChange";

    public static final String TTR = "ttrType";
    private static final String TTR_VALUE = "value";
    public String conversationId;
    public String dialogId;
    public String field;
    public ConversationState conversationState;
    public DialogState dialogState;
    public TTRType ttrType;
    public int ttrValue;
    public int csatNumberOfStars;
    public int csatYesNoValue;
    public CsatStatus csatStatus;
    public String type;
    private String closingCause;

    private List<ConversationField> conversationFieldList;

    public UpdateConversationField(String dialogId,
                                   String conversationId,
                                   String field,
                                   String closingCause,
                                   DialogState dialogState) {
        type = UPDATE;
        this.closingCause = closingCause;
        this.conversationId = conversationId;
        this.dialogId = dialogId;
        this.field = field;
        this.dialogState = dialogState;
    }

    public UpdateConversationField(String conversationId,
                                   String field,
                                   ConversationState conversationState) {
        this.conversationId = conversationId;
        this.field = field;
        this.conversationState = conversationState;
    }

    public UpdateConversationField(String convId, String field, int numberOfStars, int csatYesNoValue, CsatStatus status) {
        this.conversationId = convId;
        this.field = field;
        this.csatNumberOfStars = numberOfStars;
        this.csatYesNoValue = csatYesNoValue;
        this.csatStatus = status;
    }

    public UpdateConversationField(String convId, String field, TTRType ttrType, int value) {
        this.conversationId = convId;
        this.field = field;
        this.ttrType = ttrType;
        this.ttrValue = value;
    }

    public UpdateConversationField(String conversationId, String field, ArrayList<ConversationField> conversationFields) {
        this.conversationId = conversationId;
        this.field = field;
        this.conversationFieldList = conversationFields;
    }

    @Override
    public String getMessageType() {
        return UPDATE_CONVERSATION_FIELD_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        body.put(CONVERSATION_ID, conversationId);

        JSONObject conversationFieldObject = new JSONObject();
        JSONArray conversationFieldArray = new JSONArray();

        switch (field) {
            case CONVERSATION_STAGE_FIELD: {
                conversationFieldObject.put(FIELD, field);
                conversationFieldObject.put(CONVERSATION_STAGE, conversationState.name());
                break;
            }
            case CONVERSATION_STATE_FIELD: {
                conversationFieldObject.put(FIELD, field);
                conversationFieldObject.put(CONVERSATION_STATE, conversationState.name());
                break;
            }
            case CONVERSATION_CSAT_RATE: {
                conversationFieldObject.put(FIELD, field);
                if (csatYesNoValue > -1) {
                    conversationFieldObject.put(CONVERSATION_CSAT_YESNO_VALUE, csatYesNoValue == 1);
                }
                if (csatNumberOfStars == -1) {
                    conversationFieldObject.put(CONVERSATION_CSAT, JSONObject.NULL);
                } else {
                    conversationFieldObject.put(CONVERSATION_CSAT, csatNumberOfStars);
                }
                conversationFieldObject.put(CONVERSATION_CSAT_STATUS, csatStatus.name());
                break;
            }
            case TTR_FIELD: {
                conversationFieldObject.put(FIELD, field);
                conversationFieldObject.put(TTR, ttrType.name());
                conversationFieldObject.put(TTR_VALUE, ttrValue);
            }
            break;
            case DIALOG_CHANGE_FIELD: {
                conversationFieldObject.put(FIELD, field);
                JSONObject dialogObject = new JSONObject();
                dialogObject.put(DIALOG_ID, dialogId);
                dialogObject.put(STATE, dialogState.name());
                if (dialogState == DialogState.CLOSE) {
                    dialogObject.put(CLOSED_BY, CloseReason.CONSUMER.name());
//                    if (closingCause == null) {
//                        closingCause = "";
//                    }
                    //dialogObject.put("closedCause", closingCause); // This field is not needed anymore...
                }
                conversationFieldObject.put(CONVERSATION_ID, conversationId);
                conversationFieldObject.put(TYPE, type);
                conversationFieldObject.put(DIALOG, dialogObject);
            }
            break;
            case PARTICIPANTS_CHANGE_FIELD: {

                for (ConversationField field : conversationFieldList) {
                    JSONObject fieldObject = new JSONObject();
                    fieldObject.put(FIELD, PARTICIPANTS_CHANGE_FIELD);
                    fieldObject.put(TYPE, field.getType());
                    fieldObject.put(USER_ID, field.getUserId());
                    fieldObject.put(ROLE, field.getRole());

                    conversationFieldArray.put(fieldObject);
                }
            }
            break;
        }

        if (field.equals(PARTICIPANTS_CHANGE_FIELD)) {
            body.put(CONVERSATION_FIELD, conversationFieldArray);
        } else {
            body.put(CONVERSATION_FIELD, conversationFieldObject);
        }
        json.put(AbstractRequest.JSON_KEY_BODY, body);
    }
}
