package com.liveperson.api.response.events;

import android.text.TextUtils;

import com.liveperson.api.exception.BadMessageException;

import com.liveperson.api.response.model.Event;
import com.liveperson.api.response.model.OriginatorMetadata;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by oferd on 8/10/15.
 */
public class ContentEventNotification {
    public int sequence;
    public String originatorId;
    public long serverTimestamp;
    public Event event;
    public String dialogId;
    public String eventId;
	public OriginatorMetadata originatorMetadata;
	public JSONArray metadata;

    public ContentEventNotification(JSONObject jsonObject) throws JSONException,BadMessageException {
        /*
         {"originatorId":"985b11bdedf5865345dcb413c5fad46a17841cdd6daf3e0949cc340e5d0311b2","originatorMetadata":{"id":"985b11bdedf5865345dcb413c5fad46a17841cdd6daf3e0949cc340e5d0311b2","role":"CONSUMER"},"event":{"type":"ChatStateEvent","chatState":"BACKGROUND"},"dialogId":"bf54241d-17f6-47ae-bc8c-cf8ab7fd365c"}
         */
        sequence = jsonObject.optInt("sequence", -1);
        originatorId = jsonObject.optString("originatorId");
        String originatorPId = jsonObject.isNull("originatorPId") ? null : jsonObject.optString("originatorPId");
        if (!TextUtils.isEmpty(originatorPId)){
            originatorId = originatorPId;
        }

        serverTimestamp = jsonObject.optLong("serverTimestamp");
        dialogId = jsonObject.optString("dialogId");
        eventId = jsonObject.isNull("eventId") ? null : jsonObject.optString("eventId");
        JSONObject event = jsonObject.optJSONObject("event");
        if (event == null){
            this.event = null;
            return;
        }
        this.event = new Event(event);
		originatorMetadata = OriginatorMetadata.fromJson(jsonObject.optJSONObject("originatorMetadata"));

		metadata = jsonObject.optJSONArray("metadata");
    }

    @Override
    public String toString() {
        return event.toString();
    }
}