package com.liveperson.messaging.cache

import com.liveperson.messaging.model.Conversation

interface ConversationsCacheProvider {

    /**
     * Get conversation from cache by conversation id
     * @param conversationId the id of the conversation
     * @return the cached conversation or null if no conversation with this id could be found
     */
    fun getConversationFromCache(conversationId: String): Conversation?

    /**
     * Add a conversation to the cache
     * @param conversation the conversation to cache
     */
    fun cacheConversation(conversation: Conversation)

    /**
     * Remove a conversation from cache
     * @param targetId the target id
     * @param conversationId the id of the conversation to be removed
     */
    fun removeConversationFromCache(targetId: String, conversationId: String)
}
