package com.liveperson.messaging.commands;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.ThreadPoolExecutor;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.commands.tasks.GetAgentUserTask;
import com.liveperson.messaging.commands.tasks.GetClockTask;
import com.liveperson.messaging.commands.tasks.GetConsumerUserTask;
import com.liveperson.messaging.commands.tasks.HandlePendingMessagesTask;
import com.liveperson.messaging.commands.tasks.RefreshNotUpdatedConversationsTask;
import com.liveperson.messaging.commands.tasks.SubscribeExConversationsTask;
import com.liveperson.messaging.commands.tasks.UpdateConversationFieldTask;

import java.util.LinkedList;

/**
 * Created by ofira on 24/12/2015.
 */
public class InitAmsSessionCommand implements Command {

    private static final String TAG = "InitAmsSessionCommand";
    protected final Messaging mController;
    protected LinkedList<BaseAmsSocketConnectionTask> mTasks = new LinkedList<>();
    protected String mBrandId;
    protected ICallback<Object, Throwable> mCallback;

    /**
     * Create new InitAmsSessionCommand and also populate it with the predefined task
     */
    public InitAmsSessionCommand(Messaging controller, String brandId, ICallback<Object, Throwable> callback) {
        mController = controller;
        mBrandId = brandId;
        mCallback = callback;
        initTasks();
    }

    protected void initTasks() {
        mTasks.add(new GetClockTask(mController));
        mTasks.add(new UpdateConversationFieldTask(mController));
        mTasks.add(new GetConsumerUserTask(mController));
        mTasks.add(new HandlePendingMessagesTask(mController));
        mTasks.add(new RefreshNotUpdatedConversationsTask(mController));
        mTasks.add(new SubscribeExConversationsTask(mController));
        mTasks.add(new GetAgentUserTask(mController));
    }

    /**
     * Execute the connection process
     */
    @Override
    public void execute() {
        if (mTasks.size() != 0) {
            //TODO: Check if we need it here, or in the infra layer
            if (InternetConnectionService.isNetworkAvailable()) {
                ThreadPoolExecutor.execute(() -> {

                    BaseAmsSocketConnectionTask baseConnectionTask = mTasks.removeFirst();
                    baseConnectionTask.setBrandId(mBrandId);
                    baseConnectionTask.setCallback(new BaseAmsSocketConnectionCallback() {
                        @Override
                        public void onTaskSuccess() {
                            execute();
                        }

                        @Override
                        public void onTaskError(SocketTaskType type, Throwable exception) {
	                        LPLog.INSTANCE.d(TAG, type.name() + " failed");
                            mCallback.onError(exception);
                        }

                    });
                    baseConnectionTask.execute();
                });
            }
        } else {
            mCallback.onSuccess(null);
        }
    }
}
