package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.SynchronizedAmsConnectionUpdateCallback;

/**
 * Created by shiranr on 16/06/2016.
 */
public class HandlePendingMessagesTask extends BaseAmsSocketConnectionTask {

    private AmsMessages amsMessages;
    private AmsConversations amsConversations;
    private AmsDialogs amsDialogs;
    private ConnectionsController mConnectionController;


    private static final String TAG = "HandlePendingMessagesTask";

    public HandlePendingMessagesTask(Messaging controller) {
        this.amsMessages = controller.amsMessages;
        this.amsConversations = controller.amsConversations;
        this.amsDialogs = controller.amsDialogs;
        this.mConnectionController = controller.mConnectionController;
    }

    @Override
    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running mark all pending messages as failed task...");

        new SynchronizedAmsConnectionUpdateCallback(mConnectionController, mBrandId, () -> amsMessages.resendAllPendingMessages(mBrandId)).execute();

        amsConversations.markAllPendingConversationsAsFailed(mBrandId);
        amsDialogs.markPendingDialogsAsFailed(mBrandId);
        mCallback.onTaskSuccess();

        //send pending messages
        amsConversations.sendPendingMessage(mBrandId);
    }

}
