package com.liveperson.messaging.controller.connection;

import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.messaging.controller.connection.connectionevents.BackgroundEvent;
import com.liveperson.messaging.controller.connection.connectionevents.BackgroundTimeOutEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ConnectEvent;
import com.liveperson.messaging.controller.connection.connectionevents.DisconnectEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ForegroundEvent;
import com.liveperson.messaging.controller.connection.connectionevents.NetworkAvailableEvent;
import com.liveperson.messaging.controller.connection.connectionevents.NetworkLostEvent;
import com.liveperson.messaging.controller.connection.connectionevents.RunTaskEvent;
import com.liveperson.messaging.controller.connection.connectionevents.SecondaryConnectEvent;
import com.liveperson.messaging.controller.connection.connectionevents.SecondaryTaskSuccessEvent;
import com.liveperson.messaging.controller.connection.connectionevents.SendStateEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ServiceOffEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ServiceOnEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ShutDownEvent;
import com.liveperson.messaging.controller.connection.connectionevents.SocketProblemEvent;
import com.liveperson.messaging.controller.connection.connectionevents.TaskFailedEvent;
import com.liveperson.messaging.controller.connection.connectionevents.TaskSuccessEvent;
import com.liveperson.messaging.controller.connection.connectionevents.TaskTimeOutEvent;

/**
 * Created by shiranr on 13/03/2016.
 */
public class BaseConnectionState implements IState {
    protected final String TAG;
    protected final String name;
    BaseConnectionState parent;

    public BaseConnectionState(BaseConnectionState parent, String name, String logTag) {
        this.parent = parent;
        this.name = name;
        this.TAG = logTag;
    }

    public BaseConnectionState(String name, String logTag) {
        this(null, name, logTag);
    }

    public void actionOnEntry() {
		if (parent != null) {
			parent.actionOnEntry();
		}
	}

    public void actionOnExit() {
		if (parent != null) {
			parent.actionOnExit();
		}
    }

    public boolean isConnected() {
        return false;
    }
    public boolean isConnecting() {
        return false;
    }

    public String toString() {
        return this.name;
    }

    public void visit(DisconnectEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }

    public void visit(ConnectEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }

    public void visit(TaskSuccessEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }

    public void visit(SecondaryTaskSuccessEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }

    public void visit(TaskFailedEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }

    public void visit(RunTaskEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(TaskTimeOutEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(ShutDownEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(ServiceOnEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(ServiceOffEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(ForegroundEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(BackgroundEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(BackgroundTimeOutEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }

    /**
     * Send a state change event.
     *
     * @param ev event
     */
    public void visit(SendStateEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(NetworkLostEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(NetworkAvailableEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }

    public void visit(SecondaryConnectEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
    public void visit(SocketProblemEvent ev) {
        if (parent != null){
            parent.visit(ev);
        }
    }
}