package com.liveperson.messaging.controller.connection.connectionevents;

import com.liveperson.infra.model.types.FailureReason;
import com.liveperson.infra.statemachine.BaseEvent;
import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.controller.connection.BaseConnectionState;

/**
 * Created by shiranr on 13/03/2016.
 */
public class TaskFailedEvent extends BaseEvent {

    private final String mTaskName;
    private final TaskType type;
    private final Exception exception;
    private FailureReason failureReason;
    private LpError lpError;

    public TaskFailedEvent(String taskName, TaskType type, LpError lpError, Exception exception) {
        super("TaskFailedEvent");
        mTaskName = taskName;
        this.type = type;
        this.exception = exception;
        this.lpError = lpError;
    }

    public TaskFailedEvent(String taskName, TaskType type, LpError lpError, FailureReason reason, Exception exception) {
        super("TaskFailedEvent");
        mTaskName = taskName;
        this.type = type;
        this.exception = exception;
        this.failureReason = reason;
        this.lpError = lpError;
    }

    @Override
    public void accept(IState state) {
        ((BaseConnectionState) state).visit(this);
    }

    public TaskType getType() {
        return type;
    }

    public Exception getException() {
        return exception;
    }

    public String getTaskName() {
        return mTaskName;
    }

    public FailureReason getFailureReason() {
        return failureReason;
    }

    public LpError getLpError() {
        return lpError;
    }
}