package com.liveperson.messaging.network.socket.general_requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.GetClock;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.infra.utils.ClockUtils;

import org.json.JSONException;
import org.json.JSONObject;

import static com.liveperson.infra.errors.ErrorCode.ERR_000000C3;

/**
 * Created by Ilya Gazman on 11/4/2015.
 * <p/>
 * A clock request
 */
public class ClockRequest extends BaseAMSSocketRequest<GetClock.Response, ClockRequest> {

	private static final String TAG = "ClockRequest";

	private final String mBrandId;
    private ConnectionsController mConnectionController;

    public ClockRequest(ConnectionsController connectionController, String mSocketUrl, String brandId) {
        super(mSocketUrl);
        mBrandId = brandId;
        mConnectionController = connectionController;
    }

    @Override
    protected String getData() {
        return new GetClock().toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler<GetClock.Response, ClockRequest> getResponseHandler() {
        return new ClockResponseHandler();
    }

    public class ClockResponseHandler extends BaseResponseHandler<GetClock.Response, ClockRequest> {

        @Override
        public String getAPIResponseType() {
            return GetClock.Response.GET_CLOCK_RESPONSE_TYPE;
        }

        @Override
        protected GetClock.Response parse(JSONObject jsonObject) {
            GetClock.Response response = null;
            try {
                response = new GetClock.Response(jsonObject);

            } catch (JSONException e) {
                LPLog.INSTANCE.e(TAG, ERR_000000C3, "Error parsing get clock response", e);
            }
            return response;
        }

        @Override
        protected boolean handle(GetClock.Response data) {
            long clockDiff = System.currentTimeMillis() - data.body.currentTime;
            LPLog.INSTANCE.d(TAG, "The clock diff is " + clockDiff);
            mConnectionController.setClockDiff(mBrandId, clockDiff);
            ClockUtils.setClockDiff(clockDiff);

            return true;
        }
    }
}
