package com.liveperson.messaging.network.socket.requests;


import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UpdateConversationField;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;


public class ChangeConversationTTRRequest extends BaseAMSSocketRequest <ReqBody.StringResp, ChangeConversationTTRRequest> {

    private static final String TAG = "ChangeConversationTTRRequest";

    private String mConversationId;
    private TTRType mTTRType;
    private int mValue;

    public ChangeConversationTTRRequest(String socketUrl, String convServerId, TTRType type, int value) {
        super(socketUrl);
        mConversationId = convServerId;
        mTTRType = type;
        mValue = value;
    }

    @Override
    protected String getData() {
        return new UpdateConversationField(mConversationId, UpdateConversationField.TTR_FIELD, mTTRType, mValue).toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler<ReqBody.StringResp, ChangeConversationTTRRequest> getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, ChangeConversationTTRRequest>() {

            @Override
            public String getAPIResponseType() {
                return ReqBody.StringResp.REQ_BODY_RESPONSE_TYPE;
            }

            @Override
            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            @Override
            protected boolean handle(ReqBody.StringResp  data) {
                //send update only when notification will arrive.
                LPLog.INSTANCE.d(TAG, "Got change ttr response: " + data.getBody());
                return true;
            }
        };
    }
}



