package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UpdateConversationField;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;


/**
 * Created by Eyal Vites on 11/11/2015.
 */
public class ResolveConversationRequest extends BaseAMSSocketRequest <ReqBody.StringResp, ResolveConversationRequest> {

    private static final String TAG = "ResolveConversationRequest";

    private String conversationId;
    private ICallback<String, Throwable> callback;

    public ResolveConversationRequest(String socketUrl, String convServerId) {
        super(socketUrl);
        conversationId = convServerId;
    }

    @Override
    protected String getData() {
        return new UpdateConversationField(conversationId, UpdateConversationField.CONVERSATION_STATE_FIELD(), ConversationState.CLOSE).toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    public void setResponseCallBack(ICallback<String, Throwable> callBack) {
        this.callback = callBack;
    }

    @Override
    protected BaseResponseHandler<ReqBody.StringResp, ResolveConversationRequest> getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, ResolveConversationRequest>() {

            @Override
            public String getAPIResponseType() {
                return null;
            }

            @Override
            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            @Override
            protected boolean handle(ReqBody.StringResp response) {
                if (response.code > 201) {
                    LPLog.INSTANCE.w(TAG, "Received bad response (" + response.code + ").");
                    if (callback != null) {
                        callback.onError(new Exception("Failed to resolve conversation, response: " + response));
                    }
                } else {
                    if (callback != null) {
                        callback.onSuccess(response.getBody());
                    }
                }

                //send update only when notification will arrive.
                LPLog.INSTANCE.d(TAG, "Got resolve conversation response: " + response);
                return true;
            }
        };
    }
}



