package com.liveperson.messaging.utils;

import android.text.TextUtils;
import android.util.Base64;

import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;

import org.json.JSONObject;

import java.nio.charset.StandardCharsets;
import java.util.Date;

import static com.liveperson.infra.errors.ErrorCode.ERR_000000B9;
/**
 * Created by nirni on 11/7/17.
 */
public class TokenUtils {

	private static final String TAG = "TokenUtils";

	private static int jwtExpirationBuffer = -1;


	public static boolean isJwtExpired(String jwt) {

		// Get it once
		if(jwtExpirationBuffer != -1) {
			jwtExpirationBuffer = Configuration.getInteger(R.integer.lp_messaging_buffer_expiration_seconds);
		}

		if (TextUtils.isEmpty(jwt)) {
			//no jwt exists, we'll run normal flow
			return false;
		} else {
			LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "jwt exists: " + LPLog.INSTANCE.mask(jwt) + " checking if expired..");

			String [] segments = jwt.split("\\.");
			if (segments.length < 3){
				return false;
			}

			//take the second segment, decode it (base64), convert it to json object, and find "exp" value.
			try {
				byte[] secondSegmentsByte = Base64.decode(segments[1], Base64.DEFAULT);
				String secondSegments = new String(secondSegmentsByte, StandardCharsets.UTF_8);
				JSONObject secondSegmentsJson = new JSONObject(secondSegments);
				long expirationInSeconds = secondSegmentsJson.getLong("exp");

				long iat = secondSegmentsJson.getLong("iat");
				long expirationInMillis = expirationInSeconds * 1000;
				LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "expiration = " + new Date(expirationInMillis).toString());
				LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "iat = " + new Date(iat*1000).toString());

				if (isGoingToExpire(expirationInMillis)){
					LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "JWT is expired or about to.. ");
					return true;
				}else{
					LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "JWT is still valid ");
				}

			} catch (Exception e) {
				LPLog.INSTANCE.e(TAG, ERR_000000B9, "Exception while checking if JWT is expired.", e);
			}
			return false;

		}
	}

	private static boolean isGoingToExpire(long expirationInMillis) {
		long bufferTime = jwtExpirationBuffer*1000;
		long time = System.currentTimeMillis() + bufferTime;
		return time > expirationInMillis;
	}
}
