package com.liveperson.messaging.utils

import kotlin.math.max

private val VERSION_REGEX = Regex("^\\d+(\\.\\d+)?(\\.\\d+)?")

/**
 * Extension function to compare string versions of application.
 *
 * @param value version to compare.
 * @return true if version is bigger than compared and false otherwise.
 */
infix fun String.isVersionNewer(value: String): Boolean {
    if (isNotBlank() && matches(VERSION_REGEX) && value.isBlank()) return true
    if ((isBlank() && value.isNotBlank() && value.matches(VERSION_REGEX)) || equals(value)) return false

    val current = splitAsVersion()
    val other = value.splitAsVersion()
    val maximumSize = max(current.size, other.size)

    for (i in 0 until maximumSize)  {
        val versionCurrent = current.getOrNull(i)?.toIntOrNull() ?: Integer.MAX_VALUE
        val versionOther = other.getOrNull(i)?.toIntOrNull() ?: Integer.MAX_VALUE
        if (versionCurrent > versionOther) {
            return true
        }
    }
    return false
}

/**
 * Extension function used to split version due to version patterns
 * @see VERSION_REGEX
 *
 * @return array of versions from major to minor if pattern matches
 * or array with only major version equals to [Integer.MIN_VALUE] otherwise.
 */
private fun String.splitAsVersion() = VERSION_REGEX.findAll(this)
    .lastOrNull()
    ?.value
    ?.also { println(it) }
    ?.split(".")
    ?: listOf("${Integer.MIN_VALUE}")