package com.liveperson.messaging.wm


/**
 * Interface used to handle event published from Dynamic Welcome Message API.
 *
 * @see WelcomeMessageBroadcastReceiver for more information about listener usage.
 */
interface WelcomeMessageEventListener {

    /**
     * Called when dynamic welcome message changed or
     * response of welcome message handled.
     *
     * @param event event that was handled from Dynamic Welcome Message API.
     * Note: there are 2 possible event could be
     * produced by Dynamic Welcome Message Api.
     * - Welcome message changed (content changed or cleared)
     * - Welcome message response completed.
     */
    fun onEventReceived(event: String)
}