/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.api.LivePersonCallback;
import com.liveperson.api.request.GeneratedUploadTokenField;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.PushType;
import com.liveperson.infra.PushUnregisterType;
import com.liveperson.infra.R;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.callbacks.InitLivePersonCallBack;
import com.liveperson.infra.callbacks.LogoutLivePersonCallBack;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.eventmanager.EventManagerService;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.ConsumerManager;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.network.socket.GeneralResponseHandler;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.infra.sdkstatemachine.init.InfraInitData;
import com.liveperson.infra.sdkstatemachine.logout.PreLogoutCompletionListener;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownAsync;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;
import com.liveperson.infra.statemachine.InitProcess;
import com.liveperson.infra.statemachine.LogoutProcess;
import com.liveperson.infra.statemachine.ShutDownProcess;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.FileUtils;
import com.liveperson.infra.utils.LPAudioUtils;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.infra.utils.MessageValidator;
import com.liveperson.messaging.ActionFailureReason;
import com.liveperson.messaging.GeneralMessagingResponseHandler;
import com.liveperson.messaging.IMessaging;
import com.liveperson.messaging.LivePersonEventsProxy;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.MessagingInitData;
import com.liveperson.messaging.background.BackgroundActionsService;
import com.liveperson.messaging.background.FileSharingManager;
import com.liveperson.messaging.background.filesharing.FileExtensionTypes;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.commands.ChangeChatStateCommand;
import com.liveperson.messaging.commands.ChangeConversationTTRCommand;
import com.liveperson.messaging.commands.CloseDialogCommand;
import com.liveperson.messaging.commands.DeliveryStatusUpdateCommand;
import com.liveperson.messaging.commands.ResendFormSubmissionMessageCommand;
import com.liveperson.messaging.commands.ResendMessageCommand;
import com.liveperson.messaging.commands.ResendURLMessageCommand;
import com.liveperson.messaging.commands.ResolveConversationCommand;
import com.liveperson.messaging.commands.SendCsatCommand;
import com.liveperson.messaging.commands.SendFormSubmissionMessageCommand;
import com.liveperson.messaging.commands.SendGenerateUploadTokenCommand;
import com.liveperson.messaging.commands.SendMessageCommand;
import com.liveperson.messaging.commands.SendMessageWithURLCommand;
import com.liveperson.messaging.commands.SendSetUserProfileCommand;
import com.liveperson.messaging.commands.pusher.GetIsPusherRegisteredCommand;
import com.liveperson.messaging.commands.pusher.GetUnreadMessagesCountCommand;
import com.liveperson.messaging.commands.pusher.PusherHelper;
import com.liveperson.messaging.commands.pusher.RegisterPusherCommand;
import com.liveperson.messaging.commands.pusher.UnregisterPusherCommand;
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.controller.AmsReadController;
import com.liveperson.messaging.controller.ClientProperties;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.model.AgentData;
import com.liveperson.messaging.model.AmsAccount;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsFiles;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.Form;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.model.QuickRepliesMessageHolder;
import com.liveperson.messaging.model.UserProfile;
import com.liveperson.messaging.offline.OfflineMessagesControllerImpl;
import com.liveperson.messaging.offline.OfflineMessagingManager;
import com.liveperson.messaging.utils.VersionUtilsKt;
import com.liveperson.messaging.wm.WelcomeMessageManager;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.model.EngagementDetails;
import com.liveperson.monitoring.sdk.MonitoringParams;
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.responses.LPEngagementResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Messaging
implements IMessaging,
ShutDownAsync,
Clearable {
    private static final String TAG = "Messaging";
    public static final int NO_FILE_ROW_ID = -1;
    private static final String SUBMISSION_ID = "submissionId";
    private static final String INVITATION_ID = "invitationId";
    private static final String FORM_TITLE = "formTitle";
    private static final String SDK_VERSION_ENCRYPTION_ADDED = "5.18.0";
    public ConnectionsController mConnectionController;
    public AccountsController mAccountsController;
    public AmsMessages amsMessages;
    public AmsConversations amsConversations;
    public AmsDialogs amsDialogs;
    public AmsUsers amsUsers;
    public AmsFiles amsFiles;
    private boolean isStillBusyFetching;
    private boolean mUploadUsingService;
    private ClientProperties mClientProperties;
    public AmsReadController amsReadController;
    public LivePersonEventsProxy mEventsProxy = new LivePersonEventsProxy();
    private MessageValidator mMessageValidator;
    private FileSharingManager mFileSharingManager;
    private PendingIntent mImageServicePendingIntent = null;
    private Notification.Builder mImageForegroundServiceUploadNotificationBuilder = null;
    private Notification.Builder mImageForegroundServiceDownloadNotificationBuilder = null;
    private boolean mEnableStructuredContent;
    private MessagingEventSubscriptionManager mMessagingEventSubscriptionManager;
    private ConversationViewParams mConversationViewParams;
    private LPAudioUtils mAudioUtils;
    private int mMaxNumberOfStoredImageFiles;
    private int mMaxNumberOfStoredVoiceFiles;
    private int mMaxNumberOfStoredDocumentFiles;
    private String clientOnlySystemMessage;
    private String realTimeSystemMessage;
    private WelcomeMessageManager mWelcomeMessageManager;
    private OfflineMessagingManager mOfflineMessagingManager;
    private final String KEY_DID_CLEAR_HISTORY = "KEY_DID_CLEAR_HISTORY";
    private String mActiveBrandId;

    private void initMembers(Context context) {
        this.mConnectionController = new ConnectionsController(this);
        this.mAccountsController = new AccountsController(this.mClientProperties);
        this.amsMessages = new AmsMessages(this);
        this.amsConversations = new AmsConversations(this);
        this.amsDialogs = new AmsDialogs(this);
        this.amsUsers = new AmsUsers();
        this.amsFiles = new AmsFiles();
        this.amsReadController = new AmsReadController(this);
        this.mUploadUsingService = Configuration.getBoolean((int)R.bool.upload_photo_using_service);
        this.mFileSharingManager = new FileSharingManager(this, context);
        this.mEnableStructuredContent = Configuration.getBoolean((int)R.bool.enable_structured_content);
        this.mMessagingEventSubscriptionManager = new MessagingEventSubscriptionManager();
        this.mMaxNumberOfStoredImageFiles = Configuration.getInteger((int)R.integer.max_number_stored_images);
        this.mMaxNumberOfStoredVoiceFiles = Configuration.getInteger((int)R.integer.max_number_stored_voice_files);
        this.mMaxNumberOfStoredDocumentFiles = Configuration.getInteger((int)R.integer.max_number_stored_documents);
        this.mAudioUtils = new LPAudioUtils();
        this.mWelcomeMessageManager = WelcomeMessageManager.newInstance(this);
        OfflineMessagesControllerImpl offlineMessagesController = new OfflineMessagesControllerImpl(this);
        this.mOfflineMessagingManager = new OfflineMessagingManager(offlineMessagesController, this.amsConversations.getOfflineConversationsRepository(), this.amsDialogs.getOfflineDialogRepository(), this.amsMessages.getOfflineMessagesRepository(), this.mWelcomeMessageManager);
    }

    @Override
    public void init(final Context context, final MessagingInitData initData, final InitLivePersonCallBack callBack) {
        this.init(context, initData, new InitProcess(){

            public void init() {
                Messaging.this.initMessaging(context, initData);
            }

            public InitLivePersonCallBack getInitCallback() {
                return callBack;
            }
        });
    }

    @Override
    public void init(final Context context, final MessagingInitData initData, final InitProcess initProcess) {
        Infra.instance.init(context, (InfraInitData)initData, new InitProcess(){

            public InitLivePersonCallBack getInitCallback() {
                return initProcess.getInitCallback();
            }

            public void init() {
                Messaging.this.initMessaging(context, initData);
                initProcess.init();
            }
        });
    }

    public void initAnalyticsService(Context applicationContext, String brandId, String appId) {
        Infra.instance.initAnalyticsService(applicationContext, brandId, appId);
    }

    public void initMaskedMessage(Context context) {
        this.realTimeSystemMessage = context.getString(R.string.lp_system_message_real_time_masked);
        this.clientOnlySystemMessage = context.getString(R.string.lp_system_message_client_only_masked);
        this.mMessageValidator = null;
    }

    MessageValidator getMessageValidator(String brandId) {
        if (this.mMessageValidator == null) {
            AmsAccount account = this.mAccountsController.getAccount(brandId);
            if (account == null) {
                LPLog.INSTANCE.i(TAG, "Missing account for a consumer. SDK may not be initialized for brandId: " + brandId);
                return null;
            }
            boolean isAuthenticated = account.isAuthenticated();
            this.mMessageValidator = new MessageValidator(isAuthenticated, this.realTimeSystemMessage, this.clientOnlySystemMessage);
        }
        return this.mMessageValidator;
    }

    private void initMessaging(Context context, MessagingInitData initData) {
        LPLog.INSTANCE.d(TAG, "Initializing...");
        if (initData != null) {
            this.mActiveBrandId = initData.getBrandId();
        }
        String oldSdkVersionStr = PreferenceManager.getInstance().getStringValue("SDK_VERSION_PREFERENCE_KEY", "appLevelPreferences", initData.getSdkVersion());
        this.updateClientProperties(initData);
        this.initMembers(context);
        this.clearSecondaryInfoIfNeeded(oldSdkVersionStr, initData.getBrandId());
        this.mConnectionController.initConnectionReceiver();
        this.bootstrapRegistration();
    }

    private void updateClientProperties(MessagingInitData initData) {
        if (initData != null) {
            this.mClientProperties = new ClientProperties(initData.getAppId(), initData.getSdkVersion());
        } else if (this.mClientProperties == null) {
            this.mClientProperties = new ClientProperties();
        }
    }

    public boolean isConversationEmptyOrClose(String brandId) {
        if (this.amsConversations == null) {
            LPLog.INSTANCE.i(TAG, "amsConversations is null when checking conversation state. Return true by default.");
            return true;
        }
        Conversation conversation = this.amsConversations.getConversationFromTargetIdMap(brandId);
        return conversation == null || conversation.getState() == ConversationState.CLOSE;
    }

    private void bootstrapRegistration() {
        SocketManager.getInstance().putGeneralHandlerMap((GeneralResponseHandler)new GeneralMessagingResponseHandler(this));
    }

    @Override
    public void connect(String brandId, LPAuthenticationParams lpAuthenticationParams, @Nullable ConversationViewParams conversationViewParams, boolean connectInBackground) {
        this.initBrand(brandId, lpAuthenticationParams, conversationViewParams);
        LPLog.INSTANCE.d(TAG, "Connecting to brand " + brandId);
        this.mConnectionController.connect(brandId, connectInBackground);
    }

    @Override
    public void connect(String brandId, LPAuthenticationParams lpAuthenticationParams, @Nullable ConversationViewParams conversationViewParams) {
        this.connect(brandId, lpAuthenticationParams, conversationViewParams, false);
    }

    @Override
    public void reconnect(String brandId, LPAuthenticationParams lpAuthenticationParams) {
        LPLog.INSTANCE.d(TAG, "reconnect: set a new authentication key for brand with lpAuthenticationParams of type " + lpAuthenticationParams.getAuthType());
        this.connect(brandId, lpAuthenticationParams, null, false);
    }

    @Override
    public void moveToBackground(String brandId, long timeout) {
        MessagingFactory.getInstance().getController().getAudioUtils().getPlayingAudioManager().stopAllCurrentlyPlaying();
        try {
            PusherHelper.Companion.cleanup();
            Infra.instance.getAnalyticsService().sendAnalyticsDataToLoggos(true);
            PushMessagePreferences.INSTANCE.cleanUp(brandId);
            if (!this.mAccountsController.isInUnAuthMode(brandId)) {
                this.amsMessages.removeLastOutboundMessage().execute();
            }
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000006C, "moveToBackground: Failed to clear acknowledged conversations", (Throwable)error);
        }
        this.mConnectionController.moveToBackground(brandId, timeout);
    }

    @Override
    public void moveToForeground(String brandId, LPAuthenticationParams lpAuthenticationParams, @Nullable ConversationViewParams conversationViewParams) {
        LPLog.INSTANCE.d(TAG, "moveToForeground: brandId = " + brandId);
        this.initBrand(brandId, lpAuthenticationParams, conversationViewParams);
        this.mConnectionController.moveToForeground(brandId);
        if (this.isConversationEmptyOrClose(brandId) && lpAuthenticationParams.getAuthType() == LPAuthenticationType.AUTH) {
            ConversationUtils conversationUtils = new ConversationUtils(MessagingFactory.getInstance().getController());
            conversationUtils.updateOutboundCampaignMessage(brandId);
        }
    }

    @Override
    public void onConversationDestroyed(String brandId) {
        ConsumerManager consumerManager = Infra.instance.getConsumerManager();
        if (consumerManager != null) {
            consumerManager.resetAuthState();
        } else {
            LPLog.INSTANCE.w(TAG, "onConversationDestroyed: Consumer manager is not initialized");
        }
    }

    @Override
    public void serviceStarted(String brandId) {
        LPLog.INSTANCE.d(TAG, "serviceStarted: brandId = " + brandId);
        this.mConnectionController.serviceStarted(brandId);
    }

    @Override
    public void serviceStopped(String brandId) {
        LPLog.INSTANCE.d(TAG, "serviceStopped: brandId = " + brandId);
        this.mConnectionController.serviceStopped(brandId);
    }

    private void initBrand(String brandId, LPAuthenticationParams lpAuthenticationParams, @Nullable ConversationViewParams conversationViewParams) {
        LPLog.INSTANCE.d(TAG, "Init brand " + brandId);
        this.mAccountsController.addNewAccount(brandId);
        this.mAccountsController.setLPAuthenticationParams(brandId, lpAuthenticationParams);
        if (conversationViewParams != null) {
            this.setConversationViewParams(conversationViewParams);
        }
        this.mConnectionController.addNewConnection(brandId);
    }

    public void onMessageTimeout(String brandId) {
        this.mConnectionController.connect(brandId);
    }

    @Override
    public void sendMessageWithURL(String targetId, String brandId, String message, String urlToParse, String title, String description, String imageURL, String siteName) {
        MaskedMessage maskedMessage = this.getMessageValidator(brandId).maskMessage(message, true);
        DataBaseExecutor.execute(() -> new SendMessageWithURLCommand(this, targetId, brandId, maskedMessage, urlToParse, title, description, imageURL, siteName).execute());
    }

    @Override
    public void sendMessage(String targetId, String brandId, String message, @Nullable DeliveryStatusUpdateInfo info) {
        MaskedMessage maskedMessage = this.getMessageValidator(brandId).maskMessage(message, true);
        DataBaseExecutor.execute(() -> {
            if (maskedMessage != null && !TextUtils.isEmpty((CharSequence)maskedMessage.getServerMessage())) {
                new SendMessageCommand(this, targetId, brandId, maskedMessage, info).execute();
            } else {
                LPLog.INSTANCE.i(TAG, "cannot send empty message");
            }
        });
    }

    @Override
    public MaskedMessage getMaskedMessage(String brandId, String message) {
        MessageValidator messageValidator = this.getMessageValidator(brandId);
        return messageValidator == null ? new MaskedMessage(message, message, false, null) : messageValidator.maskMessage(message, true);
    }

    @Override
    public int resendMessage(String eventId, String dialogId, MessagingChatMessage.MessageType messageType, boolean offlineFlow) {
        return this.resendMessage(eventId, dialogId, -1L, messageType, offlineFlow);
    }

    @Override
    public int resendMessage(String eventId, String dialogId, long fileRowId, MessagingChatMessage.MessageType messageType, boolean offlineFlow) {
        if (this.isDialogClosed(dialogId) && !"TEMP_DIALOG".equals(dialogId)) {
            LPLog.INSTANCE.i(TAG, "Resend message- conversation does not exists or closed.");
            return R.string.lp_resend_failed_conversation_closed;
        }
        if (MessagingChatMessage.MessageType.isConsumerMaskedMessage(messageType) && !offlineFlow) {
            LPLog.INSTANCE.i(TAG, "Resend message- message is masked, resend is not available.");
            return R.string.lp_resend_failed_masked_message;
        }
        OfflineMessagingManager manager = this.mOfflineMessagingManager;
        if (manager != null && manager.isOfflineModeEnabled() && !manager.isFullySynced() && !offlineFlow) {
            return -1;
        }
        this.amsMessages.getMessageByEventId(eventId).setPostQueryOnBackground(data -> {
            Dialog dialog = (Dialog)this.amsDialogs.queryDialogById(dialogId).executeSynchronously();
            if (data != null) {
                String message = data.getMessage();
                switch (messageType) {
                    case CONSUMER_IMAGE_MASKED: 
                    case CONSUMER_IMAGE: 
                    case CONSUMER_DOCUMENT: {
                        String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(data.getContentType());
                        if (extension == null) break;
                        this.reSendFileMessage(FileSharingType.getFileTypeFromExtension(extension), dialog.getBrandId(), dialog.getTargetId(), eventId, message, data.getTimeStamp(), fileRowId);
                        break;
                    }
                    case CONSUMER_VOICE: {
                        this.reSendFileMessage(FileSharingType.VOICE, dialog.getBrandId(), dialog.getTargetId(), eventId, message, data.getTimeStamp(), fileRowId);
                        break;
                    }
                    case CONSUMER_URL: 
                    case CONSUMER_URL_MASKED: {
                        MaskedMessage maskedMessage = this.getMessageValidator(dialog.getBrandId()).maskMessage(message, true);
                        new ResendURLMessageCommand(this, eventId, dialog.getTargetId(), dialog.getBrandId(), maskedMessage).execute();
                        break;
                    }
                    case CONSUMER_FORM: {
                        this.resendFormSubmissionMessageCommand(eventId, message);
                        break;
                    }
                    default: {
                        ResendMessageCommand resendMessageCommand;
                        MaskedMessage maskedMessage = this.getMessageValidator(dialog.getBrandId()).maskMessage(message, true);
                        if (TextUtils.isEmpty((CharSequence)data.getMetadata())) {
                            resendMessageCommand = new ResendMessageCommand(this, eventId, dialog.getTargetId(), dialog.getBrandId(), maskedMessage);
                        } else {
                            try {
                                JSONArray metadata = new JSONArray(data.getMetadata());
                                resendMessageCommand = new ResendMessageCommand(this, eventId, dialog.getTargetId(), dialog.getBrandId(), maskedMessage, new DeliveryStatusUpdateInfo(metadata));
                            }
                            catch (JSONException e) {
                                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000006D, "Failed to parse JSON", (Throwable)e);
                                resendMessageCommand = new ResendMessageCommand(this, eventId, dialog.getTargetId(), dialog.getBrandId(), maskedMessage);
                            }
                        }
                        resendMessageCommand.execute();
                    }
                }
            }
        }).execute();
        return -1;
    }

    public boolean isDialogClosed(String dialogId) {
        boolean isDialogClosed = false;
        Dialog dialog = this.amsDialogs.getDialogById(dialogId);
        if (dialog == null || dialog.getState() == DialogState.CLOSE) {
            LPLog.INSTANCE.d(TAG, "isDialogClosed - dialog (dialogId = " + dialogId + ") does not exists or closed. (dialog = " + (dialog == null ? "null" : dialog.getState()) + ")");
            isDialogClosed = true;
        }
        return isDialogClosed;
    }

    private void reSendFileMessage(FileSharingType fileSharingType, final String brandId, String targetId, final String eventId, String message, long originalMessageTime, long fileRowId) {
        Context applicationContext = Infra.instance.getApplicationContext();
        if (!this.mUploadUsingService) {
            LPLog.INSTANCE.d(TAG, "reSendImageMessage: re-uploading photo without a service");
            this.mFileSharingManager.reUploadFile(fileSharingType, brandId, targetId, message, eventId, originalMessageTime, fileRowId, new FileSharingManager.FileUploadProgressListener(){

                @Override
                public void onDoneUpload() {
                    LPLog.INSTANCE.d(Messaging.TAG, "onDoneUpload!");
                }

                @Override
                public void onFailedUpload(Throwable exception) {
                    DataBaseExecutor.execute(() -> Messaging.this.getOfflineManager().removePendingOfflineMessage(brandId, eventId));
                    LPLog.INSTANCE.d(Messaging.TAG, "onFailedUpload! ", exception);
                }
            });
        } else {
            LPLog.INSTANCE.d(TAG, "reSendImageMessage: re-uploading photo using a service");
            Intent intent = new Intent(applicationContext, BackgroundActionsService.class);
            intent.putExtra("extra_action_type", 3);
            intent.putExtra("extra_file_type", fileSharingType.ordinal());
            intent.putExtra("service_extra_brand_id", brandId);
            intent.putExtra("service_extra_target_id", targetId);
            intent.putExtra("service_extra_message", message);
            intent.putExtra("service_extra_event_id", eventId);
            intent.putExtra("extra_original_message_time", originalMessageTime);
            intent.putExtra("service_extra_file_row_id", fileRowId);
            applicationContext.startService(intent);
        }
    }

    @Override
    public void sendFileMessage(FileSharingType fileSharingType, String brandId, String targetId, String imageUriString, String message, boolean imageFromCamera) {
        Context applicationContext = Infra.instance.getApplicationContext();
        if (this.mUploadUsingService) {
            LPLog.INSTANCE.d(TAG, "startUploadPhoto: uploading photo using a service");
            Intent intent = new Intent(applicationContext, BackgroundActionsService.class);
            intent.putExtra("extra_action_type", 1);
            intent.putExtra("extra_file_type", fileSharingType.ordinal());
            intent.putExtra("service_extra_brand_id", brandId);
            intent.putExtra("service_extra_target_id", targetId);
            intent.putExtra("service_extra_file_uri", imageUriString);
            intent.putExtra("service_extra_file_caption", message);
            intent.putExtra("service_extra_image_from_camera", imageFromCamera);
            applicationContext.startService(intent);
        } else {
            LPLog.INSTANCE.d(TAG, "startUploadPhoto: uploading photo without a service");
            this.mFileSharingManager.uploadFile(fileSharingType, brandId, targetId, imageUriString, message, imageFromCamera, new FileSharingManager.FileUploadProgressListener(){

                @Override
                public void onDoneUpload() {
                    LPLog.INSTANCE.d(Messaging.TAG, "onDoneUpload!");
                }

                @Override
                public void onFailedUpload(Throwable exception) {
                    LPLog.INSTANCE.d(Messaging.TAG, "onFailedUpload! ", exception);
                    Infra.instance.getApplicationHandler().post(() -> Toast.makeText((Context)Infra.instance.getApplicationContext(), (int)R.string.lp_failed_upload_toast_message, (int)1).show());
                }
            });
        }
    }

    @Override
    public void downloadFile(FileSharingType fileSharingType, String brandId, String targetId, String imageSwiftPath, long messageRowId, long fileRowId, String conversationId) {
        Context applicationContext = Infra.instance.getApplicationContext();
        if (this.mUploadUsingService) {
            LPLog.INSTANCE.d(TAG, "startUploadPhoto: uploading photo using a service");
            Intent intent = new Intent(applicationContext, BackgroundActionsService.class);
            intent.putExtra("extra_action_type", 2);
            intent.putExtra("extra_file_type", fileSharingType.ordinal());
            intent.putExtra("service_extra_brand_id", brandId);
            intent.putExtra("service_extra_target_id", targetId);
            intent.putExtra("service_extra_file_uri", imageSwiftPath);
            intent.putExtra("service_extra_file_row_id", fileRowId);
            intent.putExtra("service_extra_message_row_id", messageRowId);
            intent.putExtra("extra_conversation_id", conversationId);
            applicationContext.startService(intent);
        } else {
            this.mFileSharingManager.downloadFile(fileSharingType, brandId, targetId, imageSwiftPath, messageRowId, fileRowId, conversationId, new FileSharingManager.FileDownloadProgressListener(){

                @Override
                public void onDoneDownload() {
                    LPLog.INSTANCE.d(Messaging.TAG, "onDoneDownload!");
                }

                @Override
                public void onFailedDownload(Throwable exception) {
                    LPLog.INSTANCE.d(Messaging.TAG, "onFailedDownload! ", exception);
                    Infra.instance.getApplicationHandler().post(() -> Toast.makeText((Context)Infra.instance.getApplicationContext(), (int)R.string.lp_failed_download_toast_message, (int)1).show());
                }
            });
        }
    }

    @Override
    public void generateUploadToken(String formId, String brandId, final String invitationId) {
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        if (activeDialog == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000006E, "Failed to generate upload token, there's no active dialog!");
            MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(invitationId).setFormStatus(Form.FormStatus.ERROR);
            MessagingFactory.getInstance().getController().amsMessages.setDeliveryStatusUpdateCommand(MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(invitationId), DeliveryStatus.ERROR);
        } else {
            new SendGenerateUploadTokenCommand(this.mAccountsController.getConnectionUrl(brandId), formId, activeDialog.getDialogId(), invitationId, new ICallback<Object, Throwable>(){

                public void onSuccess(Object value) {
                    Messaging.this.amsMessages.mFormsManager.updateForm(invitationId, ((GeneratedUploadTokenField.Response.Body)value).readOtk, ((GeneratedUploadTokenField.Response.Body)value).writeOtk);
                    Form currentForm = Messaging.this.amsMessages.mFormsManager.getForm(invitationId);
                    if (currentForm == null) {
                        LPLog.INSTANCE.d(Messaging.TAG, "no form was found ");
                        return;
                    }
                    String url = currentForm.getOpenFormURL();
                    LPLog.INSTANCE.d(Messaging.TAG, "url = " + url);
                    Bundle bundle = new Bundle();
                    bundle.putString("url", url);
                    bundle.putString("invitation_id", invitationId);
                    bundle.putString("form_title", currentForm.getFormTitle());
                    LPLog.INSTANCE.d(Messaging.TAG, "Sending PCI update invitationId = " + LPLog.INSTANCE.mask((Object)invitationId) + " form title : " + LPLog.INSTANCE.mask((Object)currentForm.getFormTitle()));
                    LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_FORM_URL", (Bundle)bundle);
                }

                public void onError(Throwable exception) {
                    LPLog.INSTANCE.w(Messaging.TAG, "an error during generating OTK", exception);
                    MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(invitationId).setFormStatus(Form.FormStatus.ERROR);
                    MessagingFactory.getInstance().getController().amsMessages.setDeliveryStatusUpdateCommand(MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(invitationId), DeliveryStatus.ERROR);
                }
            }).execute();
        }
    }

    @Override
    public void sendFormSubmissionMessageCommand(String invitationId) {
        this.sendFormSubmissionMessageCommand(invitationId, null);
    }

    private void sendFormSubmissionMessageCommand(String invitationId, String existingEventId) {
        Form currentForm = this.amsMessages.mFormsManager.getForm(invitationId);
        if (currentForm == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000006F, "Failed to re-send form ID " + invitationId + " : form not found in FormsManager.");
            return;
        }
        try {
            JSONObject jo = new JSONObject();
            jo.put(SUBMISSION_ID, (Object)currentForm.getSubmissionId());
            jo.put(INVITATION_ID, (Object)currentForm.getInvitationId());
            this.amsMessages.mFormsManager.updateForm(currentForm.getInvitationId(), currentForm.getSubmissionId());
            Dialog dialog = this.amsDialogs.getDialogById(currentForm.getDialogId());
            MaskedMessage maskedMessage = this.getMessageValidator(dialog.getBrandId()).maskMessage(jo.toString(), false);
            if (maskedMessage == null) {
                currentForm.setFormStatus(Form.FormStatus.ERROR);
                this.updateMessage(currentForm.getInvitationId(), currentForm.getDialogId(), MessagingChatMessage.MessageType.AGENT_FORM, MessagingChatMessage.MessageState.ERROR);
                return;
            }
            maskedMessage.setServerMessage(jo.toString());
            jo.put(FORM_TITLE, (Object)currentForm.getFormTitle());
            maskedMessage.setDbMessage(jo.toString());
            if (!TextUtils.isEmpty((CharSequence)existingEventId)) {
                new ResendFormSubmissionMessageCommand(currentForm, existingEventId, maskedMessage, this).execute();
            } else {
                new SendFormSubmissionMessageCommand(currentForm, maskedMessage, this).execute();
            }
            this.updateMessage(currentForm.getInvitationId(), currentForm.getDialogId(), MessagingChatMessage.MessageType.AGENT_FORM, MessagingChatMessage.MessageState.SUBMITTED);
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000072, "JSONException while constructing JSON Object.", (Throwable)e);
        }
    }

    private void resendFormSubmissionMessageCommand(String eventId, String messageJsonString) {
        String invitationId = null;
        try {
            JSONObject messageObject = new JSONObject(messageJsonString);
            invitationId = messageObject.getString(INVITATION_ID);
        }
        catch (JSONException jsonE) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000070, "Failed to parse message JSON while re-sending Secure Form.", (Throwable)jsonE);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)invitationId)) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000071, "invitationID was null while re-sending Secure Form.");
            return;
        }
        this.sendFormSubmissionMessageCommand(invitationId, eventId);
    }

    @Override
    public void updateMessage(String invitationId, String dialogId, MessagingChatMessage.MessageType messageType, MessagingChatMessage.MessageState messageState) {
        Form currentForm = this.amsMessages.mFormsManager.getForm(invitationId);
        if (currentForm == null) {
            LPLog.INSTANCE.i(TAG, "pci update message- form does not exists or closed.");
            return;
        }
        Dialog dialog = this.amsDialogs.getDialogById(dialogId);
        if (dialog == null || dialog.getState() == DialogState.CLOSE) {
            LPLog.INSTANCE.i(TAG, "pci update message- dialog does not exists or closed.");
            return;
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(currentForm.getEventId());
        LPLog.INSTANCE.i(TAG, "pci update message- with eventID " + currentForm.getEventId() + " to state: " + (Object)((Object)messageState));
        this.amsMessages.updateMessagesState(l, messageState);
    }

    @Override
    public void removeMultipleOlderImages(String brandId) {
        LPLog.INSTANCE.d(TAG, "removeMultipleOlderFiles without service");
        this.mFileSharingManager.removeMultipleOlderFiles(brandId, this.mMaxNumberOfStoredImageFiles, FileExtensionTypes.getImageExtensions());
        this.mFileSharingManager.removeMultipleOlderFiles(brandId, this.mMaxNumberOfStoredVoiceFiles, FileExtensionTypes.getVoiceExtensions());
        this.mFileSharingManager.removeMultipleOlderFiles(brandId, this.mMaxNumberOfStoredDocumentFiles, FileExtensionTypes.getDocumentExtensions());
    }

    @Override
    public void registerPusher(String brandId, String appId, String token, PushType pushType, LPAuthenticationParams authenticationParams, ICallback<Void, Exception> registrationCompletedCallback) {
        new RegisterPusherCommand(this, brandId, appId, token, pushType, authenticationParams, registrationCompletedCallback).execute();
    }

    @Override
    public void updateTokenInBackground(String brandId, LPAuthenticationParams authenticationParams) {
        LPLog.INSTANCE.d(TAG, "updateTokenInBackground: Clearing token from account");
        this.connect(brandId, authenticationParams, null, true);
    }

    @Override
    public void unregisterPusherOnLiteLogout(String brandId, String consumerId) {
        new UnregisterPusherCommand(this, brandId, consumerId).execute();
    }

    @Override
    public void unregisterPusher(String brandId, String appId, PushUnregisterType type, ICallback<Void, Exception> unregisteringCompletedCallback, boolean isFullLogout) {
        new UnregisterPusherCommand(this, brandId, appId, type, unregisteringCompletedCallback, isFullLogout).execute();
    }

    @Override
    public void getNumUnreadMessages(String brandId, String appId, final ICallback<Integer, Exception> callback) {
        new GetUnreadMessagesCountCommand(this, brandId, appId, null, new ICallback<Integer, Exception>(){

            public void onSuccess(Integer value) {
                callback.onSuccess((Object)value);
            }

            public void onError(Exception exception) {
                callback.onError((Throwable)exception);
            }
        }).execute();
    }

    @Override
    public void getUnreadMessagesCount(String brandId, String appId, LPAuthenticationParams authenticationParams, final ICallback<Integer, Exception> callback) {
        new GetUnreadMessagesCountCommand(this, brandId, appId, authenticationParams, new ICallback<Integer, Exception>(){

            public void onSuccess(Integer value) {
                callback.onSuccess((Object)value);
            }

            public void onError(Exception exception) {
                callback.onError((Throwable)exception);
            }
        }).execute();
    }

    @Override
    public void isPusherRegistered(String brandId, String deviceToken, String appId, LPAuthenticationParams authenticationParams, @NonNull ICallback<Boolean, Exception> callback) {
        new GetIsPusherRegisteredCommand(this, brandId, deviceToken, appId, authenticationParams, callback).execute();
    }

    @Override
    public ActionFailureReason changeChatState(String targetId, String brandId, ChatState state) {
        ActionFailureReason failedReason = this.getConversationActionFailedReason(targetId, brandId);
        if (failedReason != null) {
            return failedReason;
        }
        new ChangeChatStateCommand(this.amsDialogs, this.mAccountsController.getConnectionUrl(brandId), state).execute();
        return null;
    }

    public ActionFailureReason closeCurrentDialog() {
        ActionFailureReason actionFailureReason;
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        if (activeDialog == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000073, "There's no active dialog. Aborting from closing dialog");
            actionFailureReason = ActionFailureReason.NOT_ACTIVE;
        } else {
            actionFailureReason = this.closeDialog(activeDialog.getBrandId());
        }
        return actionFailureReason;
    }

    private void refreshEngagement() {
        MonitoringParamsCache monitoringParamsCache = MonitoringFactory.INSTANCE.getMonitoring().getParamsCache();
        ArrayList identities = new ArrayList();
        if (monitoringParamsCache != null) {
            identities = monitoringParamsCache.getMonitoringIdentities();
        }
        MonitoringFactory.INSTANCE.getEngagement(Infra.instance.getApplicationContext(), (List)identities, new MonitoringParams(), null, new EngagementCallback(){

            public void onSuccess(@NonNull LPEngagementResponse lpEngagementResponse) {
                LPLog.INSTANCE.d(Messaging.TAG, "new Engagement received" + LPLog.INSTANCE.mask((Object)lpEngagementResponse));
                ConversationViewParams currentParams = Messaging.this.getConversationViewParams();
                List detailsList = lpEngagementResponse.getEngagementDetailsList();
                if (detailsList != null && !detailsList.isEmpty()) {
                    EngagementDetails details = (EngagementDetails)detailsList.get(0);
                    try {
                        CampaignInfo campaignInfo = currentParams.getCampaignInfo();
                        if (campaignInfo != null) {
                            campaignInfo.setContextId(details.getContextId());
                            currentParams.setCampaignInfo(campaignInfo);
                        }
                    }
                    catch (Exception e) {
                        LPLog.INSTANCE.w(Messaging.TAG, String.valueOf(e));
                    }
                }
            }

            public void onError(@NonNull MonitoringErrorType errorType, @Nullable Exception exception) {
                if (exception != null) {
                    LPLog.INSTANCE.w(Messaging.TAG, "getNewEngagement: onError " + errorType + " " + exception.getMessage());
                }
            }
        });
    }

    @Override
    public ActionFailureReason closeDialog(final String brandId) {
        boolean isDialogOpen;
        ActionFailureReason actionFailureReason = this.getConversationActionFailedReason(brandId, brandId);
        if (actionFailureReason != null) {
            return actionFailureReason;
        }
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        boolean bl = isDialogOpen = activeDialog != null && activeDialog.isOpen();
        if (isDialogOpen && AmsDialogs.isUmsSupportingDialogs()) {
            final CloseDialogCommand closeDialogCommand = new CloseDialogCommand(this.amsDialogs, activeDialog.getDialogId(), this.mAccountsController.getConnectionUrl(brandId));
            closeDialogCommand.setCallback(new ICallback<Integer, Exception>(){

                public void onSuccess(Integer value) {
                    closeDialogCommand.setCallback(null);
                    Messaging.this.sendBroadcastStopTyping();
                }

                public void onError(Exception exception) {
                    if (Integer.parseInt(exception.getMessage()) == 400) {
                        LPLog.INSTANCE.e(Messaging.TAG, FlowTags.DIALOGS, ErrorCode.ERR_00000074, "Failed to close dialog due to an error (with code 400), closing the whole conversation.", (Throwable)exception);
                        new ResolveConversationCommand(Messaging.this.amsConversations, brandId, Messaging.this.mAccountsController.getConnectionUrl(brandId)).execute();
                    }
                    closeDialogCommand.setCallback(null);
                }
            });
            closeDialogCommand.execute();
        } else {
            new ResolveConversationCommand(this.amsConversations, brandId, this.mAccountsController.getConnectionUrl(brandId)).execute();
        }
        return null;
    }

    public void closeDialog(String brandId, final String dialogId, final ICallback<Integer, Exception> callback) {
        final CloseDialogCommand closeDialogCommand = new CloseDialogCommand(this.amsDialogs, dialogId, this.mAccountsController.getConnectionUrl(brandId));
        closeDialogCommand.setCallback(new ICallback<Integer, Exception>(){

            public void onSuccess(Integer value) {
                closeDialogCommand.setCallback(null);
                if (callback != null) {
                    callback.onSuccess((Object)value);
                }
                Messaging.this.sendBroadcastStopTyping();
            }

            public void onError(Exception exception) {
                LPLog.INSTANCE.d(Messaging.TAG, "Exception when closing dialog " + dialogId + ": " + exception.getMessage());
                closeDialogCommand.setCallback(null);
                if (callback != null) {
                    callback.onError((Throwable)exception);
                }
            }
        });
        closeDialogCommand.execute();
    }

    public void refreshMonitoringEngagement() {
        if (this.mConversationViewParams != null && this.mConversationViewParams.getCampaignInfo() != null) {
            this.refreshEngagement();
        }
    }

    @Override
    public ActionFailureReason markConversationAsUrgent(String targetId, String brandId) {
        ActionFailureReason failedReason = this.getConversationActionFailedReason(targetId, brandId);
        if (failedReason != null) {
            return failedReason;
        }
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        ActionFailureReason changeTTRFailedReason = this.getDialogChangeTTRActionFailedReason(activeDialog);
        if (changeTTRFailedReason != null) {
            return changeTTRFailedReason;
        }
        new ChangeConversationTTRCommand(this.amsConversations, targetId, this.mAccountsController.getConnectionUrl(brandId), TTRType.URGENT).execute();
        return null;
    }

    @Override
    public ActionFailureReason markConversationAsNormal(String targetId, String brandId) {
        ActionFailureReason failedReason = this.getConversationActionFailedReason(targetId, brandId);
        if (failedReason != null) {
            return failedReason;
        }
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        ActionFailureReason changeTTRFailedReason = this.getDialogChangeTTRActionFailedReason(activeDialog);
        if (changeTTRFailedReason != null) {
            return changeTTRFailedReason;
        }
        new ChangeConversationTTRCommand(this.amsConversations, targetId, this.mAccountsController.getConnectionUrl(brandId), TTRType.NORMAL).execute();
        return null;
    }

    @Nullable
    private ActionFailureReason getConversationActionFailedReason(String targetId, String brandId) {
        if (!this.mConnectionController.isSocketReady(brandId) && !this.getOfflineManager().isOfflineWelcomeMessageEnabled()) {
            LPLog.INSTANCE.d(TAG, "Socket is not open");
            return ActionFailureReason.NO_NETWORK;
        }
        if (!this.amsConversations.isConversationActive(targetId)) {
            LPLog.INSTANCE.d(TAG, "There's no active dialog");
            return ActionFailureReason.NOT_ACTIVE;
        }
        return null;
    }

    @Nullable
    private ActionFailureReason getDialogChangeTTRActionFailedReason(Dialog activeDialog) {
        ActionFailureReason failureReason = null;
        if (activeDialog == null || !activeDialog.isOpen()) {
            failureReason = ActionFailureReason.NOT_ACTIVE;
        } else if (activeDialog.getDialogType() == DialogType.POST_SURVEY) {
            failureReason = ActionFailureReason.POST_SURVEY_IN_PROGRESS;
        }
        return failureReason;
    }

    public boolean canActiveDialogChangeTTR() {
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        ActionFailureReason dialogFailedReason = this.getDialogChangeTTRActionFailedReason(activeDialog);
        return dialogFailedReason == null;
    }

    @Override
    public void sendCSAT(String brandId, String conversationID, int mStarsNumber, int yesNoValue) {
        new SendCsatCommand(this.mAccountsController.getConnectionUrl(brandId), conversationID, mStarsNumber, yesNoValue).execute();
    }

    @Override
    public void sendUserProfile(String brandId, UserProfile userProfile) {
        new SendSetUserProfileCommand(this, brandId, userProfile).execute();
    }

    @Override
    public void setCallback(LivePersonCallback listener) {
        this.mEventsProxy.setCallback(listener);
    }

    @Override
    public void removeCallback() {
        this.mEventsProxy.removeCallback();
    }

    @Override
    public void checkActiveConversation(String targetId, ICallback<Boolean, Exception> callback) {
        this.amsConversations.getActiveConversation(targetId).setPostQueryOnBackground(data -> {
            boolean conversationOpen = false;
            if (data != null) {
                conversationOpen = true;
            }
            callback.onSuccess((Object)conversationOpen);
        }).execute();
    }

    @Override
    public void checkConversationIsMarkedAsUrgent(String targetId, ICallback<Boolean, Exception> callback) {
        this.amsConversations.getActiveConversation(targetId).setPostQueryOnBackground(data -> {
            boolean conversationUrgent = false;
            if (data != null && data.getConversationTTRType() == TTRType.URGENT && data.isConversationOpen()) {
                conversationUrgent = true;
            }
            callback.onSuccess((Object)conversationUrgent);
        }).execute();
    }

    @Override
    public void checkAgentID(String brandId, ICallback<AgentData, Exception> callback) {
        this.amsDialogs.queryActiveDialog(brandId).setPostQueryOnBackground(dialog -> {
            if (dialog != null) {
                Context context = Infra.instance.getApplicationContext();
                if (context == null) {
                    callback.onSuccess(null);
                    return;
                }
                boolean updateAlways = Configuration.getBoolean((int)R.bool.send_agent_profile_updates_when_conversation_closed);
                if (updateAlways || dialog.isOpen()) {
                    String agentOriginatorId = dialog.getAssignedAgentId();
                    if (TextUtils.isEmpty((CharSequence)agentOriginatorId)) {
                        callback.onSuccess(null);
                    } else {
                        this.amsUsers.getUserById(agentOriginatorId).setPostQueryOnBackground(profile -> {
                            if (profile != null) {
                                AgentData agentData = new AgentData();
                                agentData.mFirstName = profile.getFirstName();
                                agentData.mLastName = profile.getLastName();
                                agentData.mAvatarURL = profile.getAvatarUrl();
                                agentData.mEmployeeId = profile.getDescription();
                                agentData.mNickName = profile.getNickname();
                                agentData.mAgentId = agentOriginatorId;
                                callback.onSuccess((Object)agentData);
                                return;
                            }
                            callback.onSuccess(null);
                        }).execute();
                    }
                } else {
                    callback.onSuccess(null);
                }
            } else {
                callback.onSuccess(null);
            }
        }).execute();
    }

    @Override
    public boolean clearHistory(String targetId) {
        boolean conversationActive = this.amsConversations.isConversationActive(targetId);
        if (conversationActive) {
            LPLog.INSTANCE.w(TAG, "clearHistory: There is an open conversation. Cannot clear history");
            return false;
        }
        MessagingFactory.getInstance().getController().setClearHistoryFlag(targetId, true);
        this.amsMessages.clearMessagesOfClosedConversations(targetId).setPostQueryOnBackground(data -> LPLog.INSTANCE.d(TAG, "clearHistory: Removed " + data + " messages")).execute();
        this.amsDialogs.clearClosedDialogs(targetId).setPostQueryOnBackground(data -> LPLog.INSTANCE.d(TAG, "clearHistory: Removed " + data + " dialogs")).execute();
        this.amsConversations.clearClosedConversations(targetId).setPostQueryOnBackground(data -> LPLog.INSTANCE.d(TAG, "clearHistory: Removed " + data + " conversations")).execute();
        return true;
    }

    @Override
    public void clearAllConversationData(String targetId) {
        LPLog.INSTANCE.d(TAG, "clearAllConversationData");
        this.amsMessages.clearAllMessages(targetId).setPostQueryOnBackground(data -> {
            this.amsMessages.clear();
            this.amsDialogs.clearAllDialogs(targetId).setPostQueryOnBackground(data1 -> {
                this.amsDialogs.clear();
                this.amsConversations.clearAllConversations(targetId).setPostQueryOnBackground(data11 -> this.amsConversations.clear()).execute();
            }).execute();
        }).execute();
    }

    public String getOriginatorId(String targetId) {
        return this.amsUsers.getConsumerId(targetId);
    }

    public void onAgentDetailsChanged(MessagingUserProfile userProfile, boolean isDialogOpen) {
        Context context = Infra.instance.getApplicationContext();
        if (context == null) {
            return;
        }
        boolean updateAlways = Configuration.getBoolean((int)R.bool.send_agent_profile_updates_when_conversation_closed);
        if (updateAlways || isDialogOpen) {
            AgentData agentData = null;
            if (userProfile != null) {
                agentData = new AgentData();
                agentData.mFirstName = userProfile.getFirstName();
                agentData.mLastName = userProfile.getLastName();
                agentData.mAvatarURL = userProfile.getAvatarUrl();
                agentData.mEmployeeId = userProfile.getDescription();
                agentData.mNickName = userProfile.getNickname();
                agentData.mAgentId = userProfile.getOriginatorId();
            }
            this.mEventsProxy.onAgentDetailsChanged(agentData);
        }
    }

    public void shutDown(ShutDownCompletionListener listener) {
        LPLog.INSTANCE.d(TAG, "Shutting down...");
        this.messagingShutDown(listener);
    }

    @Override
    public void shutDown(final ShutDownProcess process) {
        Infra.instance.shutDown(new ShutDownProcess(){

            public void shutDown(final ShutDownCompletionListener listener) {
                process.shutDown(new ShutDownCompletionListener(){

                    public void shutDownCompleted() {
                        LPLog.INSTANCE.d(Messaging.TAG, "Shutting down...");
                        Messaging.this.messagingShutDown(listener);
                    }

                    public void shutDownFailed() {
                    }
                });
            }
        });
    }

    private void messagingShutDown(final ShutDownCompletionListener listener) {
        ShutDownCompletionListener messagingShutDownListener = new ShutDownCompletionListener(){

            public void shutDownCompleted() {
                listener.shutDownCompleted();
            }

            public void shutDownFailed() {
                listener.shutDownFailed();
            }
        };
        this.mConnectionController.shutDown(messagingShutDownListener);
        this.amsReadController.shutDown();
        this.amsMessages.shutDown();
        this.amsDialogs.shutDown();
        this.amsConversations.shutDown();
    }

    @Override
    public void liteLogout(String brandId, String oldConsumerId, String newConsumerId) {
        this.mConnectionController.clearLastUpdateTime(brandId);
        this.amsMessages.shutDown();
        this.amsDialogs.shutDown();
        this.amsDialogs.clear();
        this.amsConversations.shutDown();
        this.amsConversations.clear();
        this.amsUsers.clear();
        QuickRepliesMessageHolder.deleteFromSharedPreferences(brandId);
        PreferenceManager.getInstance().remove("KEY_TYPED_TEXT", brandId);
        this.unregisterPusherOnLiteLogout(brandId, oldConsumerId);
        this.amsMessages.removeAllMessages(brandId);
        Infra.instance.liteLogout();
        this.amsUsers.updateConsumerId(brandId, newConsumerId);
    }

    @Override
    public void logout(final Context context, final MessagingInitData initData, final boolean forceLogOut, final PushUnregisterType type, final LogoutProcess logoutProcess) {
        Infra.instance.logout(context, (InfraInitData)initData, new LogoutProcess(){

            public void initForLogout() {
                Messaging.this.initMessaging(context, initData);
                logoutProcess.initForLogout();
            }

            public void preLogout(final PreLogoutCompletionListener listener) {
                logoutProcess.preLogout(new PreLogoutCompletionListener(){

                    public void preLogoutCompleted() {
                        if (forceLogOut) {
                            listener.preLogoutCompleted();
                        }
                        Messaging.this.unregisterPusher(initData.getBrandId(), initData.getAppId(), type, new ICallback<Void, Exception>(){

                            public void onSuccess(Void value) {
                                if (!forceLogOut) {
                                    listener.preLogoutCompleted();
                                }
                            }

                            public void onError(Exception exception) {
                                if (!forceLogOut) {
                                    listener.preLogoutFailed(exception);
                                }
                            }
                        }, true);
                    }

                    public void preLogoutFailed(Exception e) {
                        listener.preLogoutFailed(e);
                    }
                });
            }

            public LogoutLivePersonCallBack getLogoutCallback() {
                return logoutProcess.getLogoutCallback();
            }

            public void shutDownForLogout(final ShutDownCompletionListener listener) {
                logoutProcess.shutDownForLogout(new ShutDownCompletionListener(){

                    public void shutDownCompleted() {
                        Messaging.this.messagingShutDown(listener);
                    }

                    public void shutDownFailed() {
                    }
                });
            }

            public void logout() {
                logoutProcess.logout();
                Messaging.this.clear();
            }
        });
    }

    public void clear() {
        this.amsConversations.clear();
        this.amsDialogs.clear();
        this.amsMessages.clear();
        this.amsUsers.clear();
        this.mAccountsController.clear();
        this.mConnectionController.clear();
        this.mClientProperties.clear();
        FileUtils.deleteFilesSync((File)Infra.instance.getApplicationContext().getFilesDir());
        if (this.mWelcomeMessageManager != null) {
            this.mWelcomeMessageManager.dispose();
            this.mWelcomeMessageManager.clearWelcomeMessage();
            this.mWelcomeMessageManager = null;
        }
        this.mMessageValidator = null;
    }

    @Override
    public boolean isSocketOpen(String brandId) {
        return this.mConnectionController.isSocketOpen(brandId);
    }

    @Override
    public boolean isInitialized() {
        return Infra.instance.isInitialized();
    }

    public String getInProgressUploadMessageRowIdsString() {
        LPLog.INSTANCE.d(TAG, "getInProgressUploadMessageRowIdsString: direct call (no service)");
        return this.mFileSharingManager.getInProgressUploadMessageRowIdsString();
    }

    public FileSharingManager getFileSharingManager() {
        return this.mFileSharingManager;
    }

    public boolean isEnableStructuredContent() {
        return this.mEnableStructuredContent;
    }

    public void setImageServicePendingIntent(PendingIntent imageServicePendingIntent) {
        this.mImageServicePendingIntent = imageServicePendingIntent;
    }

    public PendingIntent getImageServicePendingIntent() {
        return this.mImageServicePendingIntent;
    }

    public Notification.Builder getImageForegroundServiceUploadNotificationBuilder() {
        return this.mImageForegroundServiceUploadNotificationBuilder;
    }

    public Notification.Builder getImageForegroundServiceDownloadNotificationBuilder() {
        return this.mImageForegroundServiceDownloadNotificationBuilder;
    }

    public void setImageForegroundServiceUploadNotificationBuilder(Notification.Builder imageForegroundServiceNotificationBuilder) {
        this.mImageForegroundServiceUploadNotificationBuilder = imageForegroundServiceNotificationBuilder;
    }

    public void setImageForegroundServiceDownloadNotificationBuilder(Notification.Builder imageForegroundServiceNotificationBuilder) {
        this.mImageForegroundServiceDownloadNotificationBuilder = imageForegroundServiceNotificationBuilder;
    }

    public void sendDeliveryStatusUpdateCommand(String brandId, String dialogId, String conversationId, int sequence, DeliveryStatus deliveryStatus, DeliveryStatusUpdateInfo info) {
        new DeliveryStatusUpdateCommand(this.mAccountsController.getConnectionUrl(brandId), brandId, dialogId, conversationId, sequence, deliveryStatus, info).execute();
    }

    public ConversationViewParams getConversationViewParams() {
        return this.mConversationViewParams;
    }

    public void setConversationViewParams(ConversationViewParams conversationViewParams) {
        LPLog.INSTANCE.d(TAG, "Setting conversation view params : " + conversationViewParams);
        this.mConversationViewParams = conversationViewParams;
    }

    public MessagingEventSubscriptionManager getMessagingEventSubscriptionManager() {
        return this.mMessagingEventSubscriptionManager;
    }

    public LPAudioUtils getAudioUtils() {
        return this.mAudioUtils;
    }

    public boolean isStillBusyFetching() {
        return this.isStillBusyFetching;
    }

    public void setStillBusyFetching(boolean stillBusyFetching) {
        this.isStillBusyFetching = stillBusyFetching;
    }

    public Context getApplicationContext() {
        return Infra.instance.getApplicationContext();
    }

    public EventManagerService getEventManagerService() {
        return Infra.instance.getEventManagerService();
    }

    public void setClearHistoryFlag(String brandId, boolean value) {
        PreferenceManager.getInstance().setBooleanValue("KEY_DID_CLEAR_HISTORY", brandId, value);
    }

    public boolean getClearHistoryFlag(String brandId) {
        return PreferenceManager.getInstance().getBooleanValue("KEY_DID_CLEAR_HISTORY", brandId, false);
    }

    public void removeClearHistoryFlag(String brandId) {
        PreferenceManager.getInstance().remove("KEY_DID_CLEAR_HISTORY", brandId);
    }

    public boolean shouldApplyThumbnailBlur() {
        return PreferenceManager.getInstance().getBooleanValue("site_settings_thumbnail_blur_enabled_preference_key", "appLevelPreferences", false);
    }

    public void resetDBEncryptionService() {
        Infra.instance.resetDBEncryptionService();
    }

    public void sendBroadcastStopTyping() {
        Bundle nonTypingBundle = new Bundle();
        nonTypingBundle.putBoolean("is_typing", false);
        LocalBroadcast.sendBroadcast((String)"agent_typing", (Bundle)nonTypingBundle);
        LPLog.INSTANCE.d(TAG, "Sent broadcast non-typing after closing dialog successfully");
    }

    public String getActiveBrandId() {
        return this.mActiveBrandId;
    }

    public void setWelcomeMessageMetadata(String metadata, String brandId) {
        String encryptedData = null;
        if (metadata != null) {
            encryptedData = DBEncryptionHelper.encrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)metadata);
        }
        PreferenceManager.getInstance().setStringValue("KEY_WELCOME_MESSAGE_METADATA", brandId, encryptedData);
    }

    public String getWelcomeMessageMetadata(String brandId) {
        String encryptedData = PreferenceManager.getInstance().getStringValue("KEY_WELCOME_MESSAGE_METADATA", brandId, null);
        if (encryptedData != null) {
            return DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)encryptedData);
        }
        return null;
    }

    @Nullable
    public WelcomeMessageManager getWelcomeMessageManager() {
        return this.mWelcomeMessageManager;
    }

    private void clearSecondaryInfoIfNeeded(String oldSdkVersionStr, String brandId) {
        if (TextUtils.isEmpty((CharSequence)brandId) || TextUtils.isEmpty((CharSequence)oldSdkVersionStr)) {
            return;
        }
        if (VersionUtilsKt.isVersionNewer(SDK_VERSION_ENCRYPTION_ADDED, oldSdkVersionStr)) {
            LPLog.INSTANCE.d(TAG, "Encryption cleanup...");
            Infra.instance.getDBEncryptionService().clear();
            this.amsUsers.clearConsumerFromDB(brandId);
            QuickRepliesMessageHolder.updateQuickReplies(brandId, null);
        }
    }

    public OfflineMessagingManager getOfflineManager() {
        return this.mOfflineMessagingManager;
    }
}

