/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.controller.ClientProperties;
import com.liveperson.messaging.controller.connection.IConnectionParamsCache;
import com.liveperson.messaging.model.AmsAccount;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.text.StringsKt;

public class AccountsController
implements Clearable {
    private static final String TAG = "AccountsController";
    private static final String SOCKET_URL = "wss://%1$s/ws_api/account/%2$s/messaging/consumer";
    private static final String DOMAIN_VERSION_QUERY = "v";
    private static final int DOMAIN_VERSION_VALUE = 3;
    private Map<String, AmsAccount> mAccounts = new HashMap<String, AmsAccount>();
    private ClientProperties mClientProperties;

    public AccountsController(ClientProperties clientProperties) {
        this.mClientProperties = clientProperties;
    }

    public void addNewAccount(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            LPLog.INSTANCE.i(TAG, "Adding new account: " + brand);
            this.mAccounts.put(brand, new AmsAccount(brand));
        }
    }

    public String getToken(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "getToken: getAccount returns null for brand with id: " + brand);
            return null;
        }
        return account.getToken();
    }

    public List<String> getCertificatePinningKeys(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "getCertificatePinningKeys: getAccount returns null for brand with id: " + brand);
            return Collections.emptyList();
        }
        return account.getCertificatePinningKeys();
    }

    public boolean isTokenExpired(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "isTokenExpired: getAccount returns null for brand with id: " + brand);
            return false;
        }
        return account.isTokenExpired() || account.isHostAppJWTExpired();
    }

    public LPAuthenticationParams getLPAuthenticationParams(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "getLPAuthenticationParams: getAccount returns null for brand with id: " + brand);
            return null;
        }
        return account.getLPAuthenticationParams();
    }

    public void setLPAuthenticationParams(String brand, LPAuthenticationParams lpAuthenticationParams) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "setLPAuthenticationParams: getAccount returns null for brand with id: " + brand);
            return;
        }
        this.resetAuthStateIfNeeded(account, lpAuthenticationParams);
        account.setLPAuthenticationParams(lpAuthenticationParams);
    }

    public boolean setCSDSMap(String brand, HashMap<String, String> csdsUrls) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "setCSDSMap: getAccount returns null for brand with id: " + brand);
            return false;
        }
        boolean dataUpdatedWithNewValue = account.setCSDSMap(csdsUrls);
        this.initServices(brand);
        return dataUpdatedWithNewValue;
    }

    private void initServices(String brand) {
        String loggosDomain = this.getServiceUrl(brand, "loggos");
        List<String> certificates = this.getCertificatePinningKeys(brand);
        Infra.instance.getLoggos().init(brand, loggosDomain, certificates);
        Infra.instance.getEventManagerService().setDomain(this.getServiceUrl(brand, "eventManager"));
    }

    public boolean isCsdsDataMissing(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "isCsdsDataMissing: getAccount returns null for brand with id: " + brand);
            return false;
        }
        return account.isCsdsDataMissing();
    }

    public String getServiceUrl(String brand, String serviceName) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "getServiceUrl: getAccount returns null for brand with id: " + brand);
            return null;
        }
        return account.getServiceUrl(serviceName);
    }

    public IConnectionParamsCache getConnectionParamsCache(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "getConnectionParamsCache: getAccount returns null for brand with id: " + brandId);
            return null;
        }
        return account.getConnectionParamsCache();
    }

    public boolean isAutoMessagesEnabled(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "isAutoMessagesEnabled: getAccount returns null for brand with id: " + brandId);
            return false;
        }
        return account.isAutoMessagesEnabled();
    }

    public String getConnectionUrl(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "getConnectionUrl: getAccount returns null for brand with id: " + brandId);
            return null;
        }
        String connectionUrl = account.getServiceUrl("asyncMessagingEnt");
        String token = account.getToken();
        if (TextUtils.isEmpty((CharSequence)connectionUrl) || TextUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        String path = String.format(SOCKET_URL, connectionUrl, brandId);
        Uri fullUri = Uri.parse((String)path).buildUpon().appendQueryParameter(DOMAIN_VERSION_QUERY, String.valueOf(3)).build();
        return fullUri.toString();
    }

    public String getTokenizerUrl(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "getTokenizerUrl: getAccount returns null for brand with id: " + brandId);
            return null;
        }
        return account.getServiceUrl("tokenizer");
    }

    public String getConnectionUrlForLogs(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "getConnectionUrlForLogs: getAccount returns null for brand with id: " + brandId);
            return null;
        }
        String connectionUrl = account.getServiceUrl("asyncMessagingEnt");
        String token = account.getToken();
        if (TextUtils.isEmpty((CharSequence)connectionUrl) || TextUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        return String.format(SOCKET_URL, connectionUrl, brandId);
    }

    public AmsAccount getAccount(String brand) {
        return this.mAccounts.get(brand);
    }

    public void clear() {
        this.mAccounts.clear();
    }

    public ClientProperties getClientProperties() {
        return this.mClientProperties;
    }

    public boolean isInUnAuthMode(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000162, "isInUnAuthMode: getAccount returns null for brand with id: " + brandId);
            return false;
        }
        return account.isInUnAuthMode();
    }

    private void resetAuthStateIfNeeded(@NonNull AmsAccount account, @Nullable LPAuthenticationParams newAuthParams) {
        LPAuthenticationParams oldAuthParams = account.getLPAuthenticationParams();
        if (newAuthParams == null || oldAuthParams == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)newAuthParams.getAuthKey()) && !StringsKt.equals((String)newAuthParams.getAuthKey(), (String)oldAuthParams.getAuthKey(), (boolean)true)) {
            LPLog.INSTANCE.d(TAG, "Resetting auth state for code flow.");
            account.resetConsumerAuthState();
        } else if (!TextUtils.isEmpty((CharSequence)newAuthParams.getHostAppJWT()) && !StringsKt.equals((String)newAuthParams.getHostAppJWT(), (String)oldAuthParams.getHostAppJWT(), (boolean)true)) {
            LPLog.INSTANCE.d(TAG, "Resetting auth state for implicit flow.");
            account.resetConsumerAuthState();
        } else if (newAuthParams.getAuthType() != LPAuthenticationType.AUTH && !newAuthParams.equals((Object)oldAuthParams)) {
            LPLog.INSTANCE.d(TAG, "Resetting auth state for " + newAuthParams.getAuthType().name() + " flow.");
            account.resetConsumerAuthState();
        }
    }
}

