/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.GetUserProfile;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingUserProfile;
import org.json.JSONException;
import org.json.JSONObject;

public class GetUserProfileRequest
extends BaseAMSSocketRequest<GetUserProfile.Response, GetUserProfileRequest> {
    private static final String TAG = "GetUserProfile";
    private final String mBrandId;
    private final Messaging mController;
    private String mUserId = "";
    private UserProfile.UserType mType;
    private String serverConversationId = "";

    public GetUserProfileRequest(Messaging controller, String brandId, UserProfile.UserType type) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mBrandId = brandId;
        this.mType = type;
    }

    protected String getData() {
        return new GetUserProfile(this.mUserId).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<GetUserProfile.Response, GetUserProfileRequest> getResponseHandler() {
        return new BaseResponseHandler<GetUserProfile.Response, GetUserProfileRequest>(){

            public String getAPIResponseType() {
                return "userprofile.GetUserProfileResponse";
            }

            protected GetUserProfile.Response parse(JSONObject jsonObject) throws JSONException {
                return new GetUserProfile.Response(jsonObject);
            }

            protected boolean handle(GetUserProfile.Response data) {
                data.getBody().setUserType(GetUserProfileRequest.this.mType);
                MessagingUserProfile userProfile = new MessagingUserProfile(data.getBody());
                userProfile.setBrandID(GetUserProfileRequest.this.mBrandId);
                ((GetUserProfileRequest)GetUserProfileRequest.this).mController.amsMessages.onAgentReceived(userProfile);
                ((GetUserProfileRequest)GetUserProfileRequest.this).mController.amsUsers.updateUserProfile(userProfile);
                if (GetUserProfileRequest.this.mType == UserProfile.UserType.AGENT) {
                    ((GetUserProfileRequest)GetUserProfileRequest.this).mController.amsDialogs.queryDialogById(GetUserProfileRequest.this.serverConversationId).setPostQueryOnBackground(data1 -> {
                        if (TextUtils.equals((CharSequence)data1.getAssignedAgentId(), (CharSequence)GetUserProfileRequest.this.mUserId) && data1.getState() == DialogState.OPEN) {
                            LPLog.INSTANCE.d(GetUserProfileRequest.TAG, "onResult: Calling agent details callback");
                            GetUserProfileRequest.this.mController.onAgentDetailsChanged(userProfile, data1.isOpen());
                        }
                        LPLog.INSTANCE.d(GetUserProfileRequest.TAG, "got user details (" + LPLog.INSTANCE.mask((Object)GetUserProfileRequest.this.mUserId) + ") related to conversation: " + GetUserProfileRequest.this.serverConversationId);
                        ((GetUserProfileRequest)GetUserProfileRequest.this).mController.amsMessages.updateAgentDetailsUpdated(GetUserProfileRequest.this.serverConversationId);
                    }).execute();
                }
                return true;
            }
        };
    }
}

